/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.exportData;

import java.io.File;
import java.io.PrintStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportPreferences;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.AbstractDataExportFileWriter;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.IExportDataCell;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataExportXMLWriter
extends AbstractDataExportFileWriter {
    private DocumentBuilderFactory factory;
    private DocumentBuilder builder;
    private Document testDoc;
    private Element columns;
    private Element root;
    private Element rows;
    private Element row;

    public DataExportXMLWriter(File file, TableExportPreferences prefs, ProgressAbortCallback progressController) {
        super(file, prefs, progressController);
    }

    @Override
    protected void afterWorking() throws Exception {
        DOMSource source = new DOMSource(this.testDoc);
        PrintStream ps = new PrintStream(this.getFile());
        StreamResult result = new StreamResult(ps);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
    }

    @Override
    protected void addCell(IExportDataCell cell) throws Exception {
        String strCellValue = "";
        if (cell.getObject() != null) {
            strCellValue = this.getPrefs().isUseGlobalPrefsFormating() && cell.getColumnDisplayDefinition() != null ? CellComponentFactory.renderObject(cell.getObject(), cell.getColumnDisplayDefinition()) : cell.getObject().toString();
        }
        Element value = this.testDoc.createElement("value");
        value.setAttribute("columnNumber", String.valueOf(cell.getColumnIndex()));
        value.setTextContent(strCellValue);
        this.row.appendChild(value);
    }

    @Override
    protected void addHeaderCell(int colIdx, String columnName) throws Exception {
        Element columnEl = this.testDoc.createElement("column");
        columnEl.setAttribute("number", String.valueOf(colIdx));
        this.columns.appendChild(columnEl);
        Element columnNameEl = this.testDoc.createElement("name");
        columnNameEl.setTextContent(columnName);
        columnEl.appendChild(columnNameEl);
    }

    @Override
    protected void beforeWorking(File file) throws Exception {
        this.factory = DocumentBuilderFactory.newInstance();
        this.builder = this.factory.newDocumentBuilder();
        this.testDoc = this.builder.newDocument();
        this.root = this.testDoc.createElement("table");
        this.testDoc.appendChild(this.root);
        this.columns = this.testDoc.createElement("columns");
        this.root.appendChild(this.columns);
    }

    @Override
    public void beforeRow(int rowIdx) throws Exception {
        super.beforeRow(rowIdx);
        this.row = this.testDoc.createElement("row");
        this.row.setAttribute("rowNumber", String.valueOf(rowIdx));
        this.rows.appendChild(this.row);
    }

    @Override
    public void beforeRows() {
        super.beforeRows();
        this.rows = this.testDoc.createElement("rows");
        this.root.appendChild(this.rows);
    }
}

