/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbdiff.gui;

import java.awt.Component;
import java.awt.Frame;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrame;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dbdiff.ColumnDifference;
import net.sourceforge.squirrel_sql.plugins.dbdiff.TableDiffExecutor;
import net.sourceforge.squirrel_sql.plugins.dbdiff.gui.AbstractDiffPresentation;
import net.sourceforge.squirrel_sql.plugins.dbdiff.gui.ColumnDiffDialog;

public class TabularDiffPresentation
extends AbstractDiffPresentation {
    private static final ILogger s_log = LoggerController.createLogger(TabularDiffPresentation.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TabularDiffPresentation.class);
    private Thread execThread = null;
    private final List<ColumnDifference> colDifferences = new ArrayList<ColumnDifference>();

    @Override
    public void execute() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    TabularDiffPresentation.this._execute();
                }
                catch (Exception e) {
                    s_log.error((Object)("Unexpected exception encountered while executing diff: " + e.getMessage()), (Throwable)e);
                }
            }
        };
        this.execThread = new Thread(runnable);
        this.execThread.setName("DBDiff Executor Thread");
        this.execThread.start();
    }

    private void _execute() throws SQLException {
        IDatabaseObjectInfo[] destObjs;
        boolean encounteredException = false;
        IDatabaseObjectInfo[] sourceObjs = this.sessionInfoProvider.getSourceSelectedDatabaseObjects();
        if (!this.sanityCheck(sourceObjs, destObjs = this.sessionInfoProvider.getDestSelectedDatabaseObjects())) {
            return;
        }
        ISQLDatabaseMetaData sourceMetaData = this.sessionInfoProvider.getSourceSession().getMetaData();
        ISQLDatabaseMetaData destMetaData = this.sessionInfoProvider.getDestSession().getMetaData();
        Map<String, ITableInfo> tableMap1 = this.getTableMap(sourceMetaData, sourceObjs);
        Map<String, ITableInfo> tableMap2 = this.getTableMap(destMetaData, destObjs);
        Set<String> tableNames = this.getAllTableNames(tableMap1);
        tableNames.addAll(this.getAllTableNames(tableMap2));
        try {
            TableDiffExecutor diff = new TableDiffExecutor(sourceMetaData, destMetaData);
            if (sourceObjs.length == 1 && destObjs.length == 1) {
                diff.setTableInfos((ITableInfo)sourceObjs[0], (ITableInfo)destObjs[0]);
                diff.execute();
                this.colDifferences.addAll(diff.getColumnDifferences());
            } else {
                for (String table : tableNames) {
                    if (tableMap1.containsKey(table)) {
                        if (tableMap2.containsKey(table)) {
                            ITableInfo t1 = tableMap1.get(table);
                            ITableInfo t2 = tableMap2.get(table);
                            diff.setTableInfos(t1, t2);
                            diff.execute();
                            List<ColumnDifference> columnDiffs = diff.getColumnDifferences();
                            if (columnDiffs == null || columnDiffs.size() <= 0) continue;
                            this.colDifferences.addAll(columnDiffs);
                            for (ColumnDifference colDiff : columnDiffs) {
                                if (!s_log.isDebugEnabled()) continue;
                                s_log.debug((Object)colDiff.toString());
                            }
                            continue;
                        }
                        if (!s_log.isInfoEnabled()) continue;
                        s_log.info((Object)("Skipping Table (" + table + ") that exists in database (" + this.sourceSession + "), but not in the database (" + this.destSession + ")"));
                        continue;
                    }
                    if (!s_log.isInfoEnabled()) continue;
                    s_log.info((Object)("Skipping Table (" + table + ") that exists in database (" + this.destSession + "), but not in the database (" + this.sourceSession + ")"));
                }
            }
            final MainFrame frame = this.sourceSession.getApplication().getMainFrame();
            if (this.colDifferences != null && this.colDifferences.size() > 0) {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ColumnDiffDialog dialog = new ColumnDiffDialog((Frame)frame, false);
                        dialog.setColumnDifferences(TabularDiffPresentation.this.colDifferences);
                        dialog.setSession1Label(TabularDiffPresentation.this.sourceSession.getAlias().getName());
                        dialog.setSession2Label(TabularDiffPresentation.this.destSession.getAlias().getName());
                        dialog.setVisible(true);
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog((Component)frame, i18n.NO_DIFFS_MESSAGE, "DBDiff", 1);
                    }
                });
            }
        }
        catch (SQLException e) {
            s_log.error((Object)("Encountered unexpected exception while executing diff: " + e.getMessage()), (Throwable)e);
        }
    }

    private Set<String> getAllTableNames(Map<String, ITableInfo> tables) {
        HashSet<String> result = new HashSet<String>();
        result.addAll(tables.keySet());
        return result;
    }

    private Map<String, ITableInfo> getTableMap(ISQLDatabaseMetaData md, IDatabaseObjectInfo[] objs) throws SQLException {
        HashMap<String, ITableInfo> result = new HashMap<String, ITableInfo>();
        if (objs[0].getDatabaseObjectType() == DatabaseObjectType.TABLE) {
            for (IDatabaseObjectInfo info : objs) {
                result.put(info.getSimpleName().toUpperCase(), (ITableInfo)info);
            }
        } else {
            String catalog = objs[0].getCatalogName();
            String schema = objs[0].getSchemaName();
            md.getTables(catalog, schema, null, new String[]{"TABLE"}, null);
        }
        return result;
    }

    public List<ColumnDifference> getColumnDifferences() {
        return this.colDifferences;
    }

    private boolean sanityCheck(IDatabaseObjectInfo[] sourceObjs, IDatabaseObjectInfo[] destObjs) {
        boolean result = true;
        if (sourceObjs.length != destObjs.length) {
            result = false;
        }
        if (sourceObjs[0].getDatabaseObjectType() != destObjs[0].getDatabaseObjectType()) {
            result = false;
        }
        return result;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String NO_DIFFS_MESSAGE = TabularDiffPresentation.access$000().getString("TabularDiffPresentation.noDiffsMessage");
    }
}

