/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.FontUIResource;
import org.fife.rtext.RText;
import org.fife.ui.EscapableDialog;
import org.fife.ui.ImageTranscodingUtil;
import org.fife.ui.RScrollPane;
import org.fife.ui.ResizableFrameContentPane;
import org.fife.ui.SelectableLabel;
import org.fife.ui.UIUtil;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextfilechooser.Utilities;

class AboutDialog
extends EscapableDialog {
    private static final long serialVersionUID = 1L;
    private RText parent;
    private Listener listener;
    private SelectableLabel memoryField;
    private static final String MSG = "org.fife.rtext.AboutDialog";

    AboutDialog(RText parent) {
        super((Window)((Object)parent));
        this.parent = parent;
        this.listener = new Listener();
        ComponentOrientation o = parent.getComponentOrientation();
        ResourceBundle msg = ResourceBundle.getBundle(MSG);
        ResizableFrameContentPane cp = new ResizableFrameContentPane((LayoutManager)new BorderLayout());
        Box box = Box.createVerticalBox();
        JPanel top = new JPanel(new BorderLayout(15, 0));
        top.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        Color topBG = UIManager.getColor("TextField.background");
        top.setOpaque(true);
        top.setBackground(topBG);
        top.setBorder(new TopBorder());
        try (InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/org/fife/rtext/graphics/about-image.svg");){
            BufferedImage image = ImageTranscodingUtil.rasterize((String)"about-image.svg", (InputStream)in, (int)64, (int)64);
            JLabel linkLabel = new JLabel(new ImageIcon(image));
            top.add((Component)linkLabel, "Before");
        }
        catch (IOException ioe) {
            parent.displayException(ioe);
        }
        JPanel topText = new JPanel(new BorderLayout());
        topText.setOpaque(false);
        top.add(topText);
        JPanel box2 = new JPanel();
        box2.setOpaque(false);
        box2.setLayout(new BoxLayout(box2, 1));
        topText.add((Component)box2, "North");
        JLabel label = new JLabel(msg.getString("About.Header"));
        label.setOpaque(true);
        label.setBackground(topBG);
        Font labelFont = label.getFont();
        label.setFont(labelFont.deriveFont(1, 20.0f));
        this.addLeftAligned(label, box2);
        box2.add(Box.createVerticalStrut(5));
        Date buildDate = parent.getBuildDate();
        String dateStr = buildDate == null ? "unknown" : DateFormat.getDateTimeInstance().format(buildDate);
        String desc = AboutDialog.getString(msg, "About.MainDesc", parent.getVersionString(), dateStr);
        SelectableLabel textArea = new SelectableLabel(desc);
        textArea.addHyperlinkListener((HyperlinkListener)this.listener);
        box2.add((Component)textArea);
        box2.add(Box.createVerticalGlue());
        box.add(top);
        box.add(Box.createVerticalStrut(5));
        JPanel temp = new JPanel(new SpringLayout());
        SelectableLabel javaField = new SelectableLabel(System.getProperty("java.home"));
        this.memoryField = new SelectableLabel();
        JLabel javaLabel = UIUtil.newLabel((ResourceBundle)msg, (String)"About.JavaHome", (Component)javaField);
        JLabel memoryLabel = UIUtil.newLabel((ResourceBundle)msg, (String)"About.Memory", (Component)this.memoryField);
        if (o.isLeftToRight()) {
            temp.add(javaLabel);
            temp.add((Component)javaField);
            temp.add(memoryLabel);
            temp.add((Component)this.memoryField);
        } else {
            temp.add((Component)javaField);
            temp.add(javaLabel);
            temp.add((Component)this.memoryField);
            temp.add(memoryLabel);
        }
        UIUtil.makeSpringCompactGrid((Container)temp, (int)2, (int)2, (int)5, (int)5, (int)15, (int)5);
        box.add(temp);
        box.add(Box.createVerticalGlue());
        cp.add((Component)box, "North");
        JButton okButton = UIUtil.newButton((ResourceBundle)msg, (String)"Button.OK");
        okButton.addActionListener(e -> this.setVisible(false));
        JPanel buttons = (JPanel)UIUtil.createButtonFooter((Container)okButton);
        buttons.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 8, 5, 8), buttons.getBorder()));
        cp.add((Component)buttons, "South");
        this.getRootPane().setDefaultButton(okButton);
        this.setTitle(parent.getString("AboutDialogTitle", new Object[0]));
        this.setContentPane((Container)cp);
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.pack();
    }

    private JPanel addLeftAligned(Component toAdd, Container addTo) {
        JPanel temp = new JPanel(new BorderLayout());
        temp.setOpaque(false);
        temp.add(toAdd, "Before");
        addTo.add(temp);
        return temp;
    }

    private String getMemoryInfo() {
        long curMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        return Utilities.getFileSizeStringFor((long)curMemory, (boolean)false);
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = Math.max(d.width, 600);
        return d;
    }

    private static String getString(ResourceBundle msg, String key, Object ... params) {
        String value = msg.getString(key);
        return params.length > 0 ? MessageFormat.format(value, params) : value;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.memoryField.setText(this.getMemoryInfo());
        }
        super.setVisible(visible);
    }

    private static class TopBorder
    extends AbstractBorder {
        private static final long serialVersionUID = 1L;

        private TopBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = 5;
            insets.left = 5;
            insets.top = 5;
            insets.bottom = 6;
            return insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color color = UIManager.getColor("controlShadow");
            if (color == null) {
                color = SystemColor.controlShadow;
            }
            g.setColor(color);
            g.drawLine(x, y + height - 1, x + width, y + height - 1);
        }
    }

    private class Listener
    implements HyperlinkListener {
        private Listener() {
        }

        private void handleLocalLink(URL url) {
            String str = url.toString();
            String command = str.substring(str.lastIndexOf(47) + 1);
            if ("libraries".equals(command)) {
                new CreditsDialog().setVisible(true);
            } else if ("license".equals(command)) {
                new LicenseDialog().setVisible(true);
            }
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                URL url = e.getURL();
                if ("file".equals(url.getProtocol())) {
                    this.handleLocalLink(url);
                    return;
                }
                if (!UIUtil.browse((String)url.toString())) {
                    UIManager.getLookAndFeel().provideErrorFeedback((Component)((Object)AboutDialog.this));
                }
            }
        }
    }

    private class LicenseDialog
    extends EscapableDialog {
        private static final long serialVersionUID = 1L;

        public LicenseDialog() {
            super((Window)((Object)AboutDialog.this));
            ResizableFrameContentPane cp = new ResizableFrameContentPane((LayoutManager)new BorderLayout());
            cp.setBorder(UIUtil.getEmpty5Border());
            ResourceBundle msg = ResourceBundle.getBundle(AboutDialog.MSG);
            JTextArea textArea = new JTextArea(25, 80);
            Font font = RTextArea.getDefaultFont();
            if (font instanceof FontUIResource) {
                font = new Font(font.getFamily(), font.getStyle(), font.getSize());
            }
            textArea.setFont(font);
            this.loadLicense(textArea);
            textArea.setEditable(false);
            RScrollPane sp = new RScrollPane((Component)textArea);
            cp.add((Component)sp);
            JButton okButton = UIUtil.newButton((ResourceBundle)msg, (String)"Button.OK");
            okButton.addActionListener(e -> this.setVisible(false));
            Container buttons = UIUtil.createButtonFooter((Container)okButton);
            cp.add((Component)buttons, "South");
            this.setContentPane((Container)cp);
            this.setTitle(msg.getString("Dialog.License.Title"));
            this.setModal(true);
            this.pack();
            this.setLocationRelativeTo((Component)((Object)AboutDialog.this));
        }

        private void loadLicense(JTextArea textArea) {
            File file = new File(AboutDialog.this.parent.getInstallLocation(), "License.txt");
            try {
                BufferedReader r = new BufferedReader(new FileReader(file));
                textArea.read(r, null);
                r.close();
            }
            catch (IOException ioe) {
                textArea.setText(ioe.getMessage());
            }
        }
    }

    private class CreditsDialog
    extends EscapableDialog {
        private static final long serialVersionUID = 1L;

        CreditsDialog() {
            super((Window)((Object)AboutDialog.this));
            ResizableFrameContentPane cp = new ResizableFrameContentPane((LayoutManager)new BorderLayout());
            cp.setBorder(UIUtil.getEmpty5Border());
            ResourceBundle msg = ResourceBundle.getBundle(AboutDialog.MSG);
            StringBuilder sb = new StringBuilder("<html><table>");
            this.appendLibrary(sb, "RSyntaxTextArea:", "http://fifesoft.com/rsyntaxtextarea", msg.getString("Desc.RSyntaxTextArea"));
            this.appendLibrary(sb, "JTidy:", "http://jtidy.sourceforge.net/", msg.getString("Desc.JTidy"));
            this.appendLibrary(sb, "Jazzy:", "http://jazzy.sourceforge.net/", msg.getString("Desc.Jazzy"));
            this.appendLibrary(sb, "JGoodies:", "http://jgoodies.com", msg.getString("Desc.JGoodies"));
            this.appendLibrary(sb, "Substance:", "https://github.com/kirill-grouchnikov/radiance/", msg.getString("Desc.Substance"));
            this.appendLibrary(sb, "Groovy:", "http://groovy.codehaus.org/", msg.getString("Desc.Groovy"));
            sb.append("</table>");
            SelectableLabel label = new SelectableLabel(sb.toString());
            label.addHyperlinkListener((HyperlinkListener)AboutDialog.this.listener);
            cp.add((Component)label);
            JButton okButton = UIUtil.newButton((ResourceBundle)msg, (String)"Button.OK");
            okButton.addActionListener(e -> this.setVisible(false));
            Container buttons = UIUtil.createButtonFooter((Container)okButton);
            cp.add((Component)buttons, "South");
            this.setContentPane((Container)cp);
            this.setTitle(msg.getString("Dialog.Credits.Title"));
            this.setModal(true);
            this.pack();
            this.setLocationRelativeTo((Component)((Object)AboutDialog.this));
        }

        private void appendLibrary(StringBuilder sb, String name, String url, String desc) {
            sb.append("<tr><td><b>").append(name).append("</b></td>");
            sb.append("<td><a href=\"").append(url).append("\">");
            sb.append(url).append("</a></td></tr>");
            sb.append("<tr><td colspan=\"2\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\u2022 ");
            sb.append(desc).append("</td></tr>");
            sb.append("<tr><td>&nbsp;</td><td>&nbsp;</td></tr>");
        }
    }
}

