/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.ui.rsyntaxtextarea.FileLocation;

public class RecentFileManager
implements PropertyChangeListener {
    private RText rtext;
    private List<FileLocation> files;
    private static final int MAX_FILE_COUNT = 75;

    public RecentFileManager(RText rtext, List<String> recentFiles) {
        this.rtext = rtext;
        this.files = new ArrayList<FileLocation>();
        rtext.getMainView().addPropertyChangeListener("MainView.textAreaAdded", this);
        if (recentFiles != null) {
            for (String recentFile : recentFiles) {
                this.addFile(recentFile);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        RTextEditorPane textArea;
        String prop = e.getPropertyName();
        if ("MainView.textAreaAdded".equals(prop) && (textArea = (RTextEditorPane)((Object)e.getNewValue())) != null) {
            String fullPath = textArea.getFileFullPath();
            if (fullPath.endsWith(File.separatorChar + this.rtext.getNewFileName()) || fullPath.equals("-")) {
                return;
            }
            this.addFile(fullPath);
        }
    }

    private void addFile(String file) {
        FileLocation loc;
        if (file == null) {
            return;
        }
        int index = this.indexOf(file);
        if (index > -1) {
            FileLocation loc2 = this.files.remove(index);
            this.files.add(0, loc2);
            return;
        }
        try {
            loc = FileLocation.create((String)file);
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            return;
        }
        if (loc.isLocal() && !loc.isLocalAndExists()) {
            return;
        }
        this.files.add(0, loc);
        if (this.files.size() > 75) {
            this.files.remove(this.files.size() - 1);
        }
    }

    private int indexOf(String file) {
        for (int i = 0; i < this.files.size(); ++i) {
            FileLocation loc = this.files.get(i);
            if (!file.equals(loc.getFileFullPath())) continue;
            return i;
        }
        return -1;
    }

    public List<FileLocation> getRecentFiles() {
        return this.files;
    }
}

