/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.ui.StatusBarPanel;

public class StatusBar
extends org.fife.ui.StatusBar
implements PropertyChangeListener {
    private JLabel selectionLengthIndicator;
    private JLabel rowAndColumnIndicator;
    private JLabel overwriteModeIndicator;
    private JLabel capsLockIndicator;
    private JLabel readOnlyIndicator;
    private RText rtext;
    private int row;
    private int column;
    private boolean rowColumnIndicatorVisible;
    private StatusBarPanel overwritePanel;
    private StatusBarPanel capsLockPanel;
    private StatusBarPanel readOnlyPanel;
    private StatusBarPanel selectionLengthPanel;
    private String fileSaveSuccessfulText;
    private String openedFileText;
    private String selectionLengthText;
    private String rowColumnText1;
    private String rowColumnText2;
    private String rowColumnText3;
    private StringBuilder rcBuf;

    public StatusBar(RText rtext, String defaultMessage, boolean showRowColumn, int newRow, int newColumn, boolean overwriteModeEnabled) {
        super(defaultMessage);
        this.rtext = rtext;
        ResourceBundle msg = ResourceBundle.getBundle(StatusBar.class.getName());
        this.fileSaveSuccessfulText = msg.getString("FileSaveSuccessful");
        this.openedFileText = msg.getString("OpenedFile");
        this.selectionLengthText = msg.getString("SelectionLength");
        this.initRowColumnTextStuff(msg);
        this.row = newRow;
        this.column = newColumn;
        this.rowAndColumnIndicator = new JLabel();
        this.rowColumnIndicatorVisible = !showRowColumn;
        this.setRowColumnIndicatorVisible(showRowColumn);
        this.readOnlyIndicator = StatusBar.createLabel(msg, "ReadOnlyIndicator");
        this.capsLockIndicator = StatusBar.createLabel(msg, "CapsLockIndicator");
        this.overwriteModeIndicator = StatusBar.createLabel(msg, "OverwriteModeIndicator");
        this.overwriteModeIndicator = StatusBar.createLabel(msg, "OverwriteModeIndicator");
        this.selectionLengthIndicator = new JLabel();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 0.0;
        this.selectionLengthPanel = new StatusBarPanel((LayoutManager)new BorderLayout(), this.selectionLengthIndicator);
        this.addStatusBarComponent(this.selectionLengthPanel, c);
        c.weightx = 0.0;
        this.readOnlyPanel = new StatusBarPanel((LayoutManager)new BorderLayout(), this.readOnlyIndicator);
        this.readOnlyIndicator.setEnabled(false);
        this.addStatusBarComponent(this.readOnlyPanel, c);
        c.weightx = 0.0;
        this.capsLockPanel = new StatusBarPanel((LayoutManager)new BorderLayout(), this.capsLockIndicator);
        try {
            this.capsLockIndicator.setEnabled(Toolkit.getDefaultToolkit().getLockingKeyState(20));
        }
        catch (UnsupportedOperationException e) {
            this.capsLockIndicator.setText("-");
            this.setCapsLockIndicatorEnabled(false);
        }
        this.addStatusBarComponent(this.capsLockPanel, c);
        c.weightx = 0.0;
        this.overwritePanel = new StatusBarPanel((LayoutManager)new BorderLayout(), this.overwriteModeIndicator);
        this.setOverwriteModeIndicatorEnabled(overwriteModeEnabled);
        this.addStatusBarComponent(this.overwritePanel, c);
        c.weightx = 0.0;
        StatusBarPanel temp1 = new StatusBarPanel(new BorderLayout()){

            public Dimension getMinimumSize() {
                return new Dimension(50, super.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                return new Dimension(Math.max(50, preferredSize.width), preferredSize.height);
            }
        };
        temp1.add((Component)this.rowAndColumnIndicator);
        this.addStatusBarComponent(temp1, c);
    }

    public void addStatusBarComponent(StatusBarPanel panel, int index, GridBagConstraints constraints) {
        super.addStatusBarComponent(panel, index + 1, constraints);
    }

    private static JLabel createLabel(ResourceBundle bundle, String key) {
        JLabel label = new JLabel(bundle.getString(key));
        label.setHorizontalAlignment(0);
        return label;
    }

    public void decColumn() {
        this.setRowAndColumn(this.row, Math.max(this.column - 1, 0));
    }

    public void decRow() {
        this.setRowAndColumn(Math.max(this.row - 1, 0), this.column);
    }

    public void incColumn() {
        this.setRowAndColumn(this.row, this.column + 1);
    }

    public void incRow() {
        this.setRowAndColumn(this.row + 1, this.column);
    }

    private void initRowColumnTextStuff(ResourceBundle msg) {
        String rowColumnText = msg.getString("RowColumnIndicator");
        int rowPos = rowColumnText.indexOf("{0}");
        int colPos = rowColumnText.indexOf("{1}");
        int min = Math.min(rowPos, colPos);
        int max = Math.max(rowPos, colPos);
        this.rowColumnText1 = rowColumnText.substring(0, min);
        this.rowColumnText2 = rowColumnText.substring(min + 3, max);
        this.rowColumnText3 = rowColumnText.substring(max + 3);
        this.rcBuf = new StringBuilder();
    }

    public boolean isCapsLockIndicatorEnabled() {
        return this.capsLockIndicator.isEnabled();
    }

    public boolean isOverwriteModeIndicatorEnabled() {
        return this.overwriteModeIndicator.isEnabled();
    }

    public boolean isReadOnlyIndicatorEnabled() {
        return this.readOnlyIndicator.isEnabled();
    }

    public boolean isRowColumnIndicatorVisible() {
        return this.rowColumnIndicatorVisible;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String property = e.getPropertyName();
        if (property.equals("TextEditorPane.dirty")) {
            boolean wasDirty = (Boolean)e.getOldValue();
            boolean isDirty = (Boolean)e.getNewValue();
            if (wasDirty && !isDirty) {
                this.setStatusMessage(this.fileSaveSuccessfulText);
            }
        } else if (property.equals("MainView.textAreaAdded")) {
            RTextEditorPane textArea = (RTextEditorPane)((Object)e.getNewValue());
            this.setStatusMessage(MessageFormat.format(this.openedFileText, textArea.getFileName()));
        }
        if (property.equals("TextEditorPane.readOnly")) {
            boolean enabled = (Boolean)e.getNewValue();
            this.setReadOnlyIndicatorEnabled(enabled);
        }
    }

    public void setCapsLockIndicatorEnabled(boolean enabled) {
        this.capsLockIndicator.setEnabled(enabled);
    }

    public void setColumn(int newColumn) {
        this.setRowAndColumn(this.row, newColumn);
    }

    public void setOverwriteModeIndicatorEnabled(boolean enabled) {
        this.overwriteModeIndicator.setEnabled(enabled);
    }

    public void setReadOnlyIndicatorEnabled(boolean enabled) {
        this.readOnlyIndicator.setEnabled(enabled);
    }

    public void setRow(int newRow) {
        this.setRowAndColumn(newRow, this.column);
    }

    public void setRowAndColumn(int newRow, int newColumn) {
        this.row = newRow;
        this.column = newColumn;
        this.updateRowColumnDisplay();
        this.updateSelectionLengthDisplay();
    }

    public void setRowColumnIndicatorVisible(boolean isVisible) {
        if (isVisible != this.rowColumnIndicatorVisible) {
            this.rowColumnIndicatorVisible = isVisible;
            if (isVisible) {
                this.updateRowColumnDisplay();
            } else {
                this.rowAndColumnIndicator.setText("-");
            }
        }
    }

    private void updateRowColumnDisplay() {
        if (this.rowColumnIndicatorVisible) {
            this.rcBuf.setLength(0);
            this.rcBuf.append(this.rowColumnText1).append(this.row).append(this.rowColumnText2);
            this.rcBuf.append(this.column).append(this.rowColumnText3);
            this.rowAndColumnIndicator.setText(this.rcBuf.toString());
        }
    }

    private void updateSelectionLengthDisplay() {
        RTextEditorPane textArea = this.rtext.getMainView().getCurrentTextArea();
        int selectionLength = textArea.getSelectionEnd() - textArea.getSelectionStart();
        if (selectionLength == 0) {
            this.selectionLengthPanel.setVisible(false);
        } else {
            String newValue = MessageFormat.format(this.selectionLengthText, selectionLength);
            this.selectionLengthIndicator.setText(newValue);
            if (!this.selectionLengthPanel.isVisible()) {
                this.selectionLengthPanel.setVisible(true);
            }
        }
    }
}

