/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.actions;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.Icon;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.ui.app.AppAction;
import org.fife.ui.app.GUIApplication;
import org.fife.ui.rtextfilechooser.RTextFileChooser;

class OpenAction
extends AppAction<RText> {
    OpenAction(RText owner, ResourceBundle msg, Icon icon) {
        super((GUIApplication)owner, msg, "OpenAction");
        this.setIcon(icon);
    }

    public void actionPerformed(ActionEvent e) {
        RText owner = (RText)this.getApplication();
        RTextFileChooser chooser = owner.getFileChooser();
        if (!chooser.isShowing()) {
            chooser.setMultiSelectionEnabled(true);
            chooser.setOpenedFiles(owner.getMainView().getOpenFiles());
            chooser.setEncoding(RTextFileChooser.getDefaultEncoding());
            int returnVal = chooser.showOpenDialog((Window)((Object)owner));
            if (returnVal == 0) {
                File[] selectedFiles;
                AbstractMainView mainView = owner.getMainView();
                String encoding = chooser.getEncoding();
                for (File selectedFile : selectedFiles = chooser.getSelectedFiles()) {
                    String fileFullPath = selectedFile.getAbsolutePath();
                    mainView.openFile(fileFullPath, encoding);
                }
            }
        }
    }
}

