/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.io.File;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import org.fife.ui.rtextfilechooser.RootManager;

class FileChooserIconManager {
    protected Icon folderIcon;
    protected Icon hardDriveIcon;
    protected Icon floppyDriveIcon;
    protected Icon computerIcon;
    protected Icon fileIcon;
    private static final FileSystemView fileSystemView = FileSystemView.getFileSystemView();
    private HashMap iconCache = new HashMap(50);

    public FileChooserIconManager() {
        this.createDefaultIcons();
    }

    public void clearIconCache() {
        this.iconCache.clear();
    }

    protected void createDefaultIcons() {
        this.folderIcon = FileChooserIconManager.createFolderIcon();
        this.hardDriveIcon = UIManager.getIcon("FileView.hardDriveIcon");
        this.floppyDriveIcon = UIManager.getIcon("FileView.floppyDriveIcon");
        this.fileIcon = UIManager.getIcon("FileView.fileIcon");
        String path = "org/fife/ui/rtextfilechooser/images/";
        ClassLoader cl = this.getClass().getClassLoader();
        if (this.hardDriveIcon == null) {
            this.hardDriveIcon = FileChooserIconManager.loadIcon(cl, path + "harddrive.gif");
        }
        if (this.floppyDriveIcon == null) {
            this.floppyDriveIcon = FileChooserIconManager.loadIcon(cl, path + "floppydrive.gif");
        }
        if (this.fileIcon == null) {
            this.fileIcon = FileChooserIconManager.loadIcon(cl, path + "file.gif");
        }
    }

    public static Icon createFolderIcon() {
        Icon folderIcon = null;
        try {
            File temp = File.createTempFile("FileSystemTree", ".tmp");
            temp.delete();
            temp.mkdir();
            if (temp.isDirectory()) {
                folderIcon = FileSystemView.getFileSystemView().getSystemIcon(temp);
                temp.delete();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (folderIcon == null && (folderIcon = UIManager.getIcon("FileView.directoryIcon")) == null) {
            String path = "org/fife/ui/rtextfilechooser/images/";
            ClassLoader cl = FileChooserIconManager.class.getClassLoader();
            folderIcon = FileChooserIconManager.loadIcon(cl, path + "directory.gif");
        }
        return folderIcon;
    }

    public Icon getFolderIcon() {
        return this.folderIcon;
    }

    public Icon getIcon(File f) {
        Icon icon = null;
        if (f != null) {
            icon = (Icon)this.iconCache.get(f);
            if (icon != null) {
                return icon;
            }
            if (f.exists() || RootManager.getInstance().isRoot(f)) {
                try {
                    icon = fileSystemView.getSystemIcon(f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (icon == null) {
                icon = fileSystemView.isFloppyDrive(f) ? this.floppyDriveIcon : (fileSystemView.isDrive(f) ? this.hardDriveIcon : (fileSystemView.isComputerNode(f) ? this.computerIcon : (f.isDirectory() ? this.folderIcon : this.fileIcon)));
            }
            this.iconCache.put(f, icon);
        }
        return icon;
    }

    private static Icon loadIcon(ClassLoader cl, String file) {
        return new ImageIcon(cl.getResource(file));
    }

    public Icon removeIconFor(File file) {
        return (Icon)this.iconCache.remove(file);
    }
}

