/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlscript.table_script;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sqlscript.table_script.IAbortEventHandler;
import net.sourceforge.squirrel_sql.plugins.sqlscript.table_script.ModalDisplayReachedCallBack;
import net.sourceforge.squirrel_sql.plugins.sqlscript.table_script.gui.TaskDescriptionComponent;
import org.apache.commons.lang.StringUtils;

public class ProgressAbortDialog
extends JDialog
implements ProgressAbortCallback {
    private final ProgressAbortDialog instance = this;
    public static final ILogger s_log = LoggerController.createLogger(ProgressAbortDialog.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ProgressAbortDialog.class);
    protected TaskDescriptionComponent taskDescription;
    private String targetFile;
    private String sql;
    private DateFormat dateFormat = DateFormat.getTimeInstance();
    private int itemCount = 0;
    private JProgressBar progressBar = null;
    private JLabel statusLabel = null;
    private JLabel additionalStatusLabel = null;
    private String _loadingPrefix = i18n.DEFAULT_LOADING_PREFIX;
    private boolean indeterminate;
    private IAbortEventHandler abortHandler;
    private JButton cancelButton;
    private JTextArea historyArea;
    private JComponent taskDescriptionComponent;
    private boolean canceled;
    private boolean finished;
    private String simpleTaskDescription = null;

    public ProgressAbortDialog(Frame owner, String title, String targetFile, String sql, int totalItems, IAbortEventHandler abortHandler, final ModalDisplayReachedCallBack modalDisplayReachedCallBack) {
        super(owner, title, modalDisplayReachedCallBack != null);
        this.setLocationRelativeTo(owner);
        this.init(title, totalItems, abortHandler);
        this.setTargetFile(targetFile);
        this.setSql(sql);
        this.setLabelValues();
        if (null != modalDisplayReachedCallBack) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    modalDisplayReachedCallBack.dialogIsModalDisplaying();
                }
            });
        }
    }

    public void setTotalItems(int totalItems) {
        this.itemCount = totalItems;
        this.progressBar.setMaximum(totalItems);
    }

    public void setLoadingPrefix(String loadingPrefix) {
        if (loadingPrefix != null) {
            this._loadingPrefix = loadingPrefix;
        }
    }

    public void currentlyLoading(String simpleName) {
        final StringBuilder statusText = this.appendPrefixed(simpleName);
        try {
            GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProgressAbortDialog.this.statusLabel.setText(statusText.toString());
                    ProgressAbortDialog.this.setTaskStatus(null);
                    ProgressAbortDialog.this.progressBar.setValue(ProgressAbortDialog.this.progressBar.getValue() + 1);
                    if (ProgressAbortDialog.this.finishedLoading()) {
                        ProgressAbortDialog.this.setVisible(false);
                        return;
                    }
                }
            });
        }
        catch (Exception e) {
            s_log.error((Object)("Unexpected exception: " + e.getMessage()), (Throwable)e);
        }
    }

    private StringBuilder appendPrefixed(String simpleName) {
        StringBuilder statusText = new StringBuilder();
        statusText.append(this._loadingPrefix);
        statusText.append(" ");
        statusText.append(simpleName);
        this.appendToHistory(statusText.toString());
        return statusText;
    }

    public void setTaskStatus(String status) {
        final StringBuilder statusText = new StringBuilder();
        if (StringUtils.isNotBlank((String)status)) {
            statusText.append(status);
        } else {
            statusText.append(" ");
        }
        try {
            GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    String statusTextToAppend = statusText.toString();
                    ProgressAbortDialog.this.additionalStatusLabel.setText(statusTextToAppend);
                    if (StringUtils.isNotBlank((String)statusTextToAppend)) {
                        ProgressAbortDialog.this.appendPrefixed(statusTextToAppend);
                    }
                }
            });
        }
        catch (Exception e) {
            s_log.error((Object)("Unexpected exception: " + e.getMessage()), (Throwable)e);
        }
    }

    private void appendToHistory(String string) {
        if (this.historyArea != null) {
            final StringBuilder sb = new StringBuilder();
            sb.append(this.dateFormat.format(new Date()));
            sb.append(": ");
            sb.append(string);
            sb.append(StringUtilities.getEolStr());
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProgressAbortDialog.this.historyArea.append(sb.toString());
                    ProgressAbortDialog.this.historyArea.setCaretPosition(ProgressAbortDialog.this.historyArea.getDocument().getLength());
                }
            };
            GUIUtils.processOnSwingEventThread((Runnable)runnable);
        }
    }

    public boolean finishedLoading() {
        if (this.finished) {
            this.progressBar.setIndeterminate(false);
            return true;
        }
        if (this.indeterminate) {
            return false;
        }
        return this.progressBar.getValue() == this.itemCount;
    }

    @Override
    public void dispose() {
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ProgressAbortDialog.this.callDisposeFromSuperClass();
            }
        });
    }

    private void callDisposeFromSuperClass() {
        super.dispose();
    }

    @Override
    public void setVisible(final boolean b) {
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ProgressAbortDialog.this.callSetVisibleFromSuperClass(b);
            }
        });
    }

    private void callSetVisibleFromSuperClass(boolean b) {
        super.setVisible(b);
    }

    private void init(String description, int totalItems, IAbortEventHandler abortHandler) {
        this.itemCount = totalItems;
        this.indeterminate = totalItems <= 0;
        this.abortHandler = abortHandler;
        this.simpleTaskDescription = description;
        Window owner = super.getOwner();
        this.createGUI();
        this.setLocationRelativeTo(owner);
    }

    private void createGUI() {
        JPanel dialogPanel = new JPanel(new GridBagLayout());
        dialogPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.5;
        c.anchor = 17;
        c.insets = new Insets(4, 0, 4, 0);
        this.taskDescriptionComponent = this.createTaskDescripion();
        dialogPanel.add((Component)this.taskDescriptionComponent, c);
        ++c.gridy;
        JPanel progressPanel = new JPanel(new GridBagLayout());
        progressPanel.setMinimumSize(new Dimension(400, 200));
        progressPanel.setPreferredSize(new Dimension(400, 200));
        progressPanel.setBorder(BorderFactory.createTitledBorder("Progress"));
        dialogPanel.add((Component)progressPanel, c);
        c.gridy = 0;
        c.gridx = 0;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(4, 10, 4, 10);
        this.statusLabel = new JLabel(i18n.INITIAL_LOADING_PREFIX);
        progressPanel.add((Component)this.statusLabel, c);
        ++c.gridy;
        c.insets = new Insets(4, 10, 4, 10);
        this.additionalStatusLabel = new JLabel(" ");
        progressPanel.add((Component)this.additionalStatusLabel, c);
        ++c.gridy;
        c.weightx = 1.0;
        this.progressBar = new JProgressBar(0, this.itemCount);
        this.progressBar.setIndeterminate(this.indeterminate);
        progressPanel.add((Component)this.progressBar, c);
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.historyArea = new JTextArea();
        this.historyArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.historyArea);
        progressPanel.add((Component)jScrollPane, c);
        if (this.abortHandler != null) {
            this.cancelButton = new JButton(new CancelAction());
            ++c.gridy;
            c.anchor = 17;
            c.fill = 2;
            c.weightx = 0.0;
            c.weighty = 0.0;
            dialogPanel.add((Component)this.cancelButton, c);
        }
        super.getContentPane().add(dialogPanel);
        super.pack();
        super.setSize(new Dimension(450, 450));
        super.setDefaultCloseOperation(0);
        super.addWindowListener(new WindowCloseListener());
    }

    protected void setLabelValues() {
        this.taskDescription.setTargetFile(this.getTargetFile());
        this.taskDescription.setSql(this.getSql());
    }

    protected JComponent createTaskDescripion() {
        this.taskDescription = new TaskDescriptionComponent(this.getTargetFile(), this.getSql());
        return this.taskDescription;
    }

    public String getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(String targetFile) {
        if (StringUtils.isBlank((String)targetFile)) {
            throw new IllegalArgumentException("targetFile must not be blank.");
        }
        this.targetFile = targetFile;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        if (StringUtils.isEmpty((String)sql)) {
            throw new IllegalArgumentException("sql must not be blank");
        }
        this.sql = sql;
    }

    public boolean isStop() {
        return this.canceled;
    }

    public boolean isVisble() {
        return super.isVisible();
    }

    public void setFinished() {
        this.finished = true;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(i18n.CANCEL);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.clickCancel();
        }

        public void clickCancel() {
            int ret = JOptionPane.showConfirmDialog(ProgressAbortDialog.this.instance, i18n.CONFIRM_CANCEL);
            if (0 == ret) {
                ProgressAbortDialog.this.appendToHistory(i18n.CANCEL_FEEDBACK);
                ProgressAbortDialog.this.canceled = true;
                ProgressAbortDialog.this.cancelButton.setEnabled(false);
                ProgressAbortDialog.this.abortHandler.cancel();
            }
        }
    }

    private class WindowCloseListener
    extends WindowAdapter {
        private WindowCloseListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            new CancelAction().clickCancel();
        }
    }

    static interface i18n {
        public static final String DEFAULT_LOADING_PREFIX = ProgressAbortDialog.access$000().getString("ProgressAbortDialog.defaultLoadingPrefix");
        public static final String INITIAL_LOADING_PREFIX = ProgressAbortDialog.access$000().getString("ProgressAbortDialog.initialLoadingPrefix");
        public static final String CONFIRM_CANCEL = ProgressAbortDialog.access$000().getString("ProgressAbortDialog.confirmCancel");
        public static final String TITEL_PROGRESS = ProgressAbortDialog.access$000().getString("ProgressAbortDialog.titelProgress");
        public static final String CANCEL = ProgressAbortDialog.access$000().getString("ProgressAbortDialog.cancel");
        public static final String CANCEL_FEEDBACK = ProgressAbortDialog.access$000().getString("ProgressAbortDialog.cancelFeedback");
    }
}

