/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.db2.exp;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableTriggerExtractor;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.db2.sql.DB2Sql;

public class DB2TableTriggerExtractorImpl
implements ITableTriggerExtractor {
    private static final ILogger s_log = LoggerController.createLogger(DB2TableTriggerExtractorImpl.class);
    private final DB2Sql db2Sql;

    public DB2TableTriggerExtractorImpl(DB2Sql db2Sql) {
        this.db2Sql = db2Sql;
    }

    public void bindParamters(PreparedStatement pstmt, IDatabaseObjectInfo dbo) throws SQLException {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Binding schema name " + dbo.getSchemaName() + " as first bind value"));
            s_log.debug((Object)("Binding table name " + dbo.getSimpleName() + " as second bind value"));
        }
        pstmt.setString(1, dbo.getSchemaName());
        pstmt.setString(2, dbo.getSimpleName());
    }

    public String getTableTriggerQuery() {
        return this.db2Sql.getTableTriggerListSql();
    }
}

