/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.db2.tab;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BasePreparedStatementTab;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.db2.sql.DB2Sql;
import net.sourceforge.squirrel_sql.plugins.db2.tab.TriggerDetailsTab;

public class UDFDetailsTab
extends BasePreparedStatementTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TriggerDetailsTab.class);
    private static final ILogger s_log = LoggerController.createLogger(TriggerDetailsTab.class);
    private final DB2Sql db2Sql;

    public UDFDetailsTab(DB2Sql db2Sql) {
        super(i18n.TITLE, i18n.HINT, true);
        this.db2Sql = db2Sql;
    }

    protected PreparedStatement createStatement() throws SQLException {
        ISession session = this.getSession();
        IDatabaseObjectInfo doi = this.getDatabaseObjectInfo();
        String sql = this.db2Sql.getUserDefinedFunctionDetailsSql();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("UDF details SQL: " + sql));
            s_log.debug((Object)("UDF schema: " + doi.getSchemaName()));
            s_log.debug((Object)("UDF name: " + doi.getSimpleName()));
        }
        PreparedStatement pstmt = session.getSQLConnection().prepareStatement(sql);
        pstmt.setString(1, doi.getSchemaName());
        pstmt.setString(2, doi.getSimpleName());
        return pstmt;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static interface i18n {
        public static final String TITLE = UDFDetailsTab.access$000().getString("UdfDetailsTab.title");
        public static final String HINT = UDFDetailsTab.access$000().getString("UdfDetailsTab.hint");
    }
}

