/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tinylaf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;
import net.sf.tinylaf.Theme;
import net.sf.tinylaf.TinyLookAndFeel;
import net.sf.tinylaf.borders.TinyButtonBorder;
import net.sf.tinylaf.util.ColorRoutines;
import net.sf.tinylaf.util.DrawRoutines;

public class TinyButtonUI
extends MetalButtonUI {
    private static final HashMap cache = new HashMap();
    public static final int BG_CHANGE_AMOUNT = 10;
    private static final TinyButtonUI buttonUI = new TinyButtonUI();
    private static final BasicStroke focusStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f, 1.0f}, 0.0f);
    private boolean graphicsTranslated;
    private boolean isToolBarButton;
    private boolean isFileChooserButton;
    private boolean isDefaultButton;

    public static void clearCache() {
        cache.clear();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (!Theme.buttonEnter.getValue()) {
            return;
        }
        if (!c.isFocusable()) {
            return;
        }
        InputMap km = (InputMap)UIManager.get(this.getPropertyPrefix() + "focusInputMap");
        if (km != null) {
            km.put(KeyStroke.getKeyStroke(10, 0, false), "pressed");
            km.put(KeyStroke.getKeyStroke(10, 0, true), "released");
        }
    }

    public void installDefaults(AbstractButton button) {
        super.installDefaults(button);
        button.setRolloverEnabled(true);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (this.isFileChooserButton || this.isToolBarButton && !Theme.toolFocus.getValue() || !Theme.buttonFocus.getValue()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Rectangle focusRect = b.getBounds();
        g.setColor(Color.black);
        g2d.setStroke(focusStroke);
        int x1 = 2;
        int y1 = 2;
        int x2 = x1 + focusRect.width - 5;
        int y2 = y1 + focusRect.height - 5;
        if (!this.isToolBarButton) {
            ++x1;
            ++y1;
            --x2;
            --y2;
        }
        if (this.graphicsTranslated) {
            g.translate(-1, -1);
        }
        g2d.drawLine(x1, y1, x2, y1);
        g2d.drawLine(x1, y1, x1, y2);
        g2d.drawLine(x1, y2, x2, y2);
        g2d.drawLine(x2, y1, x2, y2);
    }

    public static ComponentUI createUI(JComponent c) {
        return buttonUI;
    }

    protected void paintButtonPressed(Graphics g, AbstractButton button) {
        if (this.isToolBarButton || this.isFileChooserButton) {
            return;
        }
        Color col = null;
        col = !(button.getBackground() instanceof ColorUIResource) ? ColorRoutines.darken(button.getBackground(), 10) : (button instanceof JToggleButton ? Theme.toggleSelectedBg.getColor() : Theme.buttonPressedColor.getColor());
        g.setColor(col);
        this.drawXpButton(g, button, col, false);
        if (!(button instanceof JToggleButton) && Theme.shiftButtonText.getValue() && button.getText() != null && !"".equals(button.getText())) {
            g.translate(1, 1);
            this.graphicsTranslated = true;
        }
    }

    public void paintToolBarButton(Graphics g, AbstractButton b) {
        ColorUIResource col = null;
        boolean isRollover = b.getModel().isRollover() || b.getModel().isArmed();
        Color toolButtColor = null;
        toolButtColor = this.isFileChooserButton ? b.getParent().getBackground() : Theme.toolButtColor.getColor();
        col = b.getModel().isPressed() ? (isRollover ? Theme.toolButtPressedColor.getColor() : (b.isSelected() ? Theme.toolButtSelectedColor.getColor() : toolButtColor)) : (isRollover ? (b.isSelected() ? Theme.toolButtSelectedColor.getColor() : Theme.toolButtRolloverColor.getColor()) : (b.isSelected() ? Theme.toolButtSelectedColor.getColor() : toolButtColor));
        g.setColor(col);
        this.drawXpToolBarButton(g, b, col, false);
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        if (this.isToolBarButton || this.isFileChooserButton) {
            this.paintToolBarButton(g, button);
        } else if (button instanceof JToggleButton && button.isSelected()) {
            this.paintButtonPressed(g, button);
        } else {
            this.isDefaultButton = c instanceof JButton && ((JButton)c).isDefaultButton();
            boolean isRollover = button.getModel().isRollover();
            boolean isDefinedBackground = c.getBackground().equals(Theme.buttonNormalColor.getColor()) || c.getBackground() instanceof ColorUIResource;
            Color col = null;
            col = !button.isEnabled() ? Theme.buttonDisabledColor.getColor() : (button.getModel().isPressed() ? (isRollover ? (isDefinedBackground ? Theme.buttonPressedColor.getColor() : ColorRoutines.darken(c.getBackground(), 10)) : c.getBackground()) : (isRollover ? (isDefinedBackground ? Theme.buttonRolloverBgColor.getColor() : ColorRoutines.lighten(c.getBackground(), 10)) : (isDefinedBackground ? Theme.buttonNormalColor.getColor() : c.getBackground())));
            g.setColor(col);
            if (TinyLookAndFeel.controlPanelInstantiated) {
                this.drawXpButtonNoCache(g, button, col, isRollover);
            } else {
                this.drawXpButton(g, button, col, isRollover);
            }
        }
        super.paint(g, c);
    }

    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        if (c instanceof JToggleButton) {
            this.paintToggleButtonIcon(g, c, iconRect);
        } else {
            super.paintIcon(g, c, iconRect);
        }
    }

    protected void paintToggleButtonIcon(Graphics g, JComponent c, Rectangle iconRect) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Icon icon = null;
        if (!model.isEnabled()) {
            icon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
        } else if (model.isPressed() && model.isArmed()) {
            icon = b.getPressedIcon();
            if (icon == null) {
                icon = b.getSelectedIcon();
            }
        } else if (model.isSelected()) {
            if (b.isRolloverEnabled() && model.isRollover()) {
                icon = b.getRolloverSelectedIcon();
                if (icon == null) {
                    icon = b.getSelectedIcon();
                }
            } else {
                icon = b.getSelectedIcon();
            }
        } else if (model.isRollover()) {
            icon = b.getRolloverIcon();
        }
        if (icon == null) {
            icon = b.getIcon();
        }
        icon.paintIcon(b, g, iconRect.x, iconRect.y);
    }

    public void update(Graphics g, JComponent c) {
        this.isToolBarButton = Boolean.TRUE.equals(c.getClientProperty("isToolbarButton"));
        this.isFileChooserButton = Boolean.TRUE.equals(c.getClientProperty("isFileChooserButton"));
        this.paint(g, c);
        this.graphicsTranslated = false;
    }

    private void drawXpButton(Graphics g, AbstractButton b, Color c, boolean isRollover) {
        Border border;
        if (!b.isContentAreaFilled()) {
            return;
        }
        if (!b.isOpaque()) {
            return;
        }
        int w = b.getWidth();
        int h = b.getHeight();
        Color bg = b.getParent().getBackground();
        ButtonKey key = new ButtonKey(c, bg, h, isRollover & Theme.buttonRolloverBorder.getValue(), this.isDefaultButton, b.hasFocus(), b.isBorderPainted());
        Object value = cache.get(key);
        if (value != null) {
            int width = ((Image)value).getWidth(b);
            if (width == w) {
                g.drawImage((Image)value, 0, 0, b);
                return;
            }
            int sx1 = 0;
            boolean sy1 = false;
            int sx2 = 3;
            int sy2 = h;
            int dx1 = 0;
            boolean dy1 = false;
            int dx2 = sx2;
            int dy2 = sy2;
            g.drawImage((Image)value, dx1, 0, dx2, dy2, sx1, 0, sx2, sy2, b);
            sx1 = width - 4;
            sx2 = width;
            dx1 = w - 4;
            dx2 = w;
            g.drawImage((Image)value, dx1, 0, dx2, dy2, sx1, 0, sx2, sy2, b);
            sx1 = 3;
            sx2 = width - 4;
            dx1 = sx1;
            dx2 = w - 4;
            g.drawImage((Image)value, dx1, 0, dx2, dy2, sx1, 0, sx2, sy2, b);
            return;
        }
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics imgGraphics = ((Image)img).getGraphics();
        imgGraphics.setColor(bg);
        imgGraphics.drawRect(0, 0, w - 1, h - 1);
        int spread1 = Theme.buttonSpreadLight.getValue();
        int spread2 = Theme.buttonSpreadDark.getValue();
        if (!b.isEnabled()) {
            spread1 = Theme.buttonSpreadLightDisabled.getValue();
            spread2 = Theme.buttonSpreadDarkDisabled.getValue();
        }
        float spreadStep1 = 10.0f * (float)spread1 / (float)(h - 3);
        float spreadStep2 = 10.0f * (float)spread2 / (float)(h - 3);
        int halfY = h / 2;
        for (int y = 1; y < h - 1; ++y) {
            int yd;
            if (y < halfY) {
                yd = halfY - y;
                imgGraphics.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
            } else if (y == halfY) {
                imgGraphics.setColor(c);
            } else {
                yd = y - halfY;
                imgGraphics.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
            }
            imgGraphics.drawLine(2, y, w - 3, y);
            if (y == 1) {
                imgGraphics.drawLine(1, 1, 1, h - 2);
                if (!isRollover && !this.isDefaultButton) continue;
                imgGraphics.drawLine(w - 2, 1, w - 2, h - 2);
                continue;
            }
            if (y != h - 2 || isRollover || this.isDefaultButton) continue;
            imgGraphics.drawLine(w - 2, 1, w - 2, h - 2);
        }
        if (b.isBorderPainted() && (border = b.getBorder()) != null && border instanceof TinyButtonBorder.CompoundBorderUIResource) {
            if (isRollover && Theme.buttonRolloverBorder.getValue()) {
                imgGraphics.setColor(Theme.buttonRolloverColor.getColor());
                imgGraphics.drawLine(1, h - 2, 1, h - 2);
                imgGraphics.drawLine(w - 2, h - 2, w - 2, h - 2);
            } else if (this.isDefaultButton && b.isEnabled()) {
                imgGraphics.setColor(Theme.buttonDefaultColor.getColor());
                imgGraphics.drawLine(1, h - 2, 1, h - 2);
                imgGraphics.drawLine(w - 2, h - 2, w - 2, h - 2);
            }
            this.drawXpBorder(b, imgGraphics, 0, 0, w, h);
        }
        imgGraphics.dispose();
        g.drawImage(img, 0, 0, b);
        cache.put(key, img);
    }

    private void drawXpBorder(AbstractButton b, Graphics g, int x, int y, int w, int h) {
        boolean isComboBoxButton = Boolean.TRUE.equals(b.getClientProperty("isComboBoxButton"));
        if (isComboBoxButton) {
            if (!b.isEnabled()) {
                DrawRoutines.drawRoundedBorder(g, Theme.comboBorderDisabledColor.getColor(), x, y, w, h);
            } else {
                DrawRoutines.drawRoundedBorder(g, Theme.comboBorderColor.getColor(), x, y, w, h);
                if (b.getModel().isPressed()) {
                    return;
                }
                if (b.getModel().isRollover() && Theme.comboRollover.getValue()) {
                    DrawRoutines.drawRolloverBorder(g, Theme.buttonRolloverColor.getColor(), x, y, w, h);
                }
            }
        } else {
            boolean paintFocusBorder;
            boolean isDefault = b instanceof JButton && ((JButton)b).isDefaultButton();
            boolean isSpinnerButton = Boolean.TRUE.equals(b.getClientProperty("isSpinnerButton"));
            boolean paintRolloverBorder = isSpinnerButton && Theme.spinnerRollover.getValue() || !isSpinnerButton && Theme.buttonRolloverBorder.getValue();
            boolean bl = paintFocusBorder = isDefault || isSpinnerButton && Theme.buttonFocusBorder.getValue() && b.isFocusOwner() || !isSpinnerButton && Theme.buttonFocusBorder.getValue() && b.isFocusOwner() && b.isFocusPainted();
            if (!b.isEnabled()) {
                DrawRoutines.drawRoundedBorder(g, Theme.buttonBorderDisabledColor.getColor(), x, y, w, h);
            } else {
                DrawRoutines.drawRoundedBorder(g, Theme.buttonBorderColor.getColor(), x, y, w, h);
                if (b.getModel().isPressed()) {
                    return;
                }
                if (b.getModel().isRollover() && paintRolloverBorder) {
                    DrawRoutines.drawRolloverBorder(g, Theme.buttonRolloverColor.getColor(), x, y, w, h);
                } else if (paintFocusBorder) {
                    DrawRoutines.drawRolloverBorder(g, Theme.buttonDefaultColor.getColor(), x, y, w, h);
                }
            }
        }
    }

    private void drawXpButtonNoCache(Graphics g, AbstractButton b, Color c, boolean isRollover) {
        if (!b.isContentAreaFilled()) {
            return;
        }
        if (!b.isOpaque()) {
            return;
        }
        int w = b.getWidth();
        int h = b.getHeight();
        Color bg = b.getParent().getBackground();
        g.setColor(bg);
        g.drawRect(0, 0, w - 1, h - 1);
        int spread1 = Theme.buttonSpreadLight.getValue();
        int spread2 = Theme.buttonSpreadDark.getValue();
        if (!b.isEnabled()) {
            spread1 = Theme.buttonSpreadLightDisabled.getValue();
            spread2 = Theme.buttonSpreadDarkDisabled.getValue();
        }
        float spreadStep1 = 10.0f * (float)spread1 / (float)(h - 3);
        float spreadStep2 = 10.0f * (float)spread2 / (float)(h - 3);
        int halfY = h / 2;
        for (int y = 1; y < h - 1; ++y) {
            int yd;
            if (y < halfY) {
                yd = halfY - y;
                g.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
            } else if (y == halfY) {
                g.setColor(c);
            } else {
                yd = y - halfY;
                g.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
            }
            g.drawLine(2, y, w - 3, y);
            if (y == 1) {
                g.drawLine(1, 1, 1, h - 2);
                if (!isRollover && !this.isDefaultButton) continue;
                g.drawLine(w - 2, 1, w - 2, h - 2);
                continue;
            }
            if (y != h - 2 || isRollover || this.isDefaultButton) continue;
            g.drawLine(w - 2, 1, w - 2, h - 2);
        }
        if (b.isBorderPainted()) {
            if (isRollover && Theme.buttonRolloverBorder.getValue()) {
                g.setColor(Theme.buttonRolloverColor.getColor());
                g.drawLine(1, h - 2, 1, h - 2);
                g.drawLine(w - 2, h - 2, w - 2, h - 2);
            } else if (this.isDefaultButton && b.isEnabled()) {
                g.setColor(Theme.buttonDefaultColor.getColor());
                g.drawLine(1, h - 2, 1, h - 2);
                g.drawLine(w - 2, h - 2, w - 2, h - 2);
            }
        }
    }

    private void drawXpToolBarButton(Graphics g, AbstractButton b, Color c, boolean isPressed) {
        Color bg;
        int w = b.getWidth();
        int h = b.getHeight();
        if (b.isContentAreaFilled()) {
            g.fillRect(1, 1, w - 2, h - 2);
        }
        if ((bg = b.getParent().getBackground()) instanceof ColorUIResource && !this.isFileChooserButton) {
            g.setColor(Theme.toolBarColor.getColor());
        } else {
            g.setColor(bg);
        }
        g.drawRect(0, 0, w - 1, h - 1);
    }

    private static class ButtonKey {
        private Color background;
        private Color parentBackground;
        private int height;
        private boolean rollover;
        private boolean isDefault;
        private boolean hasFocus;
        private boolean isBorderPainted;

        ButtonKey(Color background, Color parentBackground, int height, boolean rollover, boolean isDefault, boolean hasFocus, boolean isBorderPainted) {
            this.background = background;
            this.parentBackground = parentBackground;
            this.height = height;
            this.rollover = rollover;
            this.isDefault = isDefault;
            this.hasFocus = hasFocus;
            this.isBorderPainted = isBorderPainted;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof ButtonKey)) {
                return false;
            }
            ButtonKey other = (ButtonKey)o;
            return this.height == other.height && this.rollover == other.rollover && this.isDefault == other.isDefault && this.hasFocus == other.hasFocus && this.isBorderPainted == other.isBorderPainted && this.background.equals(other.background) && this.parentBackground.equals(other.parentBackground);
        }

        public int hashCode() {
            return this.background.hashCode() * this.parentBackground.hashCode() * this.height * (this.rollover ? 2 : 1) * (this.isDefault ? 8 : 4) * (this.hasFocus ? 16 : 8) * (this.isBorderPainted ? 32 : 16);
        }
    }
}

