/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.colorscheme.ShadeColorScheme;
import org.jvnet.substance.colorscheme.ShiftColorScheme;
import org.jvnet.substance.colorscheme.TintColorScheme;
import org.jvnet.substance.colorscheme.ToneColorScheme;
import org.jvnet.substance.painter.border.SubstanceBorderPainter;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

@Deprecated
public abstract class InnerDelegateBorderPainter
implements SubstanceBorderPainter {
    protected String painterName;
    protected SubstanceBorderPainter delegate;
    protected float shiftCoef;
    protected SubstanceConstants.ColorShiftKind shiftKind;
    protected static LazyResettableHashMap<SubstanceColorScheme> shiftMap = new LazyResettableHashMap("InnerDelegateBorderPainter");

    public InnerDelegateBorderPainter(String painterName, SubstanceBorderPainter delegate) {
        this(painterName, delegate, 0.7f, SubstanceConstants.ColorShiftKind.TINT);
    }

    public InnerDelegateBorderPainter(String painterName, SubstanceBorderPainter delegate, float shiftCoef, SubstanceConstants.ColorShiftKind shiftKind) {
        this.painterName = painterName;
        this.delegate = delegate;
        this.shiftCoef = shiftCoef;
        this.shiftKind = shiftKind;
    }

    @Override
    public String getDisplayName() {
        return this.painterName;
    }

    @Override
    public void paintBorder(Graphics g, Component comp, int width, int height, Shape contour, Shape innerContour, SubstanceColorScheme colorScheme1, SubstanceColorScheme colorScheme2, float cyclePos, boolean useCyclePosAsInterpolation) {
        if (innerContour != null) {
            this.delegate.paintBorder(g, comp, width, height, innerContour, null, this.getShiftScheme(colorScheme1), this.getShiftScheme(colorScheme2), cyclePos, useCyclePosAsInterpolation);
        }
        if (contour != null) {
            this.delegate.paintBorder(g, comp, width, height, contour, null, colorScheme1, colorScheme2, cyclePos, useCyclePosAsInterpolation);
        }
    }

    public SubstanceColorScheme getShiftScheme(SubstanceColorScheme orig) {
        HashMapKey key = SubstanceCoreUtilities.getHashKey(orig.getDisplayName(), Float.valueOf(this.shiftCoef), this.shiftKind.name());
        if (!shiftMap.containsKey(key)) {
            switch (this.shiftKind) {
                case TINT: {
                    shiftMap.put(key, new TintColorScheme(orig, this.shiftCoef));
                    break;
                }
                case TONE: {
                    shiftMap.put(key, new ToneColorScheme(orig, this.shiftCoef));
                    break;
                }
                case SHADE: {
                    shiftMap.put(key, new ShadeColorScheme(orig, this.shiftCoef));
                    break;
                }
                case THEME_LIGHT: {
                    shiftMap.put(key, new ShiftColorScheme(orig, orig.getUltraLightColor().brighter(), this.shiftCoef));
                }
            }
        }
        return shiftMap.get(key);
    }

    public SubstanceBorderPainter getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isPaintingInnerContour() {
        return true;
    }
}

