/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.postgres.actions;

import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.action.IObjectTreeAction;
import net.sourceforge.squirrel_sql.fw.resources.IResources;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.ICommand;

public abstract class AbstractObjectTreeAction
extends SquirrelAction
implements IObjectTreeAction {
    protected IObjectTreeAPI _tree;

    public AbstractObjectTreeAction(IApplication app, IResources rsrc) {
        super(app, rsrc);
    }

    public void actionPerformed(ActionEvent evt) {
        if (this._tree != null) {
            IDatabaseObjectInfo[] infos = this._tree.getSelectedDatabaseObjects();
            if (infos.length > 1 && !this.isMultipleObjectAction()) {
                this._tree.getSession().showMessage(this.getErrorMessage());
            } else {
                try {
                    this.getCommand(infos).execute();
                }
                catch (Exception e) {
                    this._tree.getSession().showMessage((Throwable)e);
                }
            }
        }
    }

    protected abstract ICommand getCommand(IDatabaseObjectInfo[] var1);

    protected abstract boolean isMultipleObjectAction();

    protected abstract String getErrorMessage();

    public void setObjectTree(IObjectTreeAPI tree) {
        this._tree = tree;
        this.setEnabled(this._tree != null);
    }
}

