/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.postgres.types;

import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.EmptyWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IsNullWhereClausePart;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.postgres.types.PostgreSqlGeometryTypeDataTypeComponentFactory;
import org.postgis.PGgeometry;

public class PostgreSqlGeometryTypeDataTypeComponent
extends BaseDataTypeComponent {
    private static final int NUM_POINTS_INDEX = 3;
    private static final int CENTER_INDEX = 2;
    private static final int TYPE_INDEX = 1;
    private static final int BRIEF_INDICATOR_INDEX = 0;
    private static ILogger s_log = LoggerController.createLogger(PostgreSqlGeometryTypeDataTypeComponent.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(PostgreSqlGeometryTypeDataTypeComponent.class);
    private static final String BRIEF_INDICATOR = "bRiEf";
    private final PostgreSqlGeometryTypeDataTypeComponentFactory factory;

    public PostgreSqlGeometryTypeDataTypeComponent(PostgreSqlGeometryTypeDataTypeComponentFactory factory) {
        this.factory = factory;
    }

    public boolean canDoFileIO() {
        return true;
    }

    public String getClassName() {
        return String.class.getName();
    }

    public Object getDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue != null) {
            return dbDefaultValue;
        }
        try {
            return "SRID=" + this.factory.fetchSrid(this._colDef) + ";POINT(0 0)";
        }
        catch (SQLException sqlE) {
            throw new RuntimeException(sqlE);
        }
    }

    public IWhereClausePart getWhereClauseValue(Object value, ISQLDatabaseMetaData md) {
        if (value == null || value.toString() == null) {
            return new IsNullWhereClausePart(this._colDef);
        }
        return new EmptyWhereClausePart();
    }

    public boolean isEditableInCell(Object originalValue) {
        return true;
    }

    public boolean isEditableInPopup(Object originalValue) {
        return true;
    }

    public boolean needToReRead(Object originalValue) {
        return originalValue instanceof String;
    }

    public Object readResultSet(ResultSet rs, int idx, boolean limitDataRead) throws SQLException {
        String[] split;
        Object object = rs.getObject(idx);
        if (object == null) {
            return "<null>";
        }
        if (limitDataRead && (split = object.toString().split(";"))[0].equals(BRIEF_INDICATOR)) {
            return this.createBriefInfo(split);
        }
        try {
            if (object.getClass().getName().equals(PGgeometry.class.getName())) {
                Method method = object.getClass().getMethod("getGeometry", new Class[0]);
                return method.invoke(object, new Object[0]);
            }
            return object.toString();
        }
        catch (Exception e) {
            s_log.error((Object)"Unexpected exception while attempting to read PostgreSQL Geometry column", (Throwable)e);
            return i18n.CELL_ERROR_MSG;
        }
    }

    private Object createBriefInfo(String[] info) {
        return s_stringMgr.getString("PostgreSqlGeometryTypeDataTypeComponent.briefGeoFormat", new Object[]{info[1], info[2].replace("POINT", ""), info[3]});
    }

    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null) {
            pstmt.setNull(position, 1111);
        } else {
            try {
                pstmt.setObject(position, value, 1111);
            }
            catch (Exception e) {
                s_log.error((Object)("setPreparedStatementValue: Unexpected exception - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public boolean useBinaryEditingPanel() {
        return false;
    }

    public boolean areEqual(Object obj1, Object obj2) {
        return obj1.equals(obj2);
    }

    protected String quoteTextConditionValue(String value) {
        return StringUtilities.singleQuote((String)value);
    }

    public String getCondition(String column, String operator, String value) {
        if (operator.startsWith("ST_")) {
            return operator + '(' + column + ',' + StringUtilities.singleQuote((String)value) + ')';
        }
        return super.getCondition(column, operator, value);
    }

    public String[] getSupportedOperators() {
        return new String[]{"=", "<>", "IN", "IS NULL", "IS NOT NULL", "ST_Equals", "ST_Intersects", "ST_Touches", "ST_Crosses", "ST_Within", "ST_Overlaps", "ST_Contains", "ST_Covers", "ST_CoveredBy", "ST_Intersects"};
    }

    public String getColumnForContentSelect(DialectType dialectType, String columnPrefix) {
        String fullName = columnPrefix + this._colDef.getColumnName();
        return "'bRiEf;'||GeometryType(" + fullName + ")||';'||st_asText(st_centroid(" + fullName + "))||';'||st_NPoints(" + fullName + ")";
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String CELL_ERROR_MSG = PostgreSqlGeometryTypeDataTypeComponent.access$000().getString("PostgreSqlXmlTypeDataTypeComponent.cellErrorMsg");
        public static final String BRIEF_GEO_FORMAT = "PostgreSqlGeometryTypeDataTypeComponent.briefGeoFormat";
    }
}

