/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tga;

import com.twelvemonkeys.imageio.AbstractMetadata;
import com.twelvemonkeys.imageio.plugins.tga.TGAExtensions;
import com.twelvemonkeys.imageio.plugins.tga.TGAHeader;
import com.twelvemonkeys.lang.Validate;
import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.util.Calendar;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

final class TGAMetadata
extends AbstractMetadata {
    private final TGAHeader header;
    private final TGAExtensions extensions;

    TGAMetadata(TGAHeader tGAHeader, TGAExtensions tGAExtensions) {
        this.header = (TGAHeader)Validate.notNull((Object)tGAHeader, (String)"header");
        this.extensions = tGAExtensions;
    }

    protected IIOMetadataNode getStandardChromaNode() {
        Object object;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        switch (this.header.getImageType()) {
            case 3: 
            case 11: {
                iIOMetadataNode2.setAttribute("name", "GRAY");
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 32: 
            case 33: {
                iIOMetadataNode2.setAttribute("name", "RGB");
                break;
            }
            default: {
                iIOMetadataNode2.setAttribute("name", "Unknown");
            }
        }
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("NumChannels");
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        switch (this.header.getPixelDepth()) {
            case 8: {
                iIOMetadataNode3.setAttribute("value", Integer.toString(1));
                break;
            }
            case 16: {
                if (this.header.getAttributeBits() > 0 && this.extensions != null && this.extensions.hasAlpha()) {
                    iIOMetadataNode3.setAttribute("value", Integer.toString(4));
                    break;
                }
                iIOMetadataNode3.setAttribute("value", Integer.toString(3));
                break;
            }
            case 24: {
                iIOMetadataNode3.setAttribute("value", Integer.toString(3));
                break;
            }
            case 32: {
                iIOMetadataNode3.setAttribute("value", Integer.toString(4));
            }
        }
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("BlackIsZero");
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        iIOMetadataNode4.setAttribute("value", "TRUE");
        IndexColorModel indexColorModel = this.header.getColorMap();
        if (indexColorModel != null) {
            object = new IIOMetadataNode("Palette");
            iIOMetadataNode.appendChild((Node)object);
            for (int i = 0; i < indexColorModel.getMapSize(); ++i) {
                IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("PaletteEntry");
                ((IIOMetadataNode)object).appendChild(iIOMetadataNode5);
                iIOMetadataNode5.setAttribute("index", Integer.toString(i));
                iIOMetadataNode5.setAttribute("red", Integer.toString(indexColorModel.getRed(i)));
                iIOMetadataNode5.setAttribute("green", Integer.toString(indexColorModel.getGreen(i)));
                iIOMetadataNode5.setAttribute("blue", Integer.toString(indexColorModel.getBlue(i)));
            }
        }
        if (this.extensions != null && this.extensions.getBackgroundColor() != 0) {
            object = new Color(this.extensions.getBackgroundColor(), true);
            IIOMetadataNode iIOMetadataNode6 = new IIOMetadataNode("BackgroundColor");
            iIOMetadataNode.appendChild(iIOMetadataNode6);
            iIOMetadataNode6.setAttribute("red", Integer.toString(((Color)object).getRed()));
            iIOMetadataNode6.setAttribute("green", Integer.toString(((Color)object).getGreen()));
            iIOMetadataNode6.setAttribute("blue", Integer.toString(((Color)object).getBlue()));
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardCompressionNode() {
        switch (this.header.getImageType()) {
            case 9: 
            case 10: 
            case 11: 
            case 32: 
            case 33: {
                IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
                IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
                iIOMetadataNode.appendChild(iIOMetadataNode2);
                String string = this.header.getImageType() == 32 || this.header.getImageType() == 33 ? "Uknown" : "RLE";
                iIOMetadataNode2.setAttribute("value", string);
                IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("Lossless");
                iIOMetadataNode.appendChild(iIOMetadataNode3);
                iIOMetadataNode3.setAttribute("value", "TRUE");
                return iIOMetadataNode;
            }
        }
        return null;
    }

    protected IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("PlanarConfiguration");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2.setAttribute("value", "PixelInterleaved");
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("SampleFormat");
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        switch (this.header.getImageType()) {
            case 1: 
            case 9: 
            case 32: 
            case 33: {
                iIOMetadataNode3.setAttribute("value", "Index");
                break;
            }
            default: {
                iIOMetadataNode3.setAttribute("value", "UnsignedIntegral");
            }
        }
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("BitsPerSample");
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        switch (this.header.getPixelDepth()) {
            case 8: {
                iIOMetadataNode4.setAttribute("value", this.createListValue(1, Integer.toString(this.header.getPixelDepth())));
                break;
            }
            case 16: {
                if (this.header.getAttributeBits() > 0 && this.extensions != null && this.extensions.hasAlpha()) {
                    iIOMetadataNode4.setAttribute("value", "5, 5, 5, 1");
                    break;
                }
                iIOMetadataNode4.setAttribute("value", this.createListValue(3, "5"));
                break;
            }
            case 24: {
                iIOMetadataNode4.setAttribute("value", this.createListValue(3, Integer.toString(8)));
                break;
            }
            case 32: {
                iIOMetadataNode4.setAttribute("value", this.createListValue(4, Integer.toString(8)));
            }
        }
        return iIOMetadataNode;
    }

    private String createListValue(int n, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(stringArray[i % stringArray.length]);
        }
        return stringBuilder.toString();
    }

    protected IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        switch (this.header.getOrigin()) {
            case 0: {
                iIOMetadataNode2.setAttribute("value", "FlipH");
                break;
            }
            case 1: {
                iIOMetadataNode2.setAttribute("value", "Rotate180");
                break;
            }
            case 2: {
                iIOMetadataNode2.setAttribute("value", "Normal");
                break;
            }
            case 3: {
                iIOMetadataNode2.setAttribute("value", "FlipV");
            }
        }
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("PixelAspectRatio");
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        iIOMetadataNode3.setAttribute("value", this.extensions != null ? String.valueOf(this.extensions.getPixelAspectRatio()) : "1.0");
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardDocumentNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Document");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("FormatVersion");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2.setAttribute("value", this.extensions == null ? "1.0" : "2.0");
        if (this.extensions != null && this.extensions.getCreationDate() != null) {
            IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("ImageCreationTime");
            iIOMetadataNode.appendChild(iIOMetadataNode3);
            Calendar calendar = this.extensions.getCreationDate();
            iIOMetadataNode3.setAttribute("year", String.valueOf(calendar.get(1)));
            iIOMetadataNode3.setAttribute("month", String.valueOf(calendar.get(2) + 1));
            iIOMetadataNode3.setAttribute("day", String.valueOf(calendar.get(5)));
            iIOMetadataNode3.setAttribute("hour", String.valueOf(calendar.get(11)));
            iIOMetadataNode3.setAttribute("minute", String.valueOf(calendar.get(12)));
            iIOMetadataNode3.setAttribute("second", String.valueOf(calendar.get(13)));
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardTextNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Text");
        if (this.header.getIdentification() != null && !this.header.getIdentification().isEmpty()) {
            this.appendTextEntry(iIOMetadataNode, "DocumentName", this.header.getIdentification());
        }
        if (this.extensions != null) {
            this.appendTextEntry(iIOMetadataNode, "Software", this.extensions.getSoftwareVersion() == null ? this.extensions.getSoftware() : this.extensions.getSoftware() + " " + this.extensions.getSoftwareVersion());
            this.appendTextEntry(iIOMetadataNode, "Artist", this.extensions.getAuthorName());
            this.appendTextEntry(iIOMetadataNode, "UserComment", this.extensions.getAuthorComments());
        }
        return iIOMetadataNode.hasChildNodes() ? iIOMetadataNode : null;
    }

    private void appendTextEntry(IIOMetadataNode iIOMetadataNode, String string, String string2) {
        if (string2 != null) {
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2.setAttribute("keyword", string);
            iIOMetadataNode2.setAttribute("value", string2);
        }
    }

    protected IIOMetadataNode getStandardTransparencyNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Transparency");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Alpha");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.extensions != null) {
            if (this.extensions.hasAlpha()) {
                iIOMetadataNode2.setAttribute("value", this.extensions.isAlphaPremultiplied() ? "premultiplied" : "nonpremultiplied");
            } else {
                iIOMetadataNode2.setAttribute("value", "none");
            }
        } else if (this.header.getAttributeBits() == 8) {
            iIOMetadataNode2.setAttribute("value", "nonpremultiplied");
        } else {
            iIOMetadataNode2.setAttribute("value", "none");
        }
        return iIOMetadataNode;
    }
}

