/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pcx;

import com.twelvemonkeys.imageio.plugins.pcx.PCXImageReader;
import java.awt.image.IndexColorModel;

final class CGAColorModel {
    private static final int[] CGA_PALETTE = new int[]{0, 170, 43520, 43690, 0xAA0000, 0xAA00AA, 0xAA5500, 0xAAAAAA, 0x555555, 0x5555FF, 0x55FF55, 0x55FFFF, 0xFF5555, 0xFF55FF, 0xFFFF55, 0xFFFFFF};

    CGAColorModel() {
    }

    static IndexColorModel create(byte[] byArray, int n) {
        int[] nArray = new int[1 << n];
        byte by = byArray[0];
        int n2 = (by & 0xF0) >> 4;
        nArray[0] = CGA_PALETTE[n2];
        if (n == 1) {
            nArray[1] = CGA_PALETTE[0];
        } else {
            boolean bl;
            byte by2 = byArray[3];
            boolean bl2 = (by2 & 0x80) != 0;
            boolean bl3 = (by2 & 0x40) != 0;
            boolean bl4 = bl = (by2 & 0x20) != 0;
            if (PCXImageReader.DEBUG) {
                System.err.println("colorBurstEnable: " + bl2);
                System.err.println("paletteValue: " + bl3);
                System.err.println("intensityValue: " + bl);
            }
            if (bl3) {
                if (bl) {
                    nArray[1] = CGA_PALETTE[11];
                    nArray[2] = bl2 ? CGA_PALETTE[13] : CGA_PALETTE[12];
                    nArray[3] = CGA_PALETTE[15];
                } else {
                    nArray[1] = CGA_PALETTE[3];
                    nArray[2] = bl2 ? CGA_PALETTE[5] : CGA_PALETTE[4];
                    nArray[3] = CGA_PALETTE[7];
                }
            } else if (bl) {
                nArray[1] = CGA_PALETTE[10];
                nArray[2] = CGA_PALETTE[12];
                nArray[3] = CGA_PALETTE[14];
            } else {
                nArray[1] = CGA_PALETTE[2];
                nArray[2] = CGA_PALETTE[4];
                nArray[3] = CGA_PALETTE[6];
            }
        }
        return new IndexColorModel(n, nArray.length, nArray, 0, false, -1, 0);
    }
}

