/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.freehep.graphicsio.pdf.PDFDelayUtils;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFName;
import org.freehep.graphicsio.pdf.PDFRef;
import org.freehep.graphicsio.pdf.PDFWriter;

public class PDFCycleDelayQueue {
    private final PDFWriter pdf;
    private final List patterns;
    private AffineTransform pageMatrix;

    public PDFCycleDelayQueue(PDFWriter pDFWriter) {
        this.pdf = pDFWriter;
        this.patterns = new ArrayList(2);
    }

    public void addCycles(PDFDictionary pDFDictionary) throws IOException {
        if (!this.patterns.isEmpty()) {
            Iterator iterator = this.patterns.iterator();
            while (iterator.hasNext()) {
                PDFDelayUtils.Entry entry = (PDFDelayUtils.Entry)iterator.next();
                pDFDictionary.entry(entry.name, this.pdf.ref(entry.name));
            }
        }
    }

    public void writeCycles() throws IOException {
        if (!this.patterns.isEmpty()) {
            CycleWriteContext cycleWriteContext = new CycleWriteContext(this.pdf);
            Iterator iterator = this.patterns.iterator();
            while (iterator.hasNext()) {
                PDFDelayUtils.Entry entry = (PDFDelayUtils.Entry)iterator.next();
                if ((entry.state & 1) != 0) continue;
                entry.state = (byte)(entry.state | 1);
                this.writeCycle(entry, cycleWriteContext);
            }
        }
    }

    private void writeCycle(PDFDelayUtils.Entry entry, PDFDelayUtils.WriteContext writeContext) throws IOException {
        PDFDelayUtils.FunctionData functionData = PDFDelayUtils.FunctionData.newInstance(entry.paint, entry.bnds);
        if (functionData.count > 1) {
            this.writeCycle(entry, writeContext, functionData);
        } else {
            this.writeLinear(entry, writeContext, functionData);
        }
    }

    private void writeCycle(PDFDelayUtils.Entry entry, PDFDelayUtils.WriteContext writeContext, PDFDelayUtils.FunctionData functionData) throws IOException {
        PDFRef pDFRef = writeContext.addFunction(entry, true);
        PDFDictionary pDFDictionary = this.pdf.openDictionary(entry.name);
        pDFDictionary.entry("Type", this.pdf.name("Pattern"));
        pDFDictionary.entry("PatternType", 2);
        AffineTransform affineTransform = new AffineTransform(this.pageMatrix);
        affineTransform.concatenate(entry.transform);
        affineTransform.getMatrix(writeContext.shared6);
        pDFDictionary.entry("Matrix", writeContext.shared6);
        PDFDelayUtils.writeCyclicShading("Shading", writeContext, functionData, pDFRef, pDFDictionary);
        this.pdf.close(pDFDictionary);
    }

    private void writeLinear(PDFDelayUtils.Entry entry, PDFDelayUtils.WriteContext writeContext, PDFDelayUtils.FunctionData functionData) throws IOException {
        PDFRef pDFRef = writeContext.addFunction(entry, functionData.startInDirection);
        PDFDictionary pDFDictionary = this.pdf.openDictionary(entry.name);
        pDFDictionary.entry("Type", this.pdf.name("Pattern"));
        pDFDictionary.entry("PatternType", 2);
        AffineTransform affineTransform = new AffineTransform(this.pageMatrix);
        affineTransform.concatenate(entry.transform);
        affineTransform.getMatrix(writeContext.shared6);
        pDFDictionary.entry("Matrix", writeContext.shared6);
        PDFDictionary pDFDictionary2 = pDFDictionary.openDictionary("Shading");
        pDFDictionary2.entry("ShadingType", 2);
        pDFDictionary2.entry("ColorSpace", this.pdf.name("DeviceRGB"));
        pDFDictionary2.entry("Coords", writeContext.getCoords(functionData));
        pDFDictionary2.entry("Domain", PDFDelayUtils.DEFAULT_DOMAIN);
        pDFDictionary2.entry("Function", pDFRef);
        pDFDictionary.close(pDFDictionary2);
        this.pdf.close(pDFDictionary);
    }

    public void setPageMatrix(AffineTransform affineTransform) {
        this.pageMatrix = new AffineTransform(affineTransform);
    }

    public PDFName delayCycle(GradientPaint gradientPaint, Rectangle rectangle, AffineTransform affineTransform) {
        PDFDelayUtils.Entry entry = new PDFDelayUtils.Entry("CyclePattern" + (this.patterns.size() + 1), gradientPaint, rectangle, affineTransform);
        this.patterns.add(entry);
        return this.pdf.name(entry.name);
    }

    public boolean isEmpty() {
        return this.patterns.isEmpty();
    }

    private static final class CycleWriteContext
    extends PDFDelayUtils.WriteContext {
        CycleWriteContext(PDFWriter pDFWriter) {
            super(pDFWriter);
        }

        double[] asArray(Color color) {
            this.shared3[0] = (double)color.getRed() / 255.0;
            this.shared3[1] = (double)color.getGreen() / 255.0;
            this.shared3[2] = (double)color.getBlue() / 255.0;
            return this.shared3;
        }

        double[] getRange() {
            return PDFDelayUtils.DEFAULT_RANGE;
        }

        String getColorSpace() {
            return "DeviceRGB";
        }
    }
}

