/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.dictionary;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.java.sen.dictionary.Morpheme;
import net.java.sen.dictionary.Node;
import net.java.sen.dictionary.Reading;
import net.java.sen.dictionary.Sentence;
import net.java.sen.dictionary.SentenceIterator;
import net.java.sen.dictionary.Token;
import net.java.sen.dictionary.Tokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Viterbi {
    private final Tokenizer tokenizer;
    private Node bosNode;
    private Node eosNode;
    private Node[] endNodeList;

    private final void calculateConnectionCosts(int position, int limit, Node rNode, Sentence sentence) throws IOException {
        while (rNode != null) {
            int bestCost = Integer.MAX_VALUE;
            Node bestNode = null;
            Node lNode = this.endNodeList[position];
            while (lNode != null) {
                int cost = lNode.cost + this.tokenizer.getDictionary().getCost(lNode.prev, lNode, rNode);
                if (cost <= bestCost) {
                    bestNode = lNode;
                    bestCost = cost;
                }
                lNode = lNode.lnext;
            }
            rNode.prev = bestNode;
            rNode.cost = bestCost;
            int x = position + rNode.span;
            rNode.lnext = this.endNodeList[x];
            this.endNodeList[x] = rNode;
            if (rNode.rcAttr2 != 0) {
                SentenceIterator it = sentence.iterator();
                int pos2 = rNode.span + position;
                if (pos2 != limit) {
                    int pos3 = 0;
                    for (int i = 0; i <= pos2; ++i) {
                        if (!it.hasNextOrigin()) continue;
                        pos3 = it.nextOrigin();
                    }
                    if (pos2 == pos3) {
                        Node rNode2 = this.lookup(it, sentence.getCharacters(), sentence.getReadingConstraint(pos2));
                        while (rNode2 != null) {
                            rNode2 = rNode2.clone();
                            rNode2.cost = rNode.cost + this.tokenizer.getDictionary().getCost(rNode.prev, rNode, rNode2);
                            rNode2.prev = rNode;
                            int y = pos2 + rNode2.span;
                            rNode2.lnext = this.endNodeList[y];
                            this.endNodeList[y] = rNode2;
                            rNode2 = rNode2.rnext;
                        }
                    }
                }
            }
            rNode = rNode.rnext;
        }
    }

    private Node lookup(SentenceIterator iterator, char[] surface, Reading constraint) throws IOException {
        Morpheme unknownMorpheme;
        Node resultNode = this.tokenizer.lookup(iterator, surface);
        if (constraint == null) {
            return resultNode;
        }
        Node filteredResultNode = null;
        Node lastNode = null;
        Node node = resultNode;
        while (node != null) {
            if (node.length == constraint.length && node.morpheme.getReadings().contains(constraint.text)) {
                if (filteredResultNode == null) {
                    filteredResultNode = node;
                } else {
                    lastNode.rnext = node;
                }
                lastNode = node;
            }
            node = node.rnext;
        }
        if (lastNode != null) {
            lastNode.rnext = null;
            return filteredResultNode;
        }
        Node unknownNode = this.tokenizer.getUnknownNode(surface, iterator.origin(), constraint.length, constraint.length + iterator.skippedCharCount());
        unknownNode.morpheme = unknownMorpheme = new Morpheme(unknownNode.morpheme.getPartOfSpeech(), null, null, "*", new String[]{constraint.text}, new String[0], unknownNode.morpheme.getAdditionalInformation());
        return unknownNode;
    }

    public List<Token> getPossibleTokens(Sentence sentence, int position) throws IOException {
        Node resultNode = this.tokenizer.lookup(sentence.unconstrainedIterator(position), sentence.getCharacters());
        String sentenceString = new String(sentence.getCharacters());
        ArrayList<Token> tokenList = new ArrayList<Token>();
        while (resultNode != null) {
            Token token = new Token(sentenceString, resultNode);
            tokenList.add(token);
            resultNode = resultNode.rnext;
        }
        return tokenList;
    }

    public List<Token> getBestTokens(Sentence sentence, List<Token> reuse) throws IOException {
        int position;
        SentenceIterator iterator = sentence.iterator();
        int length = iterator.length();
        char[] surface = sentence.getCharacters();
        this.bosNode = this.tokenizer.getBOSNode();
        this.eosNode = this.tokenizer.getEOSNode();
        this.endNodeList = new Node[length + 1];
        this.endNodeList[0] = this.bosNode;
        this.endNodeList[length] = null;
        while (iterator.hasNextOrigin()) {
            Node rNode;
            position = iterator.nextOrigin();
            int base = position - iterator.skippedCharCount();
            if (this.endNodeList[base] == null || (rNode = this.lookup(iterator, surface, sentence.getReadingConstraint(position))) == null) continue;
            this.calculateConnectionCosts(base, length, rNode, sentence);
        }
        for (position = length; position >= 0; --position) {
            if (this.endNodeList[position] == null) continue;
            this.calculateConnectionCosts(position, length, this.eosNode, sentence);
            break;
        }
        Node node = this.eosNode;
        while (node.prev != null) {
            Node prevNode = node.prev;
            prevNode.next = node;
            node = prevNode;
        }
        String sentenceString = new String(sentence.getCharacters());
        List<Token> tokenList = reuse;
        tokenList.clear();
        node = this.bosNode.next;
        while (node != null && node.next != null) {
            Token token = new Token(sentenceString, node);
            tokenList.add(token);
            node = node.next;
        }
        return tokenList;
    }

    @Deprecated
    public List<Token> getBestTokens(Sentence sentence) throws IOException {
        return this.getBestTokens(sentence, new ArrayList<Token>());
    }

    public Viterbi(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }
}

