/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.filter.reading;

import java.util.List;
import net.java.sen.dictionary.Reading;
import net.java.sen.dictionary.Token;
import net.java.sen.filter.ReadingFilter;
import net.java.sen.filter.ReadingNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberFilter
implements ReadingFilter {
    @Override
    public void filterReadings(List<Token> tokens, ReadingNode readingNode) {
        ReadingNode node = readingNode;
        while (node != null) {
            if (node.firstToken == node.lastToken && node.displayReadings.size() == 1) {
                Token token = tokens.get(node.firstToken);
                Reading reading = node.displayReadings.get(0);
                String surface = token.getSurface();
                if (token.getMorpheme().getPartOfSpeech().equals("\u540d\u8a5e-\u6570") && "\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u767e\u5343\u4e07".contains(token.getSurface())) {
                    node.visible = false;
                }
                if (surface.length() >= 2 && (surface.startsWith("\u30f5") || surface.startsWith("\u30f6") || surface.startsWith("\u30ab") || surface.startsWith("\u30b1")) && Character.UnicodeBlock.of(surface.charAt(1)) == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS && reading.text.charAt(0) == '\u304b') {
                    Reading newReading = new Reading(reading.start + 1, reading.length - 1, reading.text.substring(1));
                    node.displayReadings.set(0, newReading);
                } else if (token.getMorpheme().getPartOfSpeech().equals("\u540d\u8a5e-\u63a5\u5c3e-\u52a9\u6570\u8a5e") && node.prev != null && tokens.get(node.prev.lastToken).getMorpheme().getPartOfSpeech().equals("\u540d\u8a5e-\u6570") && "\u5206\u6b69\u672c\u54c1\u8fba\u676f\u5831\u7248\u6cca\u6d3e\u6ce2\u7fbd".contains(surface)) {
                    char firstReadingChar = reading.text.charAt(0);
                    String numberKanji = tokens.get(node.prev.lastToken).getSurface();
                    if ("\u4e00\u4e09\u56db\u516d\u516b\u5341\u767e\u5343\u4e07".contains(numberKanji) && "\u306f\u3072\u3075\u3078\u307b".indexOf(firstReadingChar) != -1) {
                        String newText = (char)(firstReadingChar + 2) + reading.text.substring(1, reading.text.length());
                        Reading newReading = new Reading(reading.start, reading.length, newText);
                        node.baseReadings.set(0, newReading);
                        node.displayReadings.set(0, newReading);
                    }
                }
            }
            node = node.next;
        }
    }

    @Override
    public void reset() {
    }
}

