/*
 * Decompiled with CFR 0.152.
 */
package de.danielnaber.jwordsplitter;

import de.danielnaber.jwordsplitter.AbstractWordSplitter;
import de.danielnaber.jwordsplitter.EmbeddedGermanDictionary;
import de.danielnaber.jwordsplitter.GermanInterfixDisambiguator;
import de.danielnaber.jwordsplitter.tools.FileTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public class GermanWordSplitter
extends AbstractWordSplitter {
    private static final String EXCEPTION_DICT = "/de/danielnaber/jwordsplitter/exceptionsGerman.txt";
    private static final Collection<String> INTERFIXES = Arrays.asList("s-", "s", "-");
    private GermanInterfixDisambiguator disambiguator;

    public GermanWordSplitter(boolean hideInterfixCharacters) throws IOException {
        super(hideInterfixCharacters, EmbeddedGermanDictionary.getWords());
        this.init();
    }

    public GermanWordSplitter(boolean hideInterfixCharacters, InputStream plainTextDict) throws IOException {
        super(hideInterfixCharacters, plainTextDict);
        this.init();
    }

    public GermanWordSplitter(boolean hideInterfixCharacters, File plainTextDict) throws IOException {
        super(hideInterfixCharacters, plainTextDict);
        this.init();
    }

    private void init() throws IOException {
        this.disambiguator = new GermanInterfixDisambiguator(this.getWordList());
        this.setExceptionFile(EXCEPTION_DICT);
    }

    @Override
    protected Set<String> getWordList(InputStream stream) throws IOException {
        return FileTools.loadFileToSet(stream, "utf-8");
    }

    @Override
    protected Set<String> getWordList() {
        return EmbeddedGermanDictionary.getWords();
    }

    @Override
    protected GermanInterfixDisambiguator getDisambiguator() {
        return this.disambiguator;
    }

    @Override
    protected int getDefaultMinimumWordLength() {
        return 3;
    }

    @Override
    protected Collection<String> getInterfixCharacters() {
        return INTERFIXES;
    }
}

