/*
 * Decompiled with CFR 0.152.
 */
package com.pomodorotechnique.client.ui;

import com.pomodorotechnique.client.ui.PomodoroClientApp;
import com.pomodorotechnique.client.ui.Util;
import com.pomodorotechnique.server.MessageType;
import com.pomodorotechnique.server.Messages;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;

public class MessagesWindow
extends JDialog {
    private final Messages messages;
    private JLabel headerLogoLabel;
    private JPanel headerPanel;
    private JLabel headerTextLabel;
    private JButton jButton1;
    private JEditorPane jEditorPane1;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;

    private void parseMessages() {
        String finalTxt = "<ul>";
        for (MessageType m : this.messages.getMessage()) {
            finalTxt = finalTxt + String.format("<li>From <i>%s</i> at %s</b>:<pre>%s</pre></li>", m.getFrom(), m.getWhen(), m.getText());
        }
        finalTxt = finalTxt + "</ul>";
        this.jEditorPane1.setText(finalTxt);
    }

    public MessagesWindow(Frame parent, boolean modal, Messages messages) {
        super(parent, modal);
        this.messages = messages;
        this.initComponents();
        this.parseMessages();
        this.getRootPane().setDefaultButton(this.jButton1);
        Util.decorate(this, true);
    }

    private void initComponents() {
        this.headerPanel = new JPanel();
        this.headerTextLabel = new JLabel();
        this.headerLogoLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPane1 = new JEditorPane();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(PomodoroClientApp.class).getContext().getResourceMap(MessagesWindow.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.headerPanel.setBackground(resourceMap.getColor("headerPanel.background"));
        this.headerPanel.setBorder(BorderFactory.createLineBorder(resourceMap.getColor("headerPanel.border.lineColor")));
        this.headerPanel.setName("headerPanel");
        this.headerTextLabel.setFont(this.headerTextLabel.getFont().deriveFont((float)this.headerTextLabel.getFont().getSize() + 7.0f));
        this.headerTextLabel.setText(resourceMap.getString("headerTextLabel.text", new Object[0]));
        this.headerTextLabel.setName("headerTextLabel");
        this.headerLogoLabel.setIcon(resourceMap.getIcon("headerLogoLabel.icon"));
        this.headerLogoLabel.setName("headerLogoLabel");
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, headerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.headerTextLabel, -1, 103, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerLogoLabel)));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerLogoLabel).addComponent(this.headerTextLabel, -1, 68, Short.MAX_VALUE));
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        ApplicationActionMap actionMap = Application.getInstance(PomodoroClientApp.class).getContext().getActionMap(MessagesWindow.class, this);
        this.jButton1.setAction(actionMap.get("closeWindow"));
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setName("jButton1");
        this.jScrollPane1.setName("jScrollPane1");
        this.jEditorPane1.setContentType(resourceMap.getString("jEditorPane1.contentType", new Object[0]));
        this.jEditorPane1.setEditable(false);
        this.jEditorPane1.setName("jEditorPane1");
        this.jScrollPane1.setViewportView(this.jEditorPane1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton1, GroupLayout.Alignment.LEADING).addComponent(this.headerPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 336, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, 336, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.headerPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 192, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton1).addContainerGap()));
        this.pack();
    }

    @Action
    public void closeWindow() {
        this.setVisible(false);
    }
}

