/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.gefext;

import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.ui.gantt2.gefext.BackgroundManager;
import org.xmind.ui.gantt2.viewer.Colors;
import org.xmind.ui.gantt2.viewer.TaskTreeViewer;

public class BackgroundFigureManager
extends BackgroundManager {
    private IFigure backgroundFigure;
    private FigureListener listener;

    public void update() {
        if (this.backgroundFigure == null) {
            this.createFigure();
        }
        IFigure titleLayer = this.host.getTitleLayer();
        Rectangle r = new Rectangle(titleLayer.getBounds());
        this.backgroundFigure.setVisible(this.host.getFigure().isShowing() && this.host.isHostFigureVisible() && this.host.isChevronVisible());
        this.backgroundFigure.setBounds(new Rectangle(0, r.y + 1, this.host.getWidthsSupport().sum() + 1, r.height - 3));
    }

    private void createFigure() {
        this.backgroundFigure = new RectangleFigure();
        this.backgroundFigure.setForegroundColor(Colors.taskTreeParentTopic());
        this.backgroundFigure.setBackgroundColor(Colors.taskTreeParentTopic());
        this.getTargetLayer().add(this.backgroundFigure);
        this.addFigureListener();
    }

    private void addFigureListener() {
        this.listener = new FigureListener(){

            public void figureMoved(IFigure source) {
                Rectangle r = new Rectangle(BackgroundFigureManager.this.host.getTitleLayer().getBounds());
                if (BackgroundFigureManager.this.backgroundFigure != null && BackgroundFigureManager.this.backgroundFigure.isVisible()) {
                    BackgroundFigureManager.this.backgroundFigure.setBounds(new Rectangle(0, r.y + 1, BackgroundFigureManager.this.host.getWidthsSupport().sum() + 1, r.height - 3));
                    BackgroundFigureManager.this.backgroundFigure.revalidate();
                }
            }
        };
        this.host.getTitleLayer().addFigureListener(this.listener);
    }

    public void dispose() {
        if (this.backgroundFigure != null) {
            this.getTargetLayer().remove(this.backgroundFigure);
            this.host.getTitle().removeFigureListener(this.listener);
            this.backgroundFigure = null;
        }
        super.dispose();
    }

    protected Layer doGetTargetLayer() {
        return this.getRootPart(this.host).getLayer(TaskTreeViewer.LAYER_BACKGROUND_ITEM);
    }
}

