/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.gefext;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathDescriptor {
    private List<Segment> segments;
    private int numPoints = 0;
    private static final double CORNER_CONTROL_RATIO = (double)0.447715f;

    public PathDescriptor() {
        this.segments = new ArrayList<Segment>();
    }

    public PathDescriptor(int initialCapacity) {
        this.segments = new ArrayList<Segment>(initialCapacity);
    }

    public Path applyTo(Path path) {
        for (Segment segment : this.segments) {
            segment.applyTo(path);
        }
        return path;
    }

    public PathData make() {
        byte[] types = new byte[this.segments.size()];
        float[] points = new float[this.numPoints];
        int i = 0;
        int j = 0;
        while (i < this.segments.size()) {
            Segment segment = this.segments.get(i);
            types[i] = (byte)segment.type;
            PrecisionPoint[] precisionPointArray = segment.points;
            int n = segment.points.length;
            int n2 = 0;
            while (n2 < n) {
                PrecisionPoint p = precisionPointArray[n2];
                points[j++] = (float)p.x;
                points[j++] = (float)p.y;
                ++n2;
            }
            ++i;
        }
        PathData data = new PathData();
        data.types = types;
        data.points = points;
        return data;
    }

    private void addSegment(Segment segment) {
        this.segments.add(segment);
        this.numPoints += segment.points.length;
    }

    public PathDescriptor moveTo(double x, double y) {
        this.addSegment(new MoveSegment(x, y));
        return this;
    }

    public PathDescriptor moveTo(PrecisionPoint point) {
        this.moveTo(point.x, point.y);
        return this;
    }

    public PathDescriptor moveTo(Point point) {
        this.moveTo(point.x, point.y);
        return this;
    }

    public PathDescriptor lineTo(double x, double y) {
        this.addSegment(new LineSegment(x, y));
        return this;
    }

    public PathDescriptor lineTo(PrecisionPoint point) {
        this.lineTo(point.x, point.y);
        return this;
    }

    public PathDescriptor lineTo(Point point) {
        this.lineTo(point.x, point.y);
        return this;
    }

    public PathDescriptor cubicTo(double cx1, double cy1, double cx2, double cy2, double x, double y) {
        this.addSegment(new CubicSegment(cx1, cy1, cx2, cy2, x, y));
        return this;
    }

    public PathDescriptor cubicTo(PrecisionPoint c1, PrecisionPoint c2, PrecisionPoint p) {
        this.cubicTo(c1.x, c1.y, c2.x, c2.y, p.x, p.y);
        return this;
    }

    public PathDescriptor cubicTo(Point c1, Point c2, Point p) {
        this.cubicTo(c1.x, c1.y, c2.x, c2.y, p.x, p.y);
        return this;
    }

    public PathDescriptor quadTo(double cx, double cy, double x, double y) {
        this.addSegment(new QuadSegment(cx, cy, x, y));
        return this;
    }

    public PathDescriptor quadTo(PrecisionPoint c, PrecisionPoint p) {
        this.quadTo(c.x, c.y, p.x, p.y);
        return this;
    }

    public PathDescriptor quadTo(Point c, Point p) {
        this.quadTo(c.x, c.y, p.x, p.y);
        return this;
    }

    public PathDescriptor close() {
        this.addSegment(new CloseSegment());
        return this;
    }

    public PathDescriptor add(Path path) {
        this.add(path.getPathData());
        return this;
    }

    public PathDescriptor add(PathData data) {
        byte[] types = data.types;
        float[] points = data.points;
        int i = 0;
        int j = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 1: {
                    this.moveTo(points[j++], points[j++]);
                    break;
                }
                case 2: {
                    this.lineTo(points[j++], points[j++]);
                    break;
                }
                case 4: {
                    this.cubicTo(points[j++], points[j++], points[j++], points[j++], points[j++], points[j++]);
                    break;
                }
                case 3: {
                    this.quadTo(points[j++], points[j++], points[j++], points[j++]);
                    break;
                }
                case 5: {
                    this.close();
                }
            }
            ++i;
        }
        return this;
    }

    public PathDescriptor add(PathDescriptor another) {
        this.segments.addAll(another.segments);
        this.numPoints += another.numPoints;
        return this;
    }

    public boolean isEmpty() {
        return this.segments.isEmpty();
    }

    public int size() {
        return this.segments.size();
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public Iterator<PrecisionPoint> points() {
        return new Iterator<PrecisionPoint>(){
            Iterator<Segment> si;
            Segment nextSegment;
            int nextPointIndex;
            PrecisionPoint nextPoint;
            {
                this.si = PathDescriptor.this.segments.iterator();
                this.nextSegment = this.si.hasNext() ? this.si.next() : null;
                this.nextPointIndex = -1;
                this.nextPoint = this.findNext();
            }

            /*
             * Unable to fully structure code
             */
            private PrecisionPoint findNext() {
                if (this.nextSegment != null || this.si.hasNext()) ** GOTO lbl8
                return null;
lbl-1000:
                // 1 sources

                {
                    if (this.nextPointIndex < this.nextSegment.points.length - 1) {
                        ++this.nextPointIndex;
                        return this.nextSegment.points[this.nextPointIndex];
                    }
                    this.nextSegment = this.si.hasNext() != false ? this.si.next() : null;
                    this.nextPointIndex = -1;
lbl8:
                    // 2 sources

                    ** while (this.nextSegment != null)
                }
lbl9:
                // 1 sources

                return null;
            }

            @Override
            public void remove() {
            }

            @Override
            public PrecisionPoint next() {
                PrecisionPoint point = this.nextPoint;
                this.nextPoint = this.findNext();
                return point == null ? null : new PrecisionPoint(point);
            }

            @Override
            public boolean hasNext() {
                return this.nextPoint != null;
            }
        };
    }

    public Iterator<PrecisionPoint> reversePoints() {
        return new Iterator<PrecisionPoint>(){
            int nextSegmentIndex;
            int nextPointIndex;
            PrecisionPoint nextPoint;
            {
                this.nextSegmentIndex = PathDescriptor.this.segments.size() > 0 ? PathDescriptor.this.segments.size() - 1 : -1;
                this.nextPointIndex = -1;
                this.nextPoint = this.findNext();
            }

            @Override
            public void remove() {
            }

            @Override
            public PrecisionPoint next() {
                PrecisionPoint point = this.nextPoint;
                this.nextPoint = this.findNext();
                return point == null ? null : new PrecisionPoint(point);
            }

            @Override
            public boolean hasNext() {
                return this.nextPoint != null;
            }

            private PrecisionPoint findNext() {
                if (this.nextSegmentIndex < 0) {
                    return null;
                }
                if (this.nextSegmentIndex >= PathDescriptor.this.segments.size()) {
                    this.nextSegmentIndex = PathDescriptor.this.segments.size() - 1;
                }
                while (this.nextSegmentIndex >= 0) {
                    Segment segment = (Segment)PathDescriptor.this.segments.get(this.nextSegmentIndex);
                    if (segment.points.length > 0 && this.nextPointIndex < segment.points.length) {
                        if (this.nextPointIndex < 0) {
                            this.nextPointIndex = segment.points.length;
                        }
                        --this.nextPointIndex;
                        if (this.nextPointIndex >= 0) {
                            return segment.points[this.nextPointIndex];
                        }
                    }
                    --this.nextSegmentIndex;
                    this.nextPointIndex = -1;
                }
                return null;
            }
        };
    }

    public List<PrecisionPoint> getPointList() {
        ArrayList<PrecisionPoint> list = new ArrayList<PrecisionPoint>(this.numPoints);
        Iterator<PrecisionPoint> points = this.points();
        while (points.hasNext()) {
            list.add(new PrecisionPoint(points.next()));
        }
        return list;
    }

    public PrecisionPoint getFirstPoint() {
        for (Segment segment : this.segments) {
            if (segment.points.length <= 0) continue;
            return new PrecisionPoint(segment.points[0]);
        }
        return null;
    }

    public PrecisionPoint getLastPoint() {
        int i = this.segments.size() - 1;
        while (i >= 0) {
            Segment segment = this.segments.get(i);
            if (segment.points.length > 0) {
                return new PrecisionPoint(segment.points[segment.points.length - 1]);
            }
            --i;
        }
        return null;
    }

    public boolean containsPoint(double x, double y, double tolerance, boolean fill) {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof PathDescriptor)) {
            return false;
        }
        PathDescriptor that = (PathDescriptor)obj;
        return this.numPoints == that.numPoints && this.segments.equals(that.segments);
    }

    public String toString() {
        return this.segments.toString();
    }

    public int hashCode() {
        return this.segments.hashCode();
    }

    public PathDescriptor addRectangle(Rectangle r) {
        return this.doAddRectangle(r.x, r.y, r.x + r.width, r.y + r.height);
    }

    public PathDescriptor addRectangle(PrecisionRectangle r) {
        return this.doAddRectangle(r.x, r.y, r.x + r.width, r.y + r.height);
    }

    public PathDescriptor addRectangle(double x, double y, double width, double height) {
        return this.doAddRectangle(x, y, x + width, y + height);
    }

    private PathDescriptor doAddRectangle(double x1, double y1, double x2, double y2) {
        return this.moveTo(x1, y1).lineTo(x1, y1).lineTo(x2, y1).lineTo(x2, y2).lineTo(x1, y2).lineTo(x1, y1).close();
    }

    public PathDescriptor addRoundedRectangle(Rectangle r, double corner) {
        return this.doAddRoundedRectangle(r.x, r.y, r.x + r.width, r.y + r.height, corner);
    }

    public PathDescriptor addRoundedRectangle(PrecisionRectangle r, double corner) {
        return this.doAddRoundedRectangle(r.x, r.y, r.x + r.width, r.y + r.height, corner);
    }

    public PathDescriptor addRoundedRectangle(double x, double y, double width, double height, double corner) {
        return this.doAddRoundedRectangle(x, y, x + width, y + height, corner);
    }

    private PathDescriptor doAddRoundedRectangle(double x1, double y1, double x2, double y2, double corner) {
        double x0 = (x1 + x2) / 2.0;
        double y0 = (y1 + y2) / 2.0;
        double y11 = Math.min(y1 + corner, y0);
        this.moveTo(x1, y11);
        double x11 = Math.min(x1 + corner, x0);
        double cx1 = x1 + (x11 - x1) * (double)0.447715f;
        double cy1 = y1 + (y11 - y1) * (double)0.447715f;
        this.cubicTo(x1, cy1, cx1, y1, x11, y1);
        double x22 = Math.max(x2 - corner, x0);
        this.lineTo(x22, y1);
        double cx2 = x2 - (x2 - x22) * (double)0.447715f;
        this.cubicTo(cx2, y1, x2, cy1, x2, y11);
        double y22 = Math.max(y2 - corner, y0);
        this.lineTo(x2, y22);
        double cy2 = y2 - (y2 - y22) * (double)0.447715f;
        this.cubicTo(x2, cy2, cx2, y2, x22, y2);
        this.lineTo(x11, y2);
        this.cubicTo(cx1, y2, x1, cy2, x1, y22);
        this.lineTo(x1, y11);
        this.close();
        return this;
    }

    public PathDescriptor addEllipse(Rectangle r) {
        return this.doAddEllipse(r.x, r.y, r.x + r.width, r.y + r.height);
    }

    public PathDescriptor addEllipse(PrecisionRectangle r) {
        return this.doAddEllipse(r.x, r.y, r.x + r.width, r.y + r.height);
    }

    public PathDescriptor addEllipse(double x, double y, double width, double height) {
        return this.doAddEllipse(x, y, x + width, y + height);
    }

    private PathDescriptor doAddEllipse(double x1, double y1, double x2, double y2) {
        double cx = (x1 + x2) / 2.0;
        double cy = (y1 + y2) / 2.0;
        double dx = (x2 - x1) / 2.0 * (double)0.447715f;
        double dy = (y2 - y1) / 2.0 * (double)0.447715f;
        this.moveTo(x1, cy);
        this.cubicTo(x1, y1 + dy, x1 + dx, y1, cx, y1);
        this.cubicTo(x2 - dx, y1, x2, y1 + dy, x2, cy);
        this.cubicTo(x2, y2 - dy, x2 - dx, y2, cx, y2);
        this.cubicTo(x1 + dx, y2, x1, y2 - dy, x1, cy);
        this.close();
        return this;
    }

    public static void main(String[] args) {
        final Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        final PathDescriptor p = new PathDescriptor();
        p.addEllipse(100.0, 100.0, 300.0, 200.0);
        final PathDescriptor p2 = new PathDescriptor();
        p2.addEllipse(100.0, 100.0, 299.0, 199.0);
        Canvas canvas = new Canvas((Composite)shell, 0);
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(display.getSystemColor(5));
                e.gc.setBackground(display.getSystemColor(3));
                e.gc.setLineWidth(1);
                Path path = new Path((Device)display);
                p.applyTo(path);
                e.gc.fillPath(path);
                path.dispose();
                path = new Path((Device)display);
                p2.applyTo(path);
                e.gc.setAlpha(136);
                e.gc.drawPath(path);
                path.dispose();
            }
        });
        shell.setSize(500, 500);
        shell.setLocation(300, 100);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        shell.dispose();
        display.dispose();
    }

    private static class CloseSegment
    extends Segment {
        public CloseSegment() {
            super('X', 5, new PrecisionPoint[0]);
        }

        public void applyTo(Path path) {
            path.close();
        }
    }

    private static class CubicSegment
    extends Segment {
        public CubicSegment(double cx1, double cy1, double cx2, double cy2, double x, double y) {
            super('C', 4, new PrecisionPoint(cx1, cy1), new PrecisionPoint(cx2, cy2), new PrecisionPoint(x, y));
        }

        public void applyTo(Path path) {
            PrecisionPoint c1 = this.points[0];
            PrecisionPoint c2 = this.points[1];
            PrecisionPoint p = this.points[2];
            path.cubicTo((float)c1.x, (float)c1.y, (float)c2.x, (float)c2.y, (float)p.x, (float)p.y);
        }
    }

    private static class LineSegment
    extends Segment {
        public LineSegment(double x, double y) {
            super('L', 2, new PrecisionPoint(x, y));
        }

        public void applyTo(Path path) {
            PrecisionPoint p = this.points[0];
            path.lineTo((float)p.x, (float)p.y);
        }
    }

    private static class MoveSegment
    extends Segment {
        public MoveSegment(double x, double y) {
            super('M', 1, new PrecisionPoint(x, y));
        }

        public void applyTo(Path path) {
            PrecisionPoint p = this.points[0];
            path.moveTo((float)p.x, (float)p.y);
        }
    }

    private static class QuadSegment
    extends Segment {
        public QuadSegment(double cx, double cy, double x, double y) {
            super('Q', 3, new PrecisionPoint(cx, cy), new PrecisionPoint(x, y));
        }

        public void applyTo(Path path) {
            PrecisionPoint c = this.points[0];
            PrecisionPoint p = this.points[1];
            path.quadTo((float)c.x, (float)c.y, (float)p.x, (float)p.y);
        }
    }

    private static abstract class Segment {
        final char id;
        final int type;
        final PrecisionPoint[] points;

        public Segment(char id, int type, PrecisionPoint ... points) {
            this.id = id;
            this.type = type;
            this.points = points;
        }

        public abstract void applyTo(Path var1);

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof Segment)) {
                return false;
            }
            Segment that = (Segment)obj;
            if (this.type != that.type || this.points.length != that.points.length) {
                return false;
            }
            int length = this.points.length;
            int i = 0;
            while (i < length) {
                if (!this.points[i].equals((Object)that.points[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.id);
            int i = 0;
            while (i < this.points.length) {
                PrecisionPoint p = this.points[i];
                sb.append('(');
                sb.append(p.x);
                sb.append(',');
                sb.append(p.y);
                sb.append(')');
                ++i;
            }
            return sb.length() == 0 ? super.toString() : sb.toString();
        }
    }
}

