/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class JobRunner
implements ISchedulingRule {
    public static final int HIDDEN = 0;
    public static final int MINIMIZED = 1;
    public static final int PROMPT = 2;
    private int style;
    private boolean on;
    private Object onLock;
    private boolean debugging;

    public JobRunner(int style) {
        this.style = style;
        this.on = false;
        this.onLock = new Object();
        this.debugging = false;
    }

    public Object getFamily() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void on(boolean on) {
        Object object = this.onLock;
        synchronized (object) {
            this.on = on;
            this.onLock.notifyAll();
        }
    }

    public Job run(String taskName, boolean strict, IRunnableWithProgress runnable) {
        Job job = this.make(taskName, strict, runnable);
        job.schedule();
        return job;
    }

    public Job make(final String taskName, final boolean strict, final IRunnableWithProgress runnable) {
        final JobRunner theFamily = this;
        JobRunner theRule = this;
        Job job = new Job(taskName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Object object = JobRunner.this.onLock;
                    synchronized (object) {
                        while (!JobRunner.this.on && !monitor.isCanceled()) {
                            JobRunner.this.onLock.wait(10000L);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {}
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (JobRunner.this.debugging) {
                    System.out.println(">>>> Job Start: " + taskName);
                }
                if (JobRunner.this.debugging) {
                    monitor = new ProgressMonitorWrapper((IProgressMonitor)monitor){
                        private String mainTaskName;
                        private String subTaskName;
                        {
                            this.mainTaskName = null;
                            this.subTaskName = null;
                        }

                        public void beginTask(String name, int totalWork) {
                            super.beginTask(name, totalWork);
                            this.mainTaskName = name;
                            System.out.println(">>>> Begin Main Task: " + name);
                        }

                        public void subTask(String name) {
                            super.subTask(name);
                            if (this.subTaskName != null) {
                                System.out.println(">>>> End Sub Task: " + this.subTaskName);
                            }
                            this.subTaskName = name;
                            System.out.println(">>>> Begin Sub Task: " + name);
                        }

                        public void done() {
                            super.done();
                            if (this.subTaskName != null) {
                                System.out.println(">>>> End Sub Task: " + this.subTaskName);
                            }
                            System.out.println(">>>> End Main Task: " + this.mainTaskName);
                        }
                    };
                }
                try {
                    runnable.run(monitor);
                }
                catch (InvocationTargetException e) {
                    return new Status(strict ? 4 : 2, "org.xmind.ui.seawind", e.getMessage(), (Throwable)e);
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                if (JobRunner.this.debugging) {
                    System.out.println(">>>> Job Finished: " + taskName);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return theFamily.equals(family);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void canceling() {
                super.canceling();
                Object object = JobRunner.this.onLock;
                synchronized (object) {
                    JobRunner.this.onLock.notifyAll();
                }
            }
        };
        job.setPriority(30);
        job.setRule((ISchedulingRule)theRule);
        job.setSystem(this.style == 0);
        job.setUser(this.style == 2);
        return job;
    }

    public boolean contains(ISchedulingRule rule) {
        return rule == this;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return rule == this;
    }

    public void debug() {
        this.debugging = true;
    }
}

