/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMemento;
import org.json.JSONObject;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookExtensionManager;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.io.PrefixedStorage;
import org.xmind.core.net.Entity;
import org.xmind.core.net.http.JSONEntity;
import org.xmind.core.net.internal.EncodingUtils;
import org.xmind.core.plain.Sheet;
import org.xmind.core.plain.Workbook;
import org.xmind.core.util.CloneHandler;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.ui.editor.IInteractiveMessage;
import org.xmind.gef.ui.editor.InteractiveMessage;
import org.xmind.seawind.internal.core.ExtensionsDeserializer;
import org.xmind.seawind.internal.core.ExtensionsSerializer;
import org.xmind.seawind.internal.core.JSON;
import org.xmind.seawind.internal.core.SElement;
import org.xmind.seawind.internal.core.SeawindClient;
import org.xmind.seawind.internal.core.SeawindSheet;
import org.xmind.seawind.internal.core.SeawindWorkbook;
import org.xmind.seawind.internal.core.SheetDeserializer;
import org.xmind.seawind.internal.core.SheetSerializer;
import org.xmind.ui.internal.editor.AbstractWorkbookRef;
import org.xmind.ui.internal.editor.IMindMapPreviewGenerator;
import org.xmind.ui.internal.editor.MindMapPreviewOptions;
import org.xmind.ui.internal.editor.WorkbookRefEncryptable;
import org.xmind.ui.internal.seawind.ISeawindLibraryListener;
import org.xmind.ui.internal.seawind.SeawindLibrary;
import org.xmind.ui.internal.seawind.SeawindLibraryEvent;
import org.xmind.ui.internal.seawind.SeawindMessages;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;
import org.xmind.ui.mindmap.IWorkbookRef;

public class SeawindWorkbookRef
extends AbstractWorkbookRef {
    public static String LABEL_SYNCING = SeawindMessages.SeawindWorkbookRef_SyncStatus_Syncing;
    public static int SYNC_STATUS_UPLOADING = 1;
    public static int SYNC_STATUS_DOWNLOADING = 2;
    public static int SYNC_STATUS_SYNCING = 4;
    public static int SYNC_STATUS_SYNCED = 0;
    private final SeawindLibrary manager;
    private final SeawindWorkbook swWorkbook;
    private boolean pending;
    private IStorage resourceStorage;
    private ICoreEventRegister workbookEventHandler;
    private PropertyChangeListener seawindEventHandler;
    private String syncStatus;
    private int syncStatusType;
    private InteractiveMessage syncError;
    private Map<String, String> contentHashs = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeawindWorkbookRef(final SeawindLibrary manager, URI uri, SeawindWorkbook swWorkbook, int syncStatusType, boolean pending) {
        super(uri, null);
        Assert.isLegal((manager != null ? 1 : 0) != 0);
        Assert.isLegal((uri != null ? 1 : 0) != 0);
        Assert.isLegal((swWorkbook != null ? 1 : 0) != 0);
        this.swWorkbook = swWorkbook;
        this.manager = manager;
        this.pending = pending;
        this.syncError = null;
        this.syncStatus = null;
        this.resourceStorage = manager.getSharedResourceStorage();
        manager.addLibraryListener(new ISeawindLibraryListener(){

            @Override
            public void handleSeawindLibraryEvent(SeawindLibraryEvent event) {
                if (event.getType() == 0x100000 && SeawindWorkbookRef.this.isSyncing()) {
                    String globalSyncError = manager.getGlobalSyncError();
                    SeawindWorkbookRef.this.setSyncError(globalSyncError);
                }
            }
        });
        this.workbookEventHandler = new CoreEventRegister(new ICoreEventListener(){

            public void handleCoreEvent(CoreEvent event) {
                SeawindWorkbookRef.this.handleWorkbookEvent(event);
            }
        });
        this.seawindEventHandler = new PropertyChangeListener(){

            @Override
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                SeawindWorkbookRef.this.handleSeawindEvent(evt);
            }
        };
        this.setTempStorage((IStorage)new PrefixedStorage(manager.getRootStorage(), "working/" + EncodingUtils.format((String)"workbooks/%s/", (Object[])new Object[]{swWorkbook.getId()})));
        Object object = manager.getWorkingSetLock();
        synchronized (object) {
            swWorkbook.setStorage(SeawindLibrary.newStorageForWorkbook(swWorkbook.getParent().getStorage(), swWorkbook.getId()));
            swWorkbook.getPropertySupport().addPropertyChangeListener(this.seawindEventHandler);
            for (SeawindSheet swSheet : swWorkbook.getSheets()) {
                swSheet.setStorage(SeawindLibrary.newStorageForSheet(swWorkbook.getStorage(), swSheet.getId()));
                swSheet.getPropertySupport().addPropertyChangeListener(this.seawindEventHandler);
                this.updateModificationTime((SElement<?>)swSheet);
            }
            String statusLabel = syncStatusType == SYNC_STATUS_SYNCED ? null : LABEL_SYNCING;
            this.setSyncStatus(0, syncStatusType, statusLabel);
            this.updateModificationTime((SElement<?>)swWorkbook);
        }
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("exists".equals(event.getProperty()) && event.getSource() == SeawindWorkbookRef.this && event.getOldValue() == Boolean.TRUE && event.getNewValue() == Boolean.FALSE) {
                    boolean forceQuit = false;
                    if (1 == SeawindWorkbookRef.this.manager.getStatus()) {
                        forceQuit = true;
                    }
                    SeawindWorkbookRef.this.fileRemoved(SeawindMessages.FileDeletionNotificationDialog_title, SeawindMessages.FileDeletionNotificationDialog_message, new String[]{SeawindMessages.FileDeletionNotificationDialog_SaveAsButton_text, SeawindMessages.FileDeletionNotificationDialog_DeleteButton_text}, forceQuit);
                }
            }
        });
    }

    protected WorkbookRefEncryptable createEncryptable() {
        return null;
    }

    public SeawindLibrary getManager() {
        return this.manager;
    }

    public String getSaveWizardId() {
        return "org.xmind.ui.saveWizards.seawind";
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (SeawindWorkbook.class.equals(adapter)) {
            return adapter.cast(this.swWorkbook);
        }
        return (T)super.getAdapter(adapter);
    }

    public SeawindWorkbook getSeawindWorkbook() {
        return this.swWorkbook;
    }

    public void setPending(boolean pending) {
        boolean oldExists = this.exists();
        this.pending = pending;
        boolean newExists = this.exists();
        if (newExists == oldExists) {
            return;
        }
        this.firePropertyChanged("exists", oldExists, newExists);
    }

    public boolean isPending() {
        return this.pending;
    }

    public boolean isSyncing() {
        return this.syncStatus != null;
    }

    public String getName() {
        return this.swWorkbook.getTitle();
    }

    public String getDescription() {
        String name = this.getName();
        if (name == null) {
            name = SeawindMessages.SeawindWorkbookRef_UntitledWorkbookName;
        }
        return NLS.bind((String)SeawindMessages.SeawindWorkbookRef_WorkbookDescription_withName, (Object)name);
    }

    public int hashCode() {
        return this.getURI().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SeawindWorkbookRef)) {
            return false;
        }
        SeawindWorkbookRef that = (SeawindWorkbookRef)((Object)obj);
        return this.getURI() == that.getURI() || this.getURI() != null && this.getURI().equals(that.getURI());
    }

    public String toString() {
        return "SeawindWorkbookRef(" + this.getURI() + ")";
    }

    protected void setModificationTime(long modificationTime) {
        super.setModificationTime(modificationTime);
        if (this.getWorkbook() != null) {
            ((Workbook)this.getWorkbook()).setModificationInfo(modificationTime, this.getManager().getUserName());
        }
    }

    public boolean canSave() {
        return true;
    }

    public boolean canImportFrom(IWorkbookRef source) {
        return true;
    }

    public boolean exists() {
        return !this.isPending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getPreviewImageData(String sheetId, MindMapPreviewOptions options) throws IOException {
        if (sheetId == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.manager.getWorkingSetLock();
        synchronized (object) {
            SeawindSheet swSheet = this.swWorkbook.findSheet(sheetId);
            if (swSheet != null) {
                IInputSource source;
                String contentHash = swSheet.getRevAsContentHash();
                String rev = swSheet.getRev();
                String previewPath = contentHash != null ? EncodingUtils.format((String)"hashs/%s/preview.png", (Object[])new Object[]{contentHash}) : (rev != null ? EncodingUtils.format((String)"revs/%s/preview.png", (Object[])new Object[]{rev}) : null);
                if (previewPath != null && (source = swSheet.getStorage().getInputSource()).hasEntry(previewPath)) {
                    return source.openEntryStream(previewPath);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getThumbnailImageEntryName(String sheetId, MindMapPreviewOptions options) {
        if (sheetId == null) {
            return null;
        }
        Object object = this.manager.getWorkingSetLock();
        synchronized (object) {
            SeawindSheet swSheet = this.swWorkbook.findSheet(sheetId);
            if (swSheet != null) {
                String contentHash = swSheet.getRevAsContentHash();
                String rev = swSheet.getRev();
                String thumbnail = contentHash != null ? EncodingUtils.format((String)"hashs/%s/thumbnail.png", (Object[])new Object[]{contentHash}) : (rev != null ? EncodingUtils.format((String)"revs/%s/thumbnail.png", (Object[])new Object[]{rev}) : null);
                return thumbnail;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getThumbnailImageData(String sheetId, MindMapPreviewOptions options) throws IOException {
        if (sheetId == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.manager.getWorkingSetLock();
        synchronized (object) {
            SeawindSheet swSheet = this.swWorkbook.findSheet(sheetId);
            if (swSheet != null) {
                IInputSource source;
                String contentHash = swSheet.getRevAsContentHash();
                String rev = swSheet.getRev();
                String thumbnail = contentHash != null ? EncodingUtils.format((String)"hashs/%s/thumbnail.png", (Object[])new Object[]{contentHash}) : (rev != null ? EncodingUtils.format((String)"revs/%s/thumbnail.png", (Object[])new Object[]{rev}) : null);
                if (thumbnail != null && (source = swSheet.getStorage().getInputSource()).hasEntry(thumbnail)) {
                    return source.openEntryStream(thumbnail);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IWorkbook doLoadWorkbookFromURI(IProgressMonitor monitor, URI uri) throws InterruptedException, InvocationTargetException {
        try {
            Object object = this.manager.getWorkingSetLock();
            synchronized (object) {
                List swSheets = this.swWorkbook.getSheets();
                Workbook workbook = new Workbook(this.getTempStorage(), "3.0", !swSheets.isEmpty(), "resources/");
                SheetDeserializer deserializer = new SheetDeserializer(workbook);
                for (SeawindSheet swSheet : swSheets) {
                    Sheet sheet = new Sheet(workbook, swSheet.getId(), true);
                    sheet.setTitleText(swSheet.getTitle());
                    String contentHash = swSheet.getRevAsContentHash();
                    String contentPath = contentHash != null ? EncodingUtils.format((String)"hashs/%s/content.json", (Object[])new Object[]{contentHash}) : EncodingUtils.format((String)"revs/%s/content.json", (Object[])new Object[]{swSheet.getRev()});
                    JSONObject sheetObject = JSON.readObjectWithDamageCheck((IStorage)swSheet.getStorage(), (String)contentPath);
                    deserializer.deserialize(sheet, sheetObject);
                    workbook.addSheet((ISheet)sheet);
                }
                IWorkbookExtensionManager wbExtManager = (IWorkbookExtensionManager)workbook.getAdapter(IWorkbookExtensionManager.class);
                String extensionsHash = this.swWorkbook.getExtensionsRevAsContentHash();
                String extensionsPath = null;
                if (extensionsHash != null) {
                    extensionsPath = EncodingUtils.format((String)"hashs/%s/extensions.json", (Object[])new Object[]{extensionsHash});
                } else if (this.swWorkbook.getExtensionsRev() != null) {
                    extensionsPath = EncodingUtils.format((String)"revs/%s/extensions.json", (Object[])new Object[]{this.swWorkbook.getExtensionsRev()});
                }
                IInputSource extensionsSource = this.swWorkbook.getStorage().getInputSource();
                if (extensionsPath != null && extensionsSource.hasEntry(extensionsPath)) {
                    JSONObject extensionsObject = JSON.readObjectWithDamageCheck((IStorage)this.swWorkbook.getStorage(), (String)extensionsPath);
                    ExtensionsDeserializer extensionsDeserializer = new ExtensionsDeserializer();
                    extensionsDeserializer.deserialize(wbExtManager, extensionsObject);
                }
                deserializer.loadResources(this.resourceStorage);
                workbook.setModificationInfo(this.getModificationTime(), this.getManager().getUserName());
                ICoreEventSupport eventSupport = (ICoreEventSupport)workbook.getAdapter(ICoreEventSupport.class);
                Assert.isNotNull((Object)eventSupport);
                this.workbookEventHandler.setNextSupport(eventSupport);
                this.workbookEventHandler.register("sheetAdd");
                this.workbookEventHandler.register("titleText");
                return workbook;
            }
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected void doUnloadWorkbook(IProgressMonitor monitor, IWorkbook workbook) throws InterruptedException, InvocationTargetException {
        this.workbookEventHandler.unregisterAll();
        super.doUnloadWorkbook(monitor, workbook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImportFrom(IProgressMonitor monitor, IWorkbookRef source) throws InterruptedException, InvocationTargetException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkbook sourceWorkbook = source.getWorkbook();
        Assert.isTrue((sourceWorkbook != null ? 1 : 0) != 0);
        URI targetURI = this.getURI();
        Assert.isTrue((targetURI != null ? 1 : 0) != 0);
        IStorage tempStorage = this.getTempStorage();
        tempStorage.clear();
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        try {
            List targetSheets;
            List sourceSheets;
            IWorkbook tempWorkbook = this.doCloneWorkbookFrom((IProgressMonitor)subMonitor.newChild(40), sourceWorkbook, tempStorage);
            Assert.isNotNull((Object)tempWorkbook);
            this.setWorkbook(tempWorkbook);
            try {
                this.doSaveWorkbook((IProgressMonitor)subMonitor.newChild(60), tempWorkbook);
                long modificationTime = source.getModificationTime();
                if (modificationTime > 0L) {
                    this.swWorkbook.setModificationTime(modificationTime);
                }
                this.manager.postSaveWorkbookRef(this);
            }
            finally {
                this.setWorkbook(null);
            }
            Object object = this.manager.getWorkingSetLock();
            synchronized (object) {
                sourceSheets = sourceWorkbook.getSheets();
                targetSheets = this.swWorkbook.getSheets();
            }
            Assert.isTrue((sourceSheets.size() == targetSheets.size() ? 1 : 0) != 0);
            int index = 0;
            while (index < sourceSheets.size()) {
                block38: {
                    String previewPath;
                    String rev;
                    String contentHash;
                    SeawindSheet targetSheet;
                    ISheet sourceSheet;
                    block37: {
                        sourceSheet = (ISheet)sourceSheets.get(index);
                        targetSheet = (SeawindSheet)targetSheets.get(index);
                        contentHash = targetSheet.getRevAsContentHash();
                        rev = targetSheet.getRev();
                        String thumbnailPath = null;
                        if (contentHash != null) {
                            thumbnailPath = EncodingUtils.format((String)"hashs/%s/thumbnail.png", (Object[])new Object[]{contentHash});
                        } else if (rev != null) {
                            thumbnailPath = EncodingUtils.format((String)"revs/%s/thumbnail.png", (Object[])new Object[]{rev});
                        }
                        if (thumbnailPath != null) {
                            try {
                                InputStream thumbnailData = null;
                                if (source instanceof SeawindWorkbookRef) {
                                    thumbnailData = ((SeawindWorkbookRef)source).getThumbnailImageData(sourceSheet.getId(), null);
                                }
                                if (thumbnailData != null) {
                                    try (OutputStream output = targetSheet.getStorage().getOutputTarget().openEntryStream(thumbnailPath);){
                                        FileUtils.transfer((InputStream)thumbnailData, (OutputStream)output, (boolean)false);
                                        break block37;
                                    }
                                    finally {
                                        thumbnailData.close();
                                    }
                                }
                                this.saveThumbnailImageToPath(sourceSheet, targetSheet.getStorage(), thumbnailPath);
                            }
                            catch (IOException e) {
                                SeawindUIPlugin.log(e, "Failed to copy thumbnial image");
                            }
                        }
                    }
                    if ((previewPath = contentHash != null ? EncodingUtils.format((String)"hashs/%s/preview.png", (Object[])new Object[]{contentHash}) : (rev != null ? EncodingUtils.format((String)"revs/%s/preview.png", (Object[])new Object[]{rev}) : null)) != null) {
                        try {
                            InputStream previewData = source.getPreviewImageData(sourceSheet.getId(), null);
                            if (previewData != null) {
                                try (OutputStream output = targetSheet.getStorage().getOutputTarget().openEntryStream(previewPath);){
                                    FileUtils.transfer((InputStream)previewData, (OutputStream)output, (boolean)false);
                                    break block38;
                                }
                                finally {
                                    previewData.close();
                                }
                            }
                            this.savePreviewImageToPath(sourceSheet, targetSheet.getStorage(), previewPath);
                        }
                        catch (IOException e) {
                            SeawindUIPlugin.log(e, "Failed to copy preview image");
                        }
                    }
                }
                ++index;
            }
        }
        finally {
            tempStorage.clear();
        }
    }

    protected void doSaveWorkbookToURI(IProgressMonitor monitor, IWorkbook workbook, URI uri) throws InterruptedException, InvocationTargetException {
        this.doSaveWorkbook(monitor, workbook);
        this.manager.postSaveWorkbookRef(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveWorkbook(IProgressMonitor monitor, IWorkbook workbook) throws InterruptedException, InvocationTargetException {
        try {
            ArrayList sheetsNeedingPreview = new ArrayList();
            this.contentHashs.clear();
            Object object = this.manager.getWorkingSetLock();
            synchronized (object) {
                ISheet sheet;
                ArrayList swSheetsToRemove = new ArrayList(this.swWorkbook.getSheets());
                ListIterator sheetIt = workbook.getSheets().listIterator();
                while (sheetIt.hasNext()) {
                    int index = sheetIt.nextIndex();
                    sheet = (ISheet)sheetIt.next();
                    SeawindSheet swSheet = this.swWorkbook.findSheet(sheet.getId());
                    if (swSheet == null) {
                        swSheet = new SeawindSheet(sheet.getId());
                        swSheet.setStorage(SeawindLibrary.newStorageForSheet(this.swWorkbook.getStorage(), swSheet.getId()));
                        this.swWorkbook.addSheet(swSheet);
                    } else {
                        swSheetsToRemove.remove(swSheet);
                    }
                    this.swWorkbook.moveSheet(swSheet, index);
                    swSheet.setTitle(sheet.getTitleText());
                    IStorage sheetStorage = swSheet.getStorage();
                    JSONObject sheetObject = new SheetSerializer(sheet, this.resourceStorage).serialize();
                    String tempContentPath = "content.json";
                    String tempContentHashPath = SeawindClient.toHashPath((String)tempContentPath);
                    SeawindClient.writeEntityTo((Entity)new JSONEntity(sheetObject), (IOutputTarget)sheetStorage.getOutputTarget(), (String)tempContentPath);
                    String contentHash = SeawindClient.getFileHash((IInputSource)sheetStorage.getInputSource(), (String)tempContentPath);
                    String contentPath = EncodingUtils.format((String)"hashs/%s/content.json", (Object[])new Object[]{contentHash});
                    String contentHashPath = SeawindClient.toHashPath((String)contentPath);
                    this.contentHashs.put(swSheet.getId(), contentHash);
                    String oldContentHash = swSheet.getRevAsContentHash();
                    if (oldContentHash == null) {
                        oldContentHash = SeawindClient.getFileHash((IInputSource)sheetStorage.getInputSource(), (String)EncodingUtils.format((String)"revs/%s/content.json", (Object[])new Object[]{swSheet.getRev()}));
                    }
                    if (contentHash.equals(oldContentHash)) continue;
                    sheetStorage.renameEntry(tempContentPath, contentPath);
                    sheetStorage.renameEntry(tempContentHashPath, contentHashPath);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("sheet", sheet);
                    map.put("swSheet", swSheet);
                    sheetsNeedingPreview.add(map);
                    swSheet.setRevAsContentHash(contentHash);
                }
                sheet = swSheetsToRemove.iterator();
                while (sheet.hasNext()) {
                    SeawindSheet swSheet = (SeawindSheet)sheet.next();
                    this.swWorkbook.removeSheet(swSheet);
                }
            }
            for (Map map : sheetsNeedingPreview) {
                SeawindSheet swSheet = (SeawindSheet)map.get("swSheet");
                ISheet sheet = (ISheet)map.get("sheet");
                String contentHash = swSheet.getRevAsContentHash();
                Assert.isNotNull((Object)contentHash);
                String previewPath = EncodingUtils.format((String)"hashs/%s/preview.png", (Object[])new Object[]{contentHash});
                this.savePreviewImageToPath(sheet, swSheet.getStorage(), previewPath);
            }
            IWorkbookExtensionManager iWorkbookExtensionManager = (IWorkbookExtensionManager)workbook.getAdapter(IWorkbookExtensionManager.class);
            if (iWorkbookExtensionManager != null && iWorkbookExtensionManager.getExtensions().size() > 0) {
                IStorage extensionsStorage = this.swWorkbook.getStorage();
                JSONObject extensionsObject = new ExtensionsSerializer(iWorkbookExtensionManager, this.resourceStorage).serialize();
                String tempExtensionsPath = "extensions.json";
                String tempExtensionsHashPath = SeawindClient.toHashPath((String)tempExtensionsPath);
                SeawindClient.writeEntityTo((Entity)new JSONEntity(extensionsObject), (IOutputTarget)extensionsStorage.getOutputTarget(), (String)tempExtensionsPath);
                String extensionsHash = SeawindClient.getFileHash((IInputSource)extensionsStorage.getInputSource(), (String)tempExtensionsHashPath);
                String extensionsPath = EncodingUtils.format((String)"hashs/%s/extensions.json", (Object[])new Object[]{extensionsHash});
                String extensionsHashPath = SeawindClient.toHashPath((String)extensionsPath);
                String oldExtensionsHash = this.swWorkbook.getExtensionsRevAsContentHash();
                if (oldExtensionsHash == null) {
                    oldExtensionsHash = SeawindClient.getFileHash((IInputSource)extensionsStorage.getInputSource(), (String)EncodingUtils.format((String)"revs/%s/extensions.json", (Object[])new Object[]{this.swWorkbook.getExtensionsRev()}));
                }
                if (!extensionsHash.equals(oldExtensionsHash)) {
                    extensionsStorage.renameEntry(tempExtensionsPath, extensionsPath);
                    extensionsStorage.renameEntry(tempExtensionsHashPath, extensionsHashPath);
                    this.swWorkbook.setExtensionsRevAsContentHash(extensionsHash);
                }
            }
            long now = System.currentTimeMillis();
            this.swWorkbook.setModificationTime(now);
            this.setModificationTime(now);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void savePreviewImageToPath(ISheet sheet, IStorage sheetStorage, String previewPath) throws IOException {
        IMindMapPreviewGenerator previewGenerator = this.findPreviewGenerator();
        if (previewGenerator != null) {
            try (OutputStream output = sheetStorage.getOutputTarget().openEntryStream(previewPath);){
                previewGenerator.generateMindMapPreview((IWorkbookRef)this, sheet, output, null);
            }
        }
    }

    private void saveThumbnailImageToPath(ISheet sheet, IStorage sheetStorage, String previewPath) throws IOException {
        IMindMapPreviewGenerator previewGenerator = this.findPreviewGenerator();
        if (previewGenerator != null) {
            try (OutputStream output = sheetStorage.getOutputTarget().openEntryStream(previewPath);){
                previewGenerator.generateMindMapPreview((IWorkbookRef)this, sheet, output, null);
            }
        }
    }

    private IWorkbook doCloneWorkbookFrom(IProgressMonitor monitor, IWorkbook sourceWorkbook, IStorage tempStorage) throws InterruptedException, InvocationTargetException {
        try {
            Workbook workbook = new Workbook(this.getTempStorage(), "3.0", true, "resources/");
            new CloneHandler().withWorkbooks(sourceWorkbook, (IWorkbook)workbook).copyWorkbookContents();
            return workbook;
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected void doSaveWorkbookToTempStorage(IProgressMonitor monitor, IWorkbook workbook) throws InterruptedException, InvocationTargetException {
    }

    protected void saveStateForTempStorage(IMemento state, IWorkbook workbook) {
    }

    private void handleSeawindEvent(java.beans.PropertyChangeEvent event) {
        Object source = event.getSource();
        String property = event.getPropertyName();
        if ("title".equals(property)) {
            if (source instanceof SeawindWorkbook) {
                this.firePropertyChanged("name", event.getOldValue(), event.getNewValue());
            }
        } else if ("sheets".equals(property)) {
            this.refreshSheets((SeawindWorkbook)event.getSource(), (List)event.getOldValue(), (List)event.getNewValue());
            this.fileChanged(SeawindMessages.FileModificationNotificationDialog_title, SeawindMessages.FileModificationNotificationDialog_message, new String[]{SeawindMessages.FileModificationNotificationDialog_UpdateButton_text, SeawindMessages.FileModificationNotificationDialog_CancelButton_text});
        } else if ("modificationTime".equals(property)) {
            this.updateModificationTime((SElement)event.getSource());
        } else if ("rev".equals(property)) {
            if (!this.isSyncing()) {
                try {
                    this.setSyncStatus(0, SYNC_STATUS_SYNCING, LABEL_SYNCING);
                }
                finally {
                    this.setSyncStatus(0, SYNC_STATUS_SYNCED, null);
                }
            }
            if (!(event.getSource() instanceof SeawindSheet)) {
                return;
            }
            String newRev = (String)event.getNewValue();
            SeawindSheet swSheet = (SeawindSheet)event.getSource();
            if (newRev != null && !newRev.startsWith("__HASH__")) {
                String contentHash = this.contentHashs.get(swSheet.getId());
                String contentHash2 = this.getContentHash(swSheet, newRev);
                if (this.contentHashs.size() == 0 || contentHash == null || !contentHash.equals(contentHash2)) {
                    this.fileChanged(SeawindMessages.FileModificationNotificationDialog_title, SeawindMessages.FileModificationNotificationDialog_message, new String[]{SeawindMessages.FileModificationNotificationDialog_UpdateButton_text, SeawindMessages.FileModificationNotificationDialog_CancelButton_text});
                }
            }
        }
    }

    private String getContentHash(SeawindSheet swSheet, String sheetRev) {
        IStorage sheetStorage = swSheet.getStorage();
        String contentHash = null;
        try {
            contentHash = SeawindClient.getFileHash((IInputSource)sheetStorage.getInputSource(), (String)EncodingUtils.format((String)"revs/%s/content.json", (Object[])new Object[]{sheetRev}));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contentHash;
    }

    private void updateModificationTime(SElement<?> element) {
        long newTime = element.getModificationTime();
        if (element instanceof SeawindWorkbook) {
            this.setModificationTime(newTime);
        }
    }

    private void refreshSheets(SeawindWorkbook swWorkbook, List<?> oldSheets, List<?> newSheets) {
        ArrayList sheetsToRemove = new ArrayList(oldSheets);
        for (Object swSheet : newSheets) {
            if (sheetsToRemove.remove(swSheet)) continue;
            ((SeawindSheet)swSheet).getPropertySupport().addPropertyChangeListener(this.seawindEventHandler);
        }
        for (Object swSheet : sheetsToRemove) {
            ((SeawindSheet)swSheet).getPropertySupport().removePropertyChangeListener(this.seawindEventHandler);
        }
    }

    private void handleWorkbookEvent(CoreEvent event) {
    }

    public void setSyncError(String message) {
        if (this.syncError != null) {
            this.removeMessage((IInteractiveMessage)this.syncError);
            this.syncError = null;
        }
        if (message != null) {
            this.syncError = new InteractiveMessage(2, message);
            this.addMessage((IInteractiveMessage)this.syncError);
        }
    }

    public IInteractiveMessage getSyncError() {
        return this.syncError;
    }

    public String getSyncStatus() {
        return this.syncStatus;
    }

    public int getSyncStatusType() {
        return this.syncStatusType;
    }

    public void setSyncStatus(int progress, int syncStatusType, String status) {
        this.syncStatusType = syncStatusType;
        this.setSyncStatus(progress, status);
    }

    public void setSyncStatus(int progress, String status) {
        String oldStatus = this.syncStatus;
        boolean statusChanged = status != oldStatus && (status == null || !status.equals(oldStatus));
        this.syncStatus = status;
        if (status != null) {
            this.addState(2);
        } else {
            this.removeState(2);
        }
        int oldProgress = this.getProgress();
        if (statusChanged && progress != oldProgress) {
            this.setProgress(oldProgress + 1);
        }
        this.setProgress(progress);
    }
}

