/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind.dashboard;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.xmind.gef.draw2d.SimpleRectangleFigure;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.ui.editor.IInteractiveMessage;
import org.xmind.seawind.internal.core.SeawindSheet;
import org.xmind.seawind.internal.core.SeawindWorkbook;
import org.xmind.ui.gallery.IDecorationContext;
import org.xmind.ui.gallery.ILabelDecorator;
import org.xmind.ui.internal.seawind.SeawindMessages;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;
import org.xmind.ui.internal.seawind.SeawindWorkbookRef;
import org.xmind.ui.internal.seawind.dashboard.DecoratedContainerLayout;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.viewers.IToolTipProvider;

public class CloudMapLabelProvider
extends LabelProvider
implements IColorProvider,
ILabelDecorator,
IToolTipProvider {
    protected static final String COLOR_NONEXISTING_WORKBOOK_COVER = "#DDDDDD";
    protected static final String COLOR_NONEXISTING_WORKBOOK_TEXT = "#CCCCCC";
    private Map<Object, ImageEntry> imageEntries = new HashMap<Object, ImageEntry>();
    private LocalResourceManager resources;

    public CloudMapLabelProvider(Control control) {
        this.resources = new LocalResourceManager(JFaceResources.getResources(), control);
    }

    public void clearCachesFor(Object element) {
        ImageEntry imageEntry = this.imageEntries.remove(element);
        if (imageEntry != null && imageEntry.getImage() != null) {
            imageEntry.getImage().dispose();
        }
    }

    public void clear() {
        Object[] imageEntryArray = this.imageEntries.values().toArray();
        this.imageEntries.clear();
        Object[] objectArray = imageEntryArray;
        int n = imageEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object imageEntry = objectArray[n2];
            ((ImageEntry)imageEntry).getImage().dispose();
            ++n2;
        }
    }

    public void dispose() {
        this.resources.dispose();
        this.clear();
        super.dispose();
    }

    public Image getImage(Object element) {
        if (element instanceof IWorkbookRef) {
            Image image;
            IWorkbookRef workbookRef = (IWorkbookRef)element;
            ImageEntry imageEntry = this.imageEntries.get(workbookRef);
            if (imageEntry != null && imageEntry.getImage() != null && !imageEntry.getImage().isDisposed()) {
                String oldKey = imageEntry.getKey();
                String newKey = this.getThumbnailImageEntryName(workbookRef);
                if (oldKey == null && newKey == null || oldKey != null && oldKey.equals(newKey)) {
                    return imageEntry.getImage();
                }
            }
            if ((image = this.createThumbnailImageFor(this.resources.getDevice(), workbookRef)) == null || image.isDisposed()) {
                return (Image)this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("black_map.png"));
            }
            String key = this.getThumbnailImageEntryName(workbookRef);
            this.imageEntries.put(workbookRef, new ImageEntry(key, image));
            return image;
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof IWorkbookRef) {
            String name = ((IWorkbookRef)element).getName();
            if (name == null) {
                return SeawindMessages.SeawindWorkbookRef_UntitledWorkbookName;
            }
            if (name.length() > 20) {
                name = String.valueOf(name.substring(0, 20)) + "...";
            }
            return name;
        }
        return super.getText(element);
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (!(element instanceof IWorkbookRef)) {
            return null;
        }
        IWorkbookRef workbookRef = (IWorkbookRef)element;
        if (!workbookRef.exists()) {
            return (Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)COLOR_NONEXISTING_WORKBOOK_TEXT));
        }
        return null;
    }

    public IFigure decorateFigure(IFigure figure, Object element, IDecorationContext context) {
        if (!(element instanceof SeawindWorkbookRef)) {
            return figure;
        }
        return this.decorateFrameFigure(figure, (SeawindWorkbookRef)((Object)element), context);
    }

    protected IFigure decorateFrameFigure(IFigure contentPane, SeawindWorkbookRef workbookRef, IDecorationContext context) {
        SimpleRectangleFigure coverFigure;
        SizeableImageFigure stateIconFigure;
        SizeableImageFigure thumbnailFigure;
        List figures = contentPane.getChildren();
        boolean needInitFigureContent = figures.isEmpty();
        if (needInitFigureContent) {
            contentPane.setLayoutManager((LayoutManager)new CloudMapFrameContentLayout(context));
            thumbnailFigure = new SizeableImageFigure(this.getImage((Object)workbookRef));
            stateIconFigure = new SizeableImageFigure(this.getStateImage(workbookRef));
            coverFigure = new SimpleRectangleFigure();
            coverFigure.setBackgroundColor((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)COLOR_NONEXISTING_WORKBOOK_COVER)));
            coverFigure.setSubAlpha(128);
            contentPane.add((IFigure)thumbnailFigure);
            contentPane.add((IFigure)coverFigure);
            contentPane.add((IFigure)stateIconFigure, (Object)36);
            if (context != null) {
                boolean imageConstrained = Boolean.TRUE.equals(context.getProperty("constrained", (Object)false));
                boolean imageStretched = Boolean.TRUE.equals(context.getProperty("stretched", (Object)false));
                thumbnailFigure.setConstrained(imageConstrained);
                thumbnailFigure.setStretched(imageStretched);
            }
        } else {
            thumbnailFigure = (SizeableImageFigure)figures.get(0);
            coverFigure = (SimpleRectangleFigure)figures.get(1);
            stateIconFigure = (SizeableImageFigure)figures.get(2);
        }
        thumbnailFigure.setImage(this.getImage((Object)workbookRef));
        stateIconFigure.setImage(this.getStateImage(workbookRef));
        boolean needCover = workbookRef.isInState(2) && SeawindWorkbookRef.SYNC_STATUS_DOWNLOADING == workbookRef.getSyncStatusType();
        coverFigure.setVisible(needCover);
        return contentPane;
    }

    private String getThumbnailImageEntryName(IWorkbookRef workbookRef) {
        SeawindWorkbook swWorkbook = (SeawindWorkbook)workbookRef.getAdapter(SeawindWorkbook.class);
        if (swWorkbook == null) {
            return null;
        }
        List swSheets = swWorkbook.getSheets();
        if (swSheets.isEmpty()) {
            return null;
        }
        SeawindSheet swSheet = (SeawindSheet)swSheets.get(0);
        if (workbookRef instanceof SeawindWorkbookRef) {
            return ((SeawindWorkbookRef)workbookRef).getThumbnailImageEntryName(swSheet.getId(), null);
        }
        return null;
    }

    private Image createThumbnailImageFor(Device device, IWorkbookRef workbookRef) {
        block10: {
            Image image;
            SeawindWorkbook swWorkbook = (SeawindWorkbook)workbookRef.getAdapter(SeawindWorkbook.class);
            if (swWorkbook == null) {
                return null;
            }
            List swSheets = swWorkbook.getSheets();
            if (swSheets.isEmpty()) {
                return null;
            }
            SeawindSheet swSheet = (SeawindSheet)swSheets.get(0);
            InputStream stream = null;
            if (workbookRef instanceof SeawindWorkbookRef) {
                stream = ((SeawindWorkbookRef)workbookRef).getThumbnailImageData(swSheet.getId(), null);
            }
            if (stream == null) {
                stream = workbookRef.getPreviewImageData(swSheet.getId(), null);
            }
            if (stream == null) break block10;
            try {
                image = new Image(device, stream);
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException e) {
                    SeawindUIPlugin.log(e, String.format("Failed to load preview image for sheet 'workbooks/%s/sheets/%s'", swSheet.getParent().getId(), swSheet.getId()));
                    break block10;
                }
                catch (SWTException e) {
                    SeawindUIPlugin.log(e, String.format("Failed to load preview image for sheet 'workbooks/%s/sheets/%s'", swSheet.getParent().getId(), swSheet.getId()));
                }
            }
            stream.close();
            return image;
        }
        return null;
    }

    private Image getStateImage(SeawindWorkbookRef workbookRef) {
        ImageDescriptor imageDescriptor;
        if (workbookRef.isInState(2)) {
            int syncStatusType = workbookRef.getSyncStatusType();
            imageDescriptor = workbookRef.getSyncError() != null ? SeawindUIPlugin.getImageDescriptor("warning.png") : (syncStatusType == SeawindWorkbookRef.SYNC_STATUS_UPLOADING ? SeawindUIPlugin.getImageDescriptor("sync_upload.png") : (syncStatusType == SeawindWorkbookRef.SYNC_STATUS_DOWNLOADING ? SeawindUIPlugin.getImageDescriptor("sync_download.png") : SeawindUIPlugin.getImageDescriptor("syncing.png")));
        } else {
            imageDescriptor = SeawindUIPlugin.getImageDescriptor("synced.png");
        }
        return (Image)this.resources.get((DeviceResourceDescriptor)imageDescriptor);
    }

    public String getToolTip(Object element) {
        if (element instanceof SeawindWorkbookRef) {
            SeawindWorkbookRef workbookRef = (SeawindWorkbookRef)((Object)element);
            IInteractiveMessage error = workbookRef.getSyncError();
            if (error != null) {
                return error.getMessage();
            }
            return workbookRef.getSyncStatus();
        }
        return null;
    }

    public String getSubtitle(Object element) {
        if (element instanceof IWorkbookRef) {
            long t = ((IWorkbookRef)element).getModificationTime();
            Date date = new Date(t);
            return DateFormat.getDateTimeInstance(2, 3).format(date);
        }
        return null;
    }

    protected static class CloudMapFrameContentLayout
    extends DecoratedContainerLayout {
        private IDecorationContext context;

        public CloudMapFrameContentLayout(IDecorationContext context) {
            this.context = context;
        }

        @Override
        protected Dimension calculatePreferredSize(IFigure figure, int wHint, int hHint) {
            if (this.context != null) {
                Insets insets = figure.getInsets();
                Dimension contentSize = (Dimension)this.context.getProperty("org.xmind.ui.gallery.frameContentSize", null);
                if (contentSize != null) {
                    return new Dimension(contentSize.width + insets.getWidth(), contentSize.height + insets.getHeight());
                }
            }
            return super.calculatePreferredSize(figure, wHint, hHint);
        }
    }

    private static class ImageEntry {
        private String key;
        private Image image;

        public ImageEntry(String key, Image image) {
            this.key = key;
            this.image = image;
        }

        public String getKey() {
            return this.key;
        }

        public Image getImage() {
            return this.image;
        }
    }
}

