/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind.dashboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IViewer;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartFactory;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.ui.internal.SpaceCollaborativeEngine;
import org.xmind.gef.util.Properties;
import org.xmind.seawind.internal.core.SeawindFile;
import org.xmind.seawind.internal.core.SeawindFolder;
import org.xmind.ui.gallery.FramePart;
import org.xmind.ui.gallery.GalleryEditTool;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.dashboard.pages.IDashboardContext;
import org.xmind.ui.internal.seawind.SeawindLibrary;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;
import org.xmind.ui.internal.seawind.SeawindWorkbookRef;
import org.xmind.ui.internal.seawind.URIUtils;
import org.xmind.ui.internal.seawind.dashboard.CloudMapGalleryPartFactory;
import org.xmind.ui.internal.seawind.dashboard.CloudMapLabelProvider;
import org.xmind.ui.internal.seawind.handlers.OpenCloudWorkbooksHandler;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.texteditor.FloatingTextEditor;

public class CloudMapPageSection {
    private static final int FRAME_WIDTH = 210;
    private static final int FRAME_HEIGHT = 130;
    private static final String COLOR_CONTENT_BORDER = "#cccccc";
    private IDashboardContext context;
    private SeawindLibrary library;
    private GalleryViewer viewer;
    private ResourceManager resources;
    private Control control;
    private SpaceCollaborativeEngine spaceCollaborativeEngine;

    public CloudMapPageSection(IDashboardContext context, SeawindLibrary library, Composite parent, SpaceCollaborativeEngine spaceCollaborativeEngine) {
        this.context = context;
        this.library = library;
        this.viewer = new GalleryViewer();
        this.spaceCollaborativeEngine = spaceCollaborativeEngine;
        this.control = this.doCreateControl(parent);
    }

    private Control doCreateControl(Composite parent) {
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Properties properties = this.viewer.getProperties();
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_BOTTOM);
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.FALSE);
        properties.set("org.xmind.ui.gallery.solidFrames", true);
        properties.set("org.xmind.ui.gallery.flatFrames", true);
        properties.set("constrained", true);
        properties.set("stretched", true);
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(1, 1, 30, 0, new Insets(10, 65, 20, 65)));
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(210, 130));
        properties.set("org.xmind.ui.gallery.customDecorateContentPane", true);
        properties.set("org.xmind.ui.gallery.contentPaneBorderWidth", 1);
        properties.set("org.xmind.ui.gallery.contentPaneBorderColor", (Object)((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)COLOR_CONTENT_BORDER))));
        properties.set("org.xmind.ui.gallery.contentPaneSpaceCollaborativeEngine", (Object)this.spaceCollaborativeEngine);
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new CloudMapSelectTool());
        editDomain.installTool("edit tool", (ITool)new CloudMapNameEditTool());
        this.viewer.setEditDomain(editDomain);
        this.viewer.setTitleEditingApprover(new IFilter(){

            public boolean select(Object toTest) {
                IWorkbookRef workbookRef = SeawindUIPlugin.getAdapter(toTest, IWorkbookRef.class);
                if (workbookRef != null) {
                    return true;
                }
                return toTest instanceof IPart && (workbookRef = SeawindUIPlugin.getAdapter(((IPart)toTest).getModel(), IWorkbookRef.class)) != null;
            }
        });
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ISelection selection = event.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                Object element = ((IStructuredSelection)selection).getFirstElement();
                if (!CloudMapPageSection.this.canOperateMenu(element)) {
                    event.getViewer().setSelection(null);
                    return;
                }
                CloudMapPageSection.this.openSelectedMap(event.getSelection());
            }
        });
        Control viewerControl = this.viewer.createControl(parent);
        viewerControl.setBackground(parent.getBackground());
        viewerControl.setForeground(parent.getForeground());
        viewerControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setPartFactory((IPartFactory)new CloudMapGalleryPartFactory());
        this.viewer.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new CloudMapLabelProvider(viewerControl));
        this.context.registerContextMenu((Object)viewerControl, "org.xmind.ui.popup.dashboard.cloud.mapCollection");
        final Shell shellForRenameHelper = this.initRenameHelper(parent);
        viewerControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!shellForRenameHelper.isDisposed()) {
                    shellForRenameHelper.setData("org.xmind.ui.seawind.dashboard.renameMapHelper", null);
                }
            }
        });
        return viewerControl;
    }

    private boolean canOperateMenu(Object element) {
        if (element instanceof SeawindWorkbookRef) {
            return this.canSeawindWorkookOperate((SeawindWorkbookRef)((Object)element));
        }
        if (element instanceof SeawindFolder) {
            return this.canSeawindFolderOperate((SeawindFolder)element);
        }
        return false;
    }

    private boolean canSeawindWorkookOperate(SeawindWorkbookRef workbook) {
        return workbook.exists();
    }

    private boolean canSeawindFolderOperate(SeawindFolder folder) {
        if (folder.isEmpty()) {
            return true;
        }
        List<IWorkbookRef> elements = this.getInput(folder);
        Iterator<IWorkbookRef> iterator = elements.iterator();
        if (iterator.hasNext()) {
            IWorkbookRef obj = iterator.next();
            return this.canOperateMenu(obj);
        }
        return false;
    }

    private Shell initRenameHelper(Composite parent) {
        Shell shellForRenameHelper = parent.getShell();
        shellForRenameHelper.setData("org.xmind.ui.seawind.dashboard.renameMapHelper", (Object)new Runnable(){

            @Override
            public void run() {
                CloudMapPageSection.this.startEditing();
            }
        });
        return shellForRenameHelper;
    }

    public void setInput(SeawindFolder folder) {
        List<IWorkbookRef> workbookRefs = this.getInput(folder);
        this.viewer.setInput(workbookRefs);
        this.viewer.getControl().getParent().layout(true, true);
        this.initRenameHelper(this.viewer.getControl().getParent());
    }

    private List<IWorkbookRef> getInput(SeawindFolder folder) {
        ArrayList<IWorkbookRef> input = new ArrayList<IWorkbookRef>();
        Collection<IWorkbookRef> workbookRefs = this.library.getWorkbookRefs();
        Set files = folder.getFiles();
        block0: for (SeawindFile file : files) {
            String identifier = file.getIdentifier();
            for (IWorkbookRef workbookRef : workbookRefs) {
                if (!identifier.equals(URIUtils.getWorkbookIdFromURI(workbookRef.getURI()))) continue;
                input.add(workbookRef);
                continue block0;
            }
        }
        return input;
    }

    private void startEditing() {
        if (this.viewer == null) {
            return;
        }
        EditDomain domain = this.viewer.getEditDomain();
        domain.handleRequest("edit", (IViewer)this.viewer);
    }

    private void openSelectedMap(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (!(element instanceof IWorkbookRef)) {
            return;
        }
        IWorkbookRef workbookRef = (IWorkbookRef)element;
        if (!workbookRef.exists()) {
            return;
        }
        OpenCloudWorkbooksHandler.openFile(workbookRef.getURI());
    }

    public Control getControl() {
        return this.control;
    }

    public GalleryViewer getViewer() {
        return this.viewer;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (this.viewer != null) {
            if (adapter.isAssignableFrom(this.viewer.getClass())) {
                return adapter.cast(this.viewer);
            }
            Object obj = this.viewer.getAdapter(adapter);
            if (obj != null) {
                return (T)obj;
            }
        }
        return null;
    }

    private static class CloudMapNameEditTool
    extends GalleryEditTool {
        private CloudMapNameEditTool() {
        }

        protected IDocument getTextContents(IPart source) {
            return new Document(((IWorkbookRef)source.getModel()).getName());
        }

        protected void handleTextModified(IPart source, IDocument document) {
            if (source == null) {
                return;
            }
            String newName = document.get();
            if (newName == null || "".equals(newName)) {
                return;
            }
            IWorkbookRef editable = (IWorkbookRef)source.getModel();
            if (editable == null) {
                return;
            }
            SeawindUIPlugin.getSeawindLibrary().renameWorkbookRef(editable.getURI(), newName);
        }

        protected void hookEditor(FloatingTextEditor editor) {
            super.hookEditor(editor);
            Dimension frameSize = (Dimension)this.getTargetViewer().getProperties().get("org.xmind.ui.gallery.frameContentSize");
            if (frameSize != null) {
                this.getHelper().setPrefWidth(frameSize.width);
            }
        }
    }

    private class CloudMapSelectTool
    extends GallerySelectTool {
        private CloudMapSelectTool() {
        }

        protected boolean handleMouseDown(MouseEvent me) {
            FramePart targetFrame = this.findFrame(me.target);
            if (targetFrame != null && targetFrame.getFigure().isSelected()) {
                return super.handleMouseDown(me);
            }
            return this.handleSelectionOnMouseDown(me);
        }

        private FramePart findFrame(IPart part) {
            while (part != null) {
                if (part instanceof FramePart) {
                    return (FramePart)part;
                }
                part = part.getParent();
            }
            return null;
        }
    }
}

