/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import org.xmind.core.INumbering;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.plain.Topic;

public class Numbering
implements INumbering,
ICoreEventSource {
    private static final String FORMAT_NONE = "org.xmind.numbering.none";
    private final Topic ownerTopic;
    private String format;
    private String prefix;
    private String suffix;
    private String separator;
    private String depth;
    private boolean prependsParentNumber;

    public Numbering(Topic ownerTopic) {
        this.ownerTopic = ownerTopic;
        this.format = null;
        this.prefix = null;
        this.suffix = null;
        this.separator = null;
        this.depth = null;
        this.prependsParentNumber = true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getOwnedWorkbook());
        }
        if (ISheet.class.equals(adapter)) {
            return adapter.cast(this.getOwnedSheet());
        }
        if (ITopic.class.equals(adapter)) {
            return adapter.cast(this.getParent());
        }
        return null;
    }

    public ITopic getParent() {
        return this.ownerTopic;
    }

    public ISheet getOwnedSheet() {
        return this.ownerTopic.getOwnedSheet();
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownerTopic.getOwnedWorkbook();
    }

    public boolean isOrphan() {
        return this.ownerTopic.isOrphan();
    }

    public String getNumberFormat() {
        return this.format;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getSeparator() {
        return this.separator;
    }

    public boolean prependsParentNumbers() {
        return this.prependsParentNumber;
    }

    public void setFormat(String format) {
        String oldFormat = this.format;
        if (format == oldFormat || format != null && format.equals(oldFormat)) {
            return;
        }
        this.format = format;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "numberingFormat", (Object)oldFormat, (Object)format);
    }

    public void setPrefix(String prefix) {
        String oldPrefix = this.prefix;
        if (prefix == oldPrefix || prefix != null && prefix.equals(oldPrefix)) {
            return;
        }
        this.prefix = prefix;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "numberingPrefix", (Object)oldPrefix, (Object)prefix);
    }

    public void setSuffix(String suffix) {
        String oldSuffix = this.suffix;
        if (suffix == oldSuffix || suffix != null && suffix.equals(oldSuffix)) {
            return;
        }
        this.suffix = suffix;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "numberingSuffix", (Object)oldSuffix, (Object)suffix);
    }

    public void setSeparator(String separator) {
        String oldSeparator = this.separator;
        if (separator == oldSeparator || separator != null && separator.equals(oldSeparator)) {
            return;
        }
        this.separator = separator;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "numberingSeparator", (Object)oldSeparator, (Object)separator);
    }

    public void setPrependsParentNumbers(boolean prepend) {
        boolean oldPrepend = this.prependsParentNumber;
        if (prepend == oldPrepend) {
            return;
        }
        this.prependsParentNumber = prepend;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "parentNumberingPrepending", (Object)oldPrepend, (Object)prepend);
    }

    public String getParentFormat() {
        ITopic parent;
        ITopic topic = this.getParent();
        if (topic != null && (parent = topic.getParent()) != null) {
            return parent.getNumbering().getComputedFormat();
        }
        return null;
    }

    public String getComputedFormat() {
        String format = this.getNumberFormat();
        if (format != null) {
            return format;
        }
        ITopic topic = this.getParent();
        if (!"attached".equals(topic.getType())) {
            return null;
        }
        return this.getParentFormat();
    }

    public String getParentSeparator() {
        ITopic parent;
        ITopic topic = this.getParent();
        if (topic != null && (parent = topic.getParent()) != null) {
            return parent.getNumbering().getComputedSeparator();
        }
        return null;
    }

    public String getComputedSeparator() {
        String separator = this.getSeparator();
        if (separator != null) {
            return separator;
        }
        ITopic topic = this.getParent();
        if (!"attached".equals(topic.getType())) {
            return null;
        }
        return this.getParentSeparator();
    }

    public String getDepth() {
        return this.depth;
    }

    public void setDepth(String depth) {
        String oldDepth = this.depth;
        if (depth == oldDepth || depth != null && depth.equals(oldDepth)) {
            return;
        }
        this.depth = depth;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "numberingDepth", (Object)oldDepth, (Object)depth);
    }

    public int getComputedDepth() {
        if (FORMAT_NONE.equals(this.getNumberFormat())) {
            return -1;
        }
        String d = this.getDepth();
        if (d != null) {
            return Integer.parseInt(d);
        }
        if (this.isInherited(1)) {
            return this.getParent().getParent().getNumbering().getComputedDepth() - 1;
        }
        if (this.getNumberFormat() != null) {
            return 3;
        }
        return -1;
    }

    public boolean isInherited(int min) {
        ITopic topic = this.getParent();
        if (!"attached".equals(topic.getType())) {
            return false;
        }
        if (this.getDepth() != null) {
            return false;
        }
        if (FORMAT_NONE.equals(this.getNumberFormat())) {
            return false;
        }
        ITopic parentTopic = topic.getParent();
        if (parentTopic == null) {
            return false;
        }
        int pd = parentTopic.getNumbering().getComputedDepth();
        return pd > min;
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener((ICoreEventSource)this, type, listener);
    }

    public ICoreEventSupport getCoreEventSupport() {
        return this.ownerTopic.getCoreEventSupport();
    }
}

