/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmind.core.IExtensionElement;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookExtension;
import org.xmind.core.IWorkbookExtensionElement;
import org.xmind.core.plain.WorkbookExtension;

public class WorkbookExtensionElement
implements IWorkbookExtensionElement {
    public static final String OBJECT_ID = "object-id";
    public static final String RESOURCE_PATH = "resource-path";
    private final WorkbookExtension owner;
    private final String name;
    private WorkbookExtensionElement parent;
    private Map<String, String> attributes;
    private String textContent;
    private boolean orphan;
    private List<WorkbookExtensionElement> children;

    public WorkbookExtensionElement(WorkbookExtension owner, String name) {
        this.owner = owner;
        this.name = name;
        this.children = new ArrayList<WorkbookExtensionElement>();
        this.parent = null;
        this.attributes = new HashMap<String, String>();
        this.textContent = null;
        this.orphan = true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getOwnedWorkbook());
        }
        return null;
    }

    public IWorkbook getOwnedWorkbook() {
        return this.owner.getOwnedWorkbook();
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public IWorkbookExtension getExtension() {
        return this.owner;
    }

    public List<IWorkbookExtensionElement> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public List<IWorkbookExtensionElement> getChildren(String elementName) {
        ArrayList<IWorkbookExtensionElement> eles = new ArrayList<IWorkbookExtensionElement>(this.children.size());
        if (elementName != null) {
            for (IWorkbookExtensionElement iWorkbookExtensionElement : this.children) {
                if (!elementName.equals(iWorkbookExtensionElement.getName())) continue;
                eles.add(iWorkbookExtensionElement);
            }
        }
        return eles;
    }

    public IWorkbookExtensionElement createChild(String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException();
        }
        WorkbookExtensionElement child = new WorkbookExtensionElement(this.owner, elementName);
        this.children.add(child);
        child.setParent(this);
        if (!this.isOrphan()) {
            child.onParented();
        }
        return child;
    }

    public IWorkbookExtensionElement getCreatedChild(String elementName) {
        IWorkbookExtensionElement child = this.getFirstChild(elementName);
        if (child != null) {
            return child;
        }
        return this.createChild(elementName);
    }

    public IWorkbookExtensionElement getFirstChild(String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException();
        }
        for (WorkbookExtensionElement child : this.children) {
            if (!elementName.equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    protected void setParent(WorkbookExtensionElement parent) {
        this.parent = parent;
    }

    public IWorkbookExtensionElement getParent() {
        return this.parent;
    }

    public void addChild(IWorkbookExtensionElement child, int index) {
        if (child == null || !(child instanceof WorkbookExtensionElement) || child.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        WorkbookExtensionElement c = (WorkbookExtensionElement)child;
        IWorkbookExtensionElement oldParent = c.getParent();
        if (oldParent != null) {
            oldParent.deleteChild((IExtensionElement)c);
        }
        if (index >= 0 && index < this.children.size()) {
            this.children.add(index, c);
        } else {
            this.children.add(c);
        }
        if (!this.isOrphan()) {
            c.onParented();
        }
        c.setParent(this);
    }

    public void deleteChild(IWorkbookExtensionElement child) {
        if (child == null || !(child instanceof WorkbookExtensionElement) || child.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        WorkbookExtensionElement c = (WorkbookExtensionElement)child;
        if (c.getParent() != this || !this.children.contains(c)) {
            return;
        }
        if (!this.isOrphan()) {
            c.onOrphan();
        }
        this.children.remove(c);
        c.setParent(null);
    }

    public void deleteChildren(String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException();
        }
        Iterator<WorkbookExtensionElement> childIt = this.children.iterator();
        while (childIt.hasNext()) {
            WorkbookExtensionElement c = childIt.next();
            if (!elementName.equals(c.getName())) continue;
            if (!this.isOrphan()) {
                c.onOrphan();
            }
            childIt.remove();
            c.setParent(null);
        }
    }

    public void deleteChildren() {
        for (WorkbookExtensionElement child : this.children) {
            if (!this.isOrphan()) {
                child.onOrphan();
            }
            child.setParent(null);
        }
        this.children.clear();
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getAttributeKeys() {
        return this.attributes.keySet();
    }

    public String getAttribute(String attrName) {
        if (attrName == null) {
            return null;
        }
        return this.attributes.get(attrName);
    }

    public void setAttribute(String attrName, String attrValue) {
        if (attrName == null) {
            return;
        }
        if (attrValue == null) {
            this.attributes.remove(attrName);
        } else {
            this.attributes.put(attrName, attrValue);
        }
    }

    public String getTextContent() {
        return this.textContent;
    }

    public void setTextContent(String text) {
        this.textContent = text;
    }

    public void setResourcePath(String resourcePath) {
        this.setAttribute(RESOURCE_PATH, resourcePath);
    }

    public String getResourcePath() {
        return this.getAttribute(RESOURCE_PATH);
    }

    public void setObjectId(String objectId) {
        this.setAttribute(OBJECT_ID, objectId);
    }

    public String getObjectId() {
        return this.getAttribute(OBJECT_ID);
    }

    protected void onParented() {
        this.orphan = false;
        for (IWorkbookExtensionElement iWorkbookExtensionElement : this.children) {
            ((WorkbookExtensionElement)iWorkbookExtensionElement).onParented();
        }
    }

    protected void onOrphan() {
        for (IWorkbookExtensionElement iWorkbookExtensionElement : this.children) {
            ((WorkbookExtensionElement)iWorkbookExtensionElement).onOrphan();
        }
        this.orphan = true;
    }
}

