/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.xmind.core.IIdentifiable;
import org.xmind.core.util.IObjectRegistryListener;

public class ObjectRegistry {
    private final Map<String, IIdentifiable> registry = new HashMap<String, IIdentifiable>();
    private final List<IObjectRegistryListener> listeners = new ArrayList<IObjectRegistryListener>();

    public IIdentifiable get(String id) {
        return this.registry.get(id);
    }

    public <T extends IIdentifiable> T get(String id, Class<T> objectClass) {
        IIdentifiable object = this.registry.get(id);
        if (objectClass.isInstance(object)) {
            return (T)((IIdentifiable)objectClass.cast(object));
        }
        return null;
    }

    public <T extends IIdentifiable> T register(T object) {
        String id = object.getId();
        IIdentifiable oldObject = this.registry.put(id, object);
        if (oldObject != null) {
            this.fireObjectUnregistered(id, oldObject);
        }
        this.fireObjectRegistered(id, object);
        return object;
    }

    public boolean unregister(IIdentifiable object) {
        String id = object.getId();
        IIdentifiable oldObject = this.registry.remove(id);
        if (oldObject != null) {
            this.fireObjectUnregistered(id, oldObject);
        }
        return oldObject == object;
    }

    public void addObjectRegistryListener(IObjectRegistryListener listener) {
        this.listeners.add(listener);
    }

    public void removeObjectRegistryListener(IObjectRegistryListener listener) {
        this.listeners.remove(listener);
    }

    private void fireObjectRegistered(String id, IIdentifiable object) {
        IObjectRegistryListener[] array;
        IObjectRegistryListener[] iObjectRegistryListenerArray = array = this.listeners.toArray(new IObjectRegistryListener[this.listeners.size()]);
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            IObjectRegistryListener listener = iObjectRegistryListenerArray[n2];
            listener.objectRegistered(id, object);
            ++n2;
        }
    }

    private void fireObjectUnregistered(String id, IIdentifiable object) {
        IObjectRegistryListener[] array;
        IObjectRegistryListener[] iObjectRegistryListenerArray = array = this.listeners.toArray(new IObjectRegistryListener[this.listeners.size()]);
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            IObjectRegistryListener listener = iObjectRegistryListenerArray[n2];
            listener.objectUnregistered(id, object);
            ++n2;
        }
    }

    public String createUniqueId() {
        return ObjectRegistry.createUniversalUniqueId();
    }

    public static String createUniversalUniqueId() {
        return UUID.randomUUID().toString();
    }
}

