/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal;

import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Assert;
import org.xmind.core.ITopic;
import org.xmind.core.internal.CoreAxisProvider;
import org.xmind.core.internal.xpath.Evaluator;

public class TopicPropertyTester
extends PropertyTester {
    private static final String P_EVAL = "eval";
    private static final String P_TYPE = "type";
    private static final String P_TITLE = "title";
    private static final String P_STRUCTURE_CLASS = "structureClass";
    private static final String P_FOLDED = "folded";
    private static final String P_HYPERLINK = "hyperlink";
    private static final String P_IMAGE_SOURCE = "imageSource";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Assert.isLegal((boolean)(receiver instanceof ITopic), (String)("Receiver is not an ITopic object: " + receiver));
        ITopic topic = (ITopic)receiver;
        if (P_TYPE.equals(property)) {
            return TopicPropertyTester.evaluates(topic, TopicPropertyTester.propEvalExp("@type", expectedValue));
        }
        if (P_HYPERLINK.equals(property)) {
            return TopicPropertyTester.evaluates(topic, TopicPropertyTester.propEvalExp("@hyperlink", expectedValue));
        }
        if (P_TITLE.equals(property)) {
            return TopicPropertyTester.evaluates(topic, TopicPropertyTester.propEvalExp("@title", expectedValue));
        }
        if (P_STRUCTURE_CLASS.equals(property)) {
            return TopicPropertyTester.evaluates(topic, TopicPropertyTester.propEvalExp("@structureClass", expectedValue));
        }
        if (P_FOLDED.equals(property)) {
            return TopicPropertyTester.evaluates(topic, "@folded");
        }
        if (P_IMAGE_SOURCE.equals(property)) {
            return TopicPropertyTester.evaluates(topic, TopicPropertyTester.propEvalExp("image/@source", expectedValue));
        }
        if (P_EVAL.equals(property)) {
            if (!(expectedValue instanceof String)) {
                return false;
            }
            return TopicPropertyTester.evaluates(topic, (String)expectedValue);
        }
        throw new IllegalArgumentException("Unrecognized property: " + property);
    }

    private static String propEvalExp(String propertyPath, Object expectedValue) {
        String value;
        String string = value = expectedValue == null ? "" : expectedValue.toString();
        if (value.startsWith("^")) {
            return String.format("matches(%s,'%s')", propertyPath, value);
        }
        return String.format("%s='%s'", propertyPath, value);
    }

    private static boolean evaluates(ITopic topic, String expression) {
        Evaluator evaluator = new Evaluator(expression, new CoreAxisProvider());
        List<Object> sequence = evaluator.evaluate(topic);
        if (sequence.isEmpty()) {
            return false;
        }
        Object result = sequence.get(0);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return result != null;
    }
}

