/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.dashboard;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.viewers.ImageCachedLabelProvider;

public class StructureListContentProvider
implements IStructuredContentProvider {
    public static final String CONTENT_URI = "platform:/plugin/org.xmind.cathy/dashboard/new/structures.xml";
    public static final String NLS_PATH_BASE = "dashboard/new/structures";
    private static final String TAG_STRUCTURE_LIST = "structure-list";
    private static final String TAG_STRUCTURE = "structure";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ICON = "icon";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_ICON_HEIGHT = "icon-height";
    private static final String ATTR_ICON_WIDTH = "icon-width";
    private ContentSource source = null;
    private List<StructureDescriptor> structureDescriptors = new ArrayList<StructureDescriptor>();
    private Dimension iconSizeHints = new Dimension();

    public void dispose() {
        this.structureDescriptors.clear();
        this.source = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        ContentSource newSource = this.toContentSource(newInput);
        if (newSource == this.source || newSource != null && newSource.equals(this.source)) {
            return;
        }
        this.source = newSource;
        this.structureDescriptors.clear();
        this.iconSizeHints = new Dimension();
        if (this.source != null) {
            this.readTemplatesFromSource(this.source);
        }
        if (viewer instanceof GalleryViewer) {
            ((GalleryViewer)viewer).getProperties().set("org.xmind.ui.gallery.frameContentSize", (Object)this.iconSizeHints);
        }
    }

    private ContentSource toContentSource(Object input) {
        ContentSource newSource = input instanceof ContentSource ? (ContentSource)input : (input instanceof String ? new ContentSource((String)input, null) : null);
        return newSource;
    }

    public Object[] getElements(Object inputElement) {
        ContentSource inputSource = this.toContentSource(inputElement);
        if (inputSource == this.source || inputSource != null && inputSource.equals(this.source)) {
            return this.structureDescriptors.toArray();
        }
        return new Object[0];
    }

    private void readTemplatesFromSource(ContentSource source) {
        Properties nlsProperties = source.nlsPathBase != null ? CathyPlugin.getDefault().loadNLSProperties(source.nlsPathBase) : new Properties();
        if (source.contentURI != null) {
            try {
                URL contentURL = new URL(source.contentURI);
                URL locatedURL = FileLocator.find((URL)contentURL);
                if (locatedURL != null) {
                    contentURL = locatedURL;
                }
                InputStream contentStream = contentURL.openStream();
                try {
                    Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(contentStream);
                    this.readElement(doc.getDocumentElement(), nlsProperties);
                }
                finally {
                    contentStream.close();
                }
            }
            catch (Exception e) {
                CathyPlugin.log(e, "Failed to load content for structure list from: " + source.contentURI);
            }
        }
    }

    private void readElement(Element element, Properties nlsProperties) {
        String tagName = element.getTagName();
        if (TAG_STRUCTURE.equals(tagName)) {
            this.readTemplate(element, nlsProperties);
        } else if (TAG_STRUCTURE_LIST.equals(tagName)) {
            this.readGlobalAttributes(element);
        }
        this.readChildren(element.getChildNodes(), nlsProperties);
    }

    private void readChildren(NodeList children, Properties nlsProperties) {
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Node node = children.item(i);
            if (node != null && node.getNodeType() == 1) {
                this.readElement((Element)node, nlsProperties);
            }
            ++i;
        }
    }

    private void readTemplate(Element element, Properties nlsProperties) {
        ImageDescriptor icon;
        String nativeName;
        String id = element.getAttribute(ATTR_ID);
        String name = element.getAttribute(ATTR_NAME);
        String iconURI = element.getAttribute(ATTR_ICON);
        String structureClass = element.getAttribute(ATTR_VALUE);
        if (id == null || "".equals(id)) {
            throw new IllegalArgumentException("Missing 'id' attribute");
        }
        if (name == null) {
            name = "";
        } else if (name.startsWith("%") && (nativeName = nlsProperties.getProperty(name.substring(1))) != null) {
            name = nativeName;
        }
        if (iconURI == null) {
            icon = null;
        } else {
            try {
                icon = ImageDescriptor.createFromURL((URL)new URL(iconURI));
            }
            catch (MalformedURLException e) {
                CathyPlugin.log(e, "Invalid icon URI: '" + iconURI + "'");
                icon = null;
            }
        }
        StructureDescriptor structureDescriptor = new StructureDescriptor(id, structureClass, name, icon);
        this.structureDescriptors.add(structureDescriptor);
    }

    private void readGlobalAttributes(Element element) {
        String iconWidth = element.getAttribute(ATTR_ICON_WIDTH);
        String iconHeight = element.getAttribute(ATTR_ICON_HEIGHT);
        if (iconWidth != null && iconHeight != null) {
            try {
                int width = Integer.parseInt(iconWidth, 10);
                int height = Integer.parseInt(iconHeight, 10);
                this.iconSizeHints.width = width;
                this.iconSizeHints.height = height;
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public static final ContentSource getDefaultInput() {
        return new ContentSource(CONTENT_URI, NLS_PATH_BASE);
    }

    public static final class ContentSource {
        public final String contentURI;
        public final String nlsPathBase;

        public ContentSource(String contentURI, String nlsPathBase) {
            this.contentURI = contentURI;
            this.nlsPathBase = nlsPathBase;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof ContentSource)) {
                return false;
            }
            ContentSource that = (ContentSource)obj;
            return (this.contentURI == that.contentURI || this.contentURI != null && this.contentURI.equals(that.contentURI)) && (this.nlsPathBase == that.nlsPathBase || this.nlsPathBase != null && this.nlsPathBase.equals(that.nlsPathBase));
        }

        public int hashCode() {
            int x = 37;
            if (this.contentURI != null) {
                x ^= this.contentURI.hashCode();
            }
            if (this.nlsPathBase != null) {
                x ^= this.nlsPathBase.hashCode();
            }
            return x;
        }
    }

    static class StructureDescriptor {
        private String id;
        private String value;
        private String name;
        private ImageDescriptor icon;

        public StructureDescriptor(String id, String value, String name, ImageDescriptor icon) {
            Assert.isNotNull((Object)id);
            Assert.isNotNull((Object)value);
            this.id = id;
            this.value = value;
            this.name = name;
            this.icon = icon;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public ImageDescriptor getIcon() {
            return this.icon;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof StructureDescriptor)) {
                return false;
            }
            StructureDescriptor that = (StructureDescriptor)obj;
            return this.id.equals(that.id);
        }
    }

    static class StructureListLabelProvider
    extends ImageCachedLabelProvider {
        StructureListLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof StructureDescriptor) {
                return ((StructureDescriptor)element).getName();
            }
            return super.getText(element);
        }

        protected Image createImage(Object element) {
            ImageDescriptor icon;
            if (element instanceof StructureDescriptor && (icon = ((StructureDescriptor)element).getIcon()) != null) {
                return icon.createImage();
            }
            return null;
        }
    }
}

