/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.ui.dialogs.StyledLink;
import org.xmind.ui.internal.ToolkitImages;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.UITimer;

public class Promotion
extends Dialog {
    private static final int MARGIN = 5;
    private static int STAY_DURATION = 5000;
    private static List<Promotion> promotionList = new ArrayList<Promotion>();
    private String infoText;
    private IAction action;
    private boolean isCenter;
    private UITimer timer;
    private int duration = STAY_DURATION;
    private ResourceManager resources;
    private boolean isClosed = false;

    public Promotion(Shell parent, String infoText, IAction action, boolean isCenter) {
        super(parent);
        this.infoText = infoText;
        this.action = action;
        this.isCenter = isCenter;
        this.setShellStyle(12);
        this.setBlockOnOpen(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)newShell);
    }

    protected Point getInitialLocation(Point initialSize) {
        Dialog topDialog;
        Point size = this.getInitialSize();
        Rectangle bounds = this.getParentShell().getBounds();
        int x = this.isCenter ? bounds.x + (bounds.width - size.x) / 2 : bounds.x + bounds.width - size.x - 5;
        int y = bounds.y + bounds.height - size.y - 5;
        if (promotionList.size() != 0 && !(topDialog = (Dialog)promotionList.get(promotionList.size() - 1)).getShell().isDisposed()) {
            y = topDialog.getShell().getBounds().y - size.y - 1;
        }
        return new Point(x, y);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#e1e1e1")));
        GridData gridData = new GridData(1808);
        gridData.widthHint = 446;
        gridData.heightHint = 170;
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 1;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.createImageSection(composite);
        this.createContentSection(composite);
        return composite;
    }

    private void createImageSection(Composite parent) {
        ImageDescriptor imageDesc;
        Image image = null;
        if (this.action != null && (imageDesc = this.action.getImageDescriptor()) != null) {
            image = (Image)this.resources.get((DeviceResourceDescriptor)imageDesc);
        }
        Shell sourceShell = this.getParentShell();
        if (image == null && sourceShell != null && !sourceShell.isDisposed()) {
            image = this.findBrandingImage(sourceShell.getImage(), sourceShell.getImages());
        }
        if (image != null) {
            Composite composite = new Composite(parent, 0);
            composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#f7f7f7")));
            GridData gridData = new GridData(16384, 4, false, true);
            composite.setLayoutData((Object)gridData);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 0;
            composite.setLayout((Layout)layout);
            Composite composite2 = new Composite(composite, 0);
            composite2.setBackground(composite.getBackground());
            GridData gridData2 = new GridData(4, 4, true, true);
            gridData2.widthHint = 174;
            composite2.setLayoutData((Object)gridData2);
            GridLayout layout2 = new GridLayout(1, false);
            layout2.marginWidth = 0;
            layout2.marginHeight = 0;
            composite2.setLayout((Layout)layout2);
            Label iconLabel = new Label(composite2, 0x1000000);
            iconLabel.setBackground(composite2.getBackground());
            GridData gridData3 = new GridData(0x1000000, 0x1000000, true, true);
            iconLabel.setLayoutData((Object)gridData3);
            iconLabel.setImage(image);
            this.createSeperator(composite);
        } else {
            ((GridLayout)parent.getLayout()).numColumns = 1;
        }
    }

    private void createSeperator(Composite parent) {
        Composite seperator = new Composite(parent, 0);
        seperator.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#e1e1e1")));
        GridData gridData = new GridData(0x1000000, 4, false, true);
        gridData.widthHint = 1;
        seperator.setLayoutData((Object)gridData);
        seperator.setLayout((Layout)new GridLayout());
    }

    private void createContentSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#ffffff")));
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 5;
        composite.setLayout((Layout)gridLayout);
        this.createCloseButton(composite);
        this.createInfoSection(composite);
        this.createActionButton(composite);
    }

    private void createCloseButton(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData layoutData = new GridData(131072, 128, false, false);
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 14;
        layout.marginRight = 14;
        composite.setLayout((Layout)layout);
        final Label close = new Label(composite, 131072);
        close.setBackground(composite.getBackground());
        close.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        final Image focusedImage = (Image)this.resources.get((DeviceResourceDescriptor)ToolkitImages.get("close.png", true));
        final Image noFocusedImage = (Image)this.resources.get((DeviceResourceDescriptor)ToolkitImages.get("close.png", false));
        close.setImage(noFocusedImage);
        composite.setCursor(parent.getDisplay().getSystemCursor(21));
        close.setCursor(parent.getDisplay().getSystemCursor(21));
        MouseTrackListener mouseTrackListener = new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                close.setImage(noFocusedImage);
            }

            public void mouseEnter(MouseEvent e) {
                close.setImage(focusedImage);
            }
        };
        composite.addMouseTrackListener(mouseTrackListener);
        close.addMouseTrackListener(mouseTrackListener);
        MouseListener mouseListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                Promotion.this.close();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        composite.addMouseListener(mouseListener);
        close.addMouseListener(mouseListener);
    }

    private void createInfoSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#ffffff")));
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 20;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        String content = this.infoText;
        StyledLink link = content.indexOf("<form>") >= 0 ? new StyledLink(composite, 0) : new StyledLink(composite, 64);
        link.setBackground(composite.getBackground());
        link.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#4a4a4a")));
        link.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight(link.getFont().getFontData(), 3))));
        link.setText(content);
        GridData layoutData = new GridData(4, 0x1000000, true, true);
        link.setLayoutData(layoutData);
        if (this.action == null) {
            link.setEnabled(false);
        }
        final IAction theAction = this.action;
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (theAction != null) {
                            theAction.run();
                        }
                    }
                });
            }
        });
    }

    private void createActionButton(Composite parent) {
        boolean hasAction;
        boolean bl = hasAction = this.action != null;
        if (hasAction) {
            Composite composite = new Composite(parent, 0);
            composite.setBackground(parent.getBackground());
            GridData layoutData = new GridData(0x1000000, 1024, false, false);
            composite.setLayoutData((Object)layoutData);
            GridLayout layout = new GridLayout(1, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.marginBottom = 13;
            composite.setLayout((Layout)layout);
            Hyperlink hyperlink = new Hyperlink(composite, 0);
            hyperlink.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            hyperlink.setBackground(composite.getBackground());
            hyperlink.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#4a90e2")));
            hyperlink.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.bold(FontUtils.relativeHeight(hyperlink.getFont().getFontData(), 3), true))));
            hyperlink.setUnderlined(true);
            hyperlink.setText(this.action.getText());
            hyperlink.addHyperlinkListener(new IHyperlinkListener(){

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkActivated(HyperlinkEvent e) {
                    Promotion.this.close();
                    Promotion.this.action.run();
                }
            });
        }
    }

    private Image findBrandingImage(Image mainImage, Image[] images) {
        int s;
        Rectangle r;
        Image best = null;
        int scale = -1;
        if (mainImage != null) {
            r = mainImage.getBounds();
            s = Math.abs(r.width - 48) * Math.abs(r.height - 48);
            if (scale < 0 || s < scale) {
                best = mainImage;
                scale = s;
            }
        }
        Image[] imageArray = images;
        int n = images.length;
        int n2 = 0;
        while (n2 < n) {
            Image img = imageArray[n2];
            r = img.getBounds();
            s = Math.abs(r.width - 48) * Math.abs(r.height - 48);
            if (scale < 0 || s < scale) {
                best = img;
                scale = s;
            }
            ++n2;
        }
        return best;
    }

    public void setDuration(int stayDuration) {
        this.duration = stayDuration;
    }

    public int open() {
        int code = super.open();
        if (this.timer == null) {
            this.timer = new UITimer(this.duration, 0, 0, (ISafeRunnable)new SafeRunnable(){

                public void run() {
                    Promotion.this.close();
                    Promotion.this.timer.cancel();
                    Promotion.this.timer = null;
                }
            });
        }
        this.timer.run();
        promotionList.add(this);
        return code;
    }

    public boolean close() {
        return this.closePromotion();
    }

    private synchronized boolean closePromotion() {
        if (this.isClosed) {
            return false;
        }
        this.isClosed = true;
        this.movePromotionLocation(promotionList.indexOf((Object)this));
        promotionList.remove((Object)this);
        return super.close();
    }

    private void movePromotionLocation(int index) {
        if (promotionList.size() - 1 > index && -1 < index) {
            int i = index + 1;
            while (i < promotionList.size()) {
                Promotion prom = promotionList.get(i);
                prom.getShell().setLocation(new Point(prom.getShell().getBounds().x, prom.getShell().getBounds().y + prom.getInitialSize().y));
                ++i;
            }
        }
    }
}

