/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.commands;

import org.eclipse.core.runtime.Assert;
import org.xmind.core.IWorkbook;
import org.xmind.gef.command.SourceCommand;

public class MoveSheetCommand
extends SourceCommand {
    private int oldIndex;
    private int newIndex;

    public MoveSheetCommand(IWorkbook workbook, int oldIndex, int newIndex) {
        super((Object)workbook);
        int size = workbook.getSheets().size();
        Assert.isTrue((oldIndex >= 0 && oldIndex < size ? 1 : 0) != 0);
        this.oldIndex = oldIndex;
        if (newIndex < 0 || newIndex >= size) {
            newIndex = size - 1;
        }
        this.newIndex = newIndex;
    }

    public void execute() {
        super.execute();
    }

    public void redo() {
        ((IWorkbook)this.getSource()).moveSheet(this.oldIndex, this.newIndex);
        super.redo();
    }

    public void undo() {
        ((IWorkbook)this.getSource()).moveSheet(this.newIndex, this.oldIndex);
        super.undo();
    }
}

