/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.aspose.exports.document;

import com.aspose.words.CustomDocumentProperties;
import com.aspose.words.Document;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.Font;
import com.aspose.words.License;
import com.aspose.words.Node;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.SaveOptions;
import com.aspose.words.Shape;
import com.aspose.words.TabStop;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.sf.image4j.codec.ico.ICODecoder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Util;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.Core;
import org.xmind.core.IFileEntry;
import org.xmind.core.IHtmlNotesContent;
import org.xmind.core.IHyperlinkSpan;
import org.xmind.core.IImage;
import org.xmind.core.IImageSpan;
import org.xmind.core.INotesContent;
import org.xmind.core.IParagraph;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ISpan;
import org.xmind.core.ISummary;
import org.xmind.core.ITextSpan;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.style.IStyle;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.aspose.AsposePlugin;
import org.xmind.ui.internal.aspose.exports.ExportMessages;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.internal.protocols.FilePathParser;
import org.xmind.ui.mindmap.MindMapImageExporter;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.util.ImageFormat;
import org.xmind.ui.util.MarkerImageDescriptor;
import org.xmind.ui.wizards.ExportPart;
import org.xmind.ui.wizards.ExportUtils;
import org.xmind.ui.wizards.Exporter;
import org.xmind.ui.wizards.IExportPart;
import org.xmind.ui.wizards.IExporter;
import org.xmind.ui.wizards.RelationshipDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordExporter
extends Exporter {
    public static final int WORD_97_2003 = 1;
    public static final int WORD_2007 = 2;
    public static final int RTF = 3;
    public static final int PDF = 4;
    public static final int ODT = 5;
    private static final String TEMP_PATH = "export/word/";
    private static final String UNDERLINE = "_";
    private static boolean hasNumbering = false;
    private String targetPath;
    private int version;
    private IDialogSettings settings;
    private IGraphicalEditor sourceEditor;
    private File scriptDir = null;
    private DocumentBuilder builder;
    private com.aspose.words.List listFormat;
    private Map<ITopic, String> bookmarks = null;
    private Map<String, String> tempPaths = null;
    private static Map<String, String> floatingTopicPositions = null;
    private static final Object NULL = new Object();
    private Map<String, Object> files = null;
    private static final String FILES = "_files";
    private String relativeFilesPath;
    private String filesPath;
    public static final String CONTENT_LEVEL = "level";
    public static final String NUMBER_LEVEL = "number";

    public WordExporter(ISheet sheet, ITopic centralTopic, String targetPath, int version, IDialogSettings settings, IGraphicalEditor sourceEditor) {
        super(sheet, centralTopic);
        this.targetPath = targetPath;
        this.version = version;
        this.settings = settings;
        this.sourceEditor = sourceEditor;
    }

    public void init() {
        this.appendTopic(this.getCentralTopic(), 0);
    }

    private void appendTopic(ITopic topic, int level) {
        this.append((IExportPart)new TitlePart(this, topic, level));
        this.setNumberingStatus(topic);
        this.appendTopicContent(topic, level);
    }

    private void appendTopicContent(ITopic topic, int level) {
        List relationships;
        IImage image;
        boolean hasLabel;
        Set markers = topic.getMarkerRefs();
        Set labels = topic.getLabels();
        boolean hasMarker = this.getBoolean("includeMarkers") && !markers.isEmpty();
        boolean bl = hasLabel = this.getBoolean("includeLabels") && !labels.isEmpty();
        if (hasMarker || hasLabel) {
            this.append((IExportPart)new TagsPart(this, topic, hasMarker ? markers : null, hasLabel ? labels : null));
        }
        if (this.hasOverview(topic)) {
            this.append((IExportPart)new OverviewPart(this, topic));
        }
        if (this.getBoolean("includeImage") && (image = topic.getImage()).getSource() != null) {
            this.append((IExportPart)new ImagePart(this, image));
        }
        if (this.getBoolean("includeRelationships") && !(relationships = ExportUtils.getRelationships((ITopic)topic, (List)this.getRelationships())).isEmpty()) {
            this.append((IExportPart)new RelationshipsPart(this, topic, relationships, this.getRelationships()));
        }
        if (this.getBoolean("includeNotes")) {
            INotesContent content = topic.getNotes().getContent("html");
            if (content == null) {
                content = topic.getNotes().getContent("plain");
            }
            if (content != null) {
                this.append((IExportPart)new NotesPart(this, content));
            }
        }
        int nextLevel = level + 1;
        for (ITopic sub : topic.getChildren("attached")) {
            this.appendTopic(sub, nextLevel);
        }
        if (this.getBoolean("includeSummaries")) {
            for (ISummary summary : topic.getSummaries()) {
                this.appendSummary(summary, topic, nextLevel);
            }
        }
        if (this.getBoolean("includeFloatingTopics")) {
            for (ITopic sub : topic.getChildren("detached")) {
                this.appendTopic(sub, nextLevel);
            }
        }
    }

    private void appendSummary(ISummary summary, ITopic topic, int nextLevel) {
        ITopic summaryTopic = summary.getTopic();
        if (summaryTopic == null) {
            return;
        }
        this.append((IExportPart)new TitlePart(this, summaryTopic, nextLevel));
        this.append((IExportPart)new SummaryPart(this, summary));
        this.appendTopicContent(summaryTopic, nextLevel);
    }

    public void start(Display display, Shell shell) throws InvocationTargetException {
        super.start(display, shell);
        try {
            this.setLicense();
            this.builder = new DocumentBuilder(new Document());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.listFormat = this.builder.getDocument().getLists().add(14);
        this.builder.getDocument().setDefaultTabStop(10.0);
    }

    private void setLicense() throws Exception {
        new License().setLicense((InputStream)new ByteArrayInputStream(AsposePlugin.getAsposeLicense()));
    }

    protected void write(IProgressMonitor monitor, IExportPart part) throws InvocationTargetException, InterruptedException {
        if (part instanceof WordExportPart) {
            ((WordExportPart)part).write(this.builder, this.listFormat);
        }
    }

    public void end() throws InvocationTargetException {
        this.writeDocumentProperties(this.getSheet());
        this.writeTableOfContent();
        this.writePageNumber();
        int format = this.getSaveFormat(this.version);
        try {
            if (format == 20) {
                OoxmlSaveOptions saveOption = new OoxmlSaveOptions(format);
                saveOption.setCompliance(1);
                this.builder.getDocument().save(this.targetPath, (SaveOptions)saveOption);
            } else {
                this.builder.getDocument().save(this.targetPath, format);
            }
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
        hasNumbering = false;
        floatingTopicPositions = null;
        super.end();
    }

    private int getSaveFormat(int version) {
        switch (version) {
            case 1: {
                return 10;
            }
            case 2: {
                return 20;
            }
            case 4: {
                return 40;
            }
            case 5: {
                return 60;
            }
        }
        return 30;
    }

    public String getBookmark(ITopic topic) {
        String bookmark;
        if (this.bookmarks == null) {
            this.bookmarks = new HashMap<ITopic, String>();
        }
        if ((bookmark = this.bookmarks.get(topic)) == null) {
            bookmark = this.createBookmark(topic);
            this.bookmarks.put(topic, bookmark);
        }
        return bookmark;
    }

    protected String createBookmark(ITopic topic) {
        String title = topic.hasTitle() ? topic.getTitleText() : "";
        String bookmark = UNDERLINE + title;
        String numbering = ExportUtils.getNumberingText((ITopic)topic, (ITopic)this.getCentralTopic());
        if (numbering != null) {
            bookmark = UNDERLINE + numbering + bookmark;
        }
        bookmark = bookmark.replaceAll("\\W", UNDERLINE);
        if (this.bookmarks != null) {
            int suffix = 1;
            boolean available = false;
            String check = bookmark;
            block0: while (!available) {
                available = true;
                for (String s : this.bookmarks.values()) {
                    if (!s.equals(check)) continue;
                    check = String.valueOf(bookmark) + UNDERLINE + ++suffix;
                    available = false;
                    continue block0;
                }
            }
            bookmark = check;
        }
        return bookmark;
    }

    public String getAttPath(String entryPath) {
        String path;
        if (this.tempPaths == null) {
            this.tempPaths = new HashMap<String, String>();
        }
        if ((path = this.tempPaths.get(entryPath)) == null) {
            path = this.createAttPath(entryPath);
            this.tempPaths.put(entryPath, path);
        }
        return path;
    }

    private String createAttPath(String entryPath) {
        File tempFile;
        InputStream is;
        IFileEntry entry = this.getFileEntry(entryPath);
        if (entry != null && (is = entry.getInputStream()) != null && (tempFile = this.getScriptFile(entryPath)) != null) {
            try {
                FileOutputStream os = new FileOutputStream(tempFile);
                FileUtils.transfer((InputStream)is, (OutputStream)os, (boolean)true);
                return tempFile.getAbsolutePath();
            }
            catch (IOException e) {
                String message = NLS.bind((String)Message_FailedToCopyAttachment, (Object)entryPath);
                this.log(e, message);
            }
        }
        return null;
    }

    private File getScriptFile(String pathName) {
        return FileUtils.ensureFileParent((File)new File(this.getScriptDir(), pathName));
    }

    public File getScriptDir() {
        if (this.scriptDir == null) {
            this.scriptDir = this.createScriptDir();
        }
        return this.scriptDir;
    }

    private File createScriptDir() {
        String path = this.getString("saveScriptPath", null);
        if (path != null) {
            File dir = new File(path);
            FileUtils.ensureDirectory((File)dir);
            return dir;
        }
        String id = String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS", System.currentTimeMillis());
        return FileUtils.ensureDirectory((File)WordExporter.getTempPath(id));
    }

    private static File getTempPath(String pathName) {
        return new File(Core.getWorkspace().getTempDir(TEMP_PATH), pathName);
    }

    public BufferedImage convertToAWT(ImageData data) {
        ColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            colorModel = new DirectColorModel(data.depth, palette.redMask, palette.greenMask, palette.blueMask);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    bufferedImage.setRGB(x, y, rgb.red << 16 | rgb.green << 8 | rgb.blue);
                    ++x;
                }
                ++y;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }

    public String createOverviewPath(ITopic topic, ImageFormat format) {
        File file = new File(this.getScriptDir(), "images/" + topic.getId() + (String)format.getExtensions().get(0));
        FileUtils.ensureFileParent((File)file);
        final MindMapImageExporter exporter = this.createOverviewExporter(topic);
        exporter.setTargetFile(file);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                exporter.export();
            }
        });
        return file.getAbsolutePath();
    }

    protected static String trim(String text) {
        return text.replaceAll("\"", "\"\"");
    }

    protected static String[] getMultiLines(String text) {
        String[] lines = text.split("\\r\\n|\\r|\\n");
        return lines;
    }

    private CustomDocumentProperties getDocumentProperties() {
        return this.builder.getDocument().getCustomDocumentProperties();
    }

    private void writeDocumentProperties(ISheet sheet) {
        CustomDocumentProperties properties = this.getDocumentProperties();
        String theme = sheet.getThemeId();
        if (theme != null) {
            properties.add("theme", theme);
        }
        if (floatingTopicPositions != null) {
            this.writeFloatingTopicPosition(properties, floatingTopicPositions);
        }
    }

    private void writeFloatingTopicPosition(CustomDocumentProperties properties, Map<String, String> floatingTopicPositions) {
        block0: for (Map.Entry<String, String> position : floatingTopicPositions.entrySet()) {
            if (!properties.contains(position.getKey())) {
                properties.add(position.getKey(), position.getValue());
                continue;
            }
            int i = 1;
            while (i < 20) {
                if (!properties.contains(String.valueOf(position.getKey()) + i)) {
                    properties.add(String.valueOf(position.getKey()) + i, position.getValue());
                    continue block0;
                }
                ++i;
            }
        }
    }

    private void writeTableOfContent() {
        if (this.getCentralTopic().getAllChildren().size() == 0) {
            return;
        }
        int contentLevel = this.getContentLevel();
        this.builder.moveToDocumentStart();
        this.builder.moveTo((Node)this.builder.getCurrentParagraph());
        Paragraph contentPara = (Paragraph)this.builder.getCurrentParagraph().getNextSibling();
        this.builder.insertTableOfContents("\\o \"1-" + contentLevel + "\" \\h \\z \\u");
        if (contentPara != null) {
            this.builder.moveTo(contentPara.getPreviousSibling());
            this.builder.insertBreak(5);
            contentPara.getPreviousSibling().remove();
        }
        try {
            this.builder.getDocument().updateFields();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getContentLevel() {
        String contentLevelStr = this.settings.get(CONTENT_LEVEL);
        if (contentLevelStr != null) {
            return Content.valueOf(contentLevelStr).getValue();
        }
        return Content.Level3.getValue();
    }

    private int getNumberLevel() {
        String numberLevelStr = this.settings.get(NUMBER_LEVEL);
        if (numberLevelStr != null) {
            return NumberLevel.valueOf(numberLevelStr).getValue();
        }
        return NumberLevel.Level3.getValue();
    }

    private void writePageNumber() {
        this.builder.moveToSection(0);
        this.builder.moveToHeaderFooter(3);
        try {
            this.builder.insertField("PAGE");
            this.builder.getParagraphFormat().setAlignment(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PageSetup pageSetup = this.builder.getCurrentSection().getPageSetup();
        pageSetup.setRestartPageNumbering(true);
        pageSetup.setPageStartingNumber(1);
    }

    private String cacheFile(String hyperlink, Object path) {
        if (this.files == null) {
            this.files = new HashMap<String, Object>();
        }
        this.files.put(hyperlink, path);
        return path == NULL ? null : (String)path;
    }

    public String getFilesPath() {
        if (this.filesPath == null) {
            this.filesPath = this.createFilesPath();
        }
        return this.filesPath;
    }

    private String createFilesPath() {
        File f = new File(this.getTargetPath());
        String name = f.getName();
        String parent = f.getParent();
        int index = name.lastIndexOf(46);
        name = index >= 0 ? String.valueOf(name.substring(0, index)) + FILES : String.valueOf(name) + FILES;
        return new File(parent, name).getAbsolutePath();
    }

    private String getTargetPath() {
        return this.targetPath;
    }

    private String newPath(String parent, String name, String ext) {
        File f = new File(parent, String.valueOf(name) + ext);
        int i = 1;
        while (f.exists()) {
            String newName = String.valueOf(name) + " " + ++i;
            f = new File(parent, String.valueOf(newName) + ext);
        }
        return f.getAbsolutePath();
    }

    private String getRelativeFilesPath() {
        if (this.relativeFilesPath == null) {
            this.relativeFilesPath = new File(this.getFilesPath()).getName();
        }
        return this.relativeFilesPath;
    }

    private String connectPath(String parent, String child) {
        return String.valueOf(parent) + "/" + child;
    }

    private String createFilePath(String hyperlink, String suggestedName) {
        Object cache;
        Object object = cache = this.files == null ? null : this.files.get(hyperlink);
        if (cache == NULL) {
            return null;
        }
        if (cache instanceof String) {
            return (String)cache;
        }
        String entryPath = HyperlinkUtils.toAttachmentPath((String)hyperlink);
        IFileEntry entry = this.getFileEntry(entryPath);
        if (entry == null) {
            return this.cacheFile(hyperlink, NULL);
        }
        if (suggestedName == null) {
            suggestedName = FileUtils.getFileName((String)entryPath);
        }
        String name = FileUtils.getNoExtensionFileName((String)suggestedName);
        String ext = FileUtils.getExtension((String)suggestedName);
        String path = this.newPath(this.getFilesPath(), name, ext);
        InputStream in = entry.getInputStream();
        if (in != null) {
            FileUtils.ensureFileParent((File)new File(path));
            try {
                FileUtils.transfer((InputStream)in, (OutputStream)new FileOutputStream(path), (boolean)true);
            }
            catch (IOException e) {
                String message = NLS.bind((String)Message_FailedToCopyAttachment, (Object)suggestedName);
                this.log(e, message);
            }
        }
        String fileName = new File(path).getName();
        String relativePath = this.connectPath(this.getRelativeFilesPath(), fileName);
        return this.cacheFile(hyperlink, relativePath);
    }

    private void setNumberingStatus(ITopic topic) {
        if (hasNumbering || topic == null) {
            return;
        }
        String numbering = ExportUtils.getNumberingText((ITopic)topic, (ITopic)this.getCentralTopic());
        if (numbering != null) {
            hasNumbering = true;
        }
    }

    public IGraphicalEditor getSourceEditor() {
        return this.sourceEditor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Content {
        Level1(1, ExportMessages.DocumentPage_ContentLevel1),
        Level2(2, ExportMessages.DocumentPage_ContentLevel2),
        Level3(3, ExportMessages.DocumentPage_ContentLevel3),
        Level4(4, ExportMessages.DocumentPage_ContentLevel4),
        Level5(5, ExportMessages.DocumentPage_ContentLevel5),
        Level6(6, ExportMessages.DocumentPage_ContentLevel6),
        Level7(7, ExportMessages.DocumentPage_ContentLevel7),
        Level8(8, ExportMessages.DocumentPage_ContentLevel8),
        Level9(9, ExportMessages.DocumentPage_ContentLevel9);

        private int value;
        private String description;

        private Content(int value, String description) {
            this.value = value;
            this.description = description;
        }

        public int getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }

        public static String[] getDescriptions() {
            Content[] sizes = Content.values();
            String[] descriptions = new String[sizes.length];
            int i = 0;
            while (i < sizes.length) {
                descriptions[i] = sizes[i].getDescription();
                ++i;
            }
            return descriptions;
        }
    }

    private static class ImagePart
    extends WordExportPart {
        public ImagePart(WordExporter exporter, IImage image) {
            super(exporter, image);
        }

        protected void write() {
            this.startParagraph();
            String source = ((IImage)this.getElement()).getSource();
            if (source != null && HyperlinkUtils.isAttachmentURL((String)source)) {
                String entryPath = HyperlinkUtils.toAttachmentPath((String)source);
                String path = this.getExporter().getAttPath(entryPath);
                if (path != null) {
                    this.setLeftIndent(0.0);
                    Shape img = this.picture(path);
                    if (img == null) {
                        return;
                    }
                    img.getImageData().setTitle("image");
                }
            }
        }
    }

    private static class NotesPart
    extends WordExportPart {
        private static final int COLOR_AUTOMATIC = -16777216;
        private static final int BACKGROUND_COLOR_AUTOMATIC = 0xFFFFFF;
        private static final int DEFAULT_FONT_SIZE = 9;

        public NotesPart(WordExporter exporter, INotesContent content) {
            super(exporter, content);
        }

        protected void write() {
            this.startParagraph();
            INotesContent content = (INotesContent)this.getElement();
            String format = content.getFormat();
            if ("plain".equals(format)) {
                this.writePlainNotes((IPlainNotesContent)content);
            } else {
                this.writeRichNotes((IHtmlNotesContent)content);
            }
        }

        private void writePlainNotes(IPlainNotesContent content) {
            String textContent = content.getTextContent();
            if (textContent != null) {
                this.multiLines(textContent);
            }
        }

        private void writeRichNotes(IHtmlNotesContent content) {
            for (IParagraph p : content.getParagraphs()) {
                this.builder.insertBreak(0);
                this.writeParagraph(p);
            }
        }

        private void writeParagraph(IParagraph p) {
            for (ISpan span : p.getSpans()) {
                if (span instanceof IImageSpan) {
                    this.writeImageSpan((IImageSpan)span);
                    continue;
                }
                if (span instanceof ITextSpan) {
                    this.writeTextSpan((ITextSpan)span);
                    continue;
                }
                if (!(span instanceof IHyperlinkSpan)) continue;
                List spans = ((IHyperlinkSpan)span).getSpans();
                String href = ((IHyperlinkSpan)span).getHref();
                for (ISpan s : spans) {
                    if (span instanceof IImageSpan) {
                        this.writeImageSpan((IImageSpan)s);
                        continue;
                    }
                    IStyle hyperlinkStyle = this.getExporter().getStyle(s.getStyleId());
                    this.setHyperLink(((ITextSpan)s).getTextContent(), href, false, s.getOwnedWorkbook(), this.getFontSize(hyperlinkStyle));
                }
            }
            this.align(this.getAlignment(p));
        }

        private void writeImageSpan(IImageSpan span) {
            String source = span.getSource();
            if (source != null && HyperlinkUtils.isAttachmentURL((String)source)) {
                String entryPath = HyperlinkUtils.toAttachmentPath((String)source);
                String attPath = this.getExporter().getAttPath(entryPath);
                if (attPath != null) {
                    Shape img = this.picture(attPath);
                    if (img == null) {
                        return;
                    }
                    img.getImageData().setTitle("noteImage");
                }
            }
        }

        private void writeTextSpan(ITextSpan span) {
            Pattern pattern = Pattern.compile("\\b(https?|ftp|mailto|svn|irc|gopher|telnet|nntp|worldwind|news):(?:/{1,3})([\\w-]+\\.)+[\\w-]+[\\w-._/\\~%-+&#?!=()@:]*");
            Matcher matcher = pattern.matcher(span.getTextContent());
            ArrayList<int[]> urlParts = new ArrayList<int[]>();
            while (matcher.find()) {
                urlParts.add(new int[]{matcher.start(), matcher.end()});
            }
            int count = urlParts.size();
            String content = span.getTextContent();
            IStyle style = this.getExporter().getStyle(span.getStyleId());
            this.writeTextStyle(style);
            if (count == 0) {
                this.multiNoteText(content);
            }
            int index = 0;
            while (index < count) {
                int urlStart = ((int[])urlParts.get(index))[0];
                int urlEnd = ((int[])urlParts.get(index))[1];
                this.multiLines(content.substring(index == 0 ? 0 : ((int[])urlParts.get(index - 1))[1], urlStart));
                this.setHyperLink(content.substring(urlStart, urlEnd), content.substring(urlStart, urlEnd), false, span.getOwnedWorkbook(), this.getFontSize(style));
                if (index == count - 1 && urlEnd < content.length() - 1) {
                    this.multiLines(content.substring(urlEnd, content.length() - 1));
                }
                ++index;
            }
            this.clearFontFormat();
        }

        private void multiNoteText(String text) {
            String[] lines = WordExporter.getMultiLines(text);
            int i = 0;
            while (i < lines.length) {
                this.print(lines[i]);
                ++i;
            }
        }

        private void writeTextStyle(IStyle style) {
            Font font = this.builder.getFont();
            String fontName = style == null ? null : style.getProperty("fo:font-family");
            String availableFontName = FontUtils.getAAvailableFontNameFor((String)fontName);
            String string = fontName = availableFontName != null ? availableFontName : fontName;
            if (fontName != null) {
                font.setName(fontName);
            }
            font.setSize(this.getFontSize(style));
            font.setBold(this.getBold(style));
            font.setItalic(this.getItalic(style));
            font.setStrikeThrough(this.getStrikeThrough(style));
            font.setUnderline(this.getUnderline(style) ? 1 : 0);
            if (style == null) {
                return;
            }
            int color = this.getColor(style, "fo:color");
            int bgColor = this.getColor(style, "fo:background-color");
            font.setColor(new Color(color));
            font.getShading().setBackgroundPatternColor(new Color(bgColor));
        }

        private double getFontSize(IStyle style) {
            String fontSize;
            String string = fontSize = style == null ? null : style.getProperty("fo:font-size");
            if (fontSize != null) {
                fontSize = StyleUtils.trimNumber((String)fontSize);
                return Integer.parseInt(fontSize);
            }
            return 9.0;
        }

        private boolean getBold(IStyle style) {
            if (style == null) {
                return false;
            }
            String fontWeight = style.getProperty("fo:font-weight");
            return fontWeight != null && fontWeight.contains("bold");
        }

        private boolean getItalic(IStyle style) {
            if (style == null) {
                return false;
            }
            String fontStyle = style.getProperty("fo:font-style");
            return fontStyle != null && fontStyle.contains("italic");
        }

        private boolean getUnderline(IStyle style) {
            if (style == null) {
                return false;
            }
            String textDecoration = style.getProperty("fo:text-decoration");
            return textDecoration != null && textDecoration.contains("underline");
        }

        private boolean getStrikeThrough(IStyle style) {
            if (style == null) {
                return false;
            }
            String textDecoration = style.getProperty("fo:text-decoration");
            return textDecoration != null && textDecoration.contains("line-through");
        }

        private int getColor(IStyle style, String key) {
            String textColor;
            if (style != null && (textColor = style.getProperty(key)) != null) {
                if (textColor.startsWith("#")) {
                    textColor = textColor.substring(1);
                }
                if (textColor.length() == 6) {
                    try {
                        int value = Integer.parseInt(textColor, 16);
                        int r = value >> 16 & 0xFF;
                        int g = value >> 8 & 0xFF;
                        int b = value & 0xFF;
                        return r << 16 | g << 8 | b;
                    }
                    catch (Throwable throwable) {}
                }
            }
            if ("fo:color".equals(key)) {
                return -16777216;
            }
            return 0xFFFFFF;
        }

        private int getAlignment(IParagraph p) {
            IStyle style;
            String styleId = p.getStyleId();
            if (styleId != null && (style = this.getExporter().getStyle(styleId)) != null) {
                String value = style.getProperty("fo:text-align");
                if ("center".equals(value)) {
                    return 1;
                }
                if ("right".equals(value)) {
                    return 2;
                }
            }
            return 3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NumberLevel {
        Level1(1, ExportMessages.DocumentPage_NumberLevel1),
        Level2(2, ExportMessages.DocumentPage_NumberLevel2),
        Level3(3, ExportMessages.DocumentPage_NumberLevel3),
        Level4(4, ExportMessages.DocumentPage_NumberLevel4),
        Level5(5, ExportMessages.DocumentPage_NumberLevel5),
        Level6(6, ExportMessages.DocumentPage_NumberLevel6),
        Level7(7, ExportMessages.DocumentPage_NumberLevel7),
        Level8(8, ExportMessages.DocumentPage_NumberLevel8),
        Level9(9, ExportMessages.DocumentPage_NumberLevel9);

        private int value;
        private String description;

        private NumberLevel(int value, String description) {
            this.value = value;
            this.description = description;
        }

        public int getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }

        public static String[] getDescriptions() {
            NumberLevel[] sizes = NumberLevel.values();
            String[] descriptions = new String[sizes.length];
            int i = 0;
            while (i < sizes.length) {
                descriptions[i] = sizes[i].getDescription();
                ++i;
            }
            return descriptions;
        }
    }

    private static class OverviewPart
    extends WordExportPart {
        private static final ImageFormat FORMAT = ImageFormat.PNG;

        public OverviewPart(WordExporter exporter, ITopic topic) {
            super(exporter, topic);
        }

        protected void write() {
            this.startParagraph();
            ITopic topic = (ITopic)this.getElement();
            String path = this.getExporter().createOverviewPath(topic, FORMAT);
            if (path != null) {
                if (this.isCentralTopic((ITopic)this.getElement())) {
                    this.align(1);
                }
                this.setLeftIndent(0.0);
                Shape img = this.picture(path);
                if (img == null) {
                    return;
                }
                img.getImageData().setTitle("overview");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RelationshipsPart
    extends WordExportPart {
        private List<RelationshipDescription> relDess;
        private List<IRelationship> rels;
        private final int END1 = 1;
        private final int END2 = 2;
        private ITopic topic;
        private static int bookmarkIndex = 0;

        public RelationshipsPart(WordExporter exporter, ITopic topic, List<RelationshipDescription> relationshipDescriptions, List<IRelationship> relationships) {
            super(exporter, topic);
            this.topic = topic;
            this.relDess = relationshipDescriptions;
            this.rels = relationships;
        }

        @Override
        protected void write() {
            this.startParagraph();
            this.align(this.getAlign(this.topic));
            this.text(SEE_ALSO, true, false, false, false);
            this.print(" ");
            Iterator<RelationshipDescription> it = this.relDess.iterator();
            while (it.hasNext()) {
                RelationshipDescription r = it.next();
                if (!(r.target instanceof ITopic)) continue;
                ITopic source = (ITopic)r.source;
                ITopic target = (ITopic)r.target;
                String bookmark = this.getExporter().getBookmark(target);
                int relationshipType = this.getRelationshipType(source, target);
                this.setBookmark(this.getHyperlinkBookmark(WordExporter.trim(bookmark.trim()), relationshipType));
                if (bookmark == null) continue;
                this.setHyperLink(r.description, bookmark, true, target.getOwnedWorkbook());
                if (!it.hasNext()) continue;
                this.print(", ");
            }
        }

        private int getAlign(ITopic topic) {
            if (this.isCentralTopic(topic)) {
                return 1;
            }
            return 0;
        }

        private int getRelationshipType(ITopic source, ITopic target) {
            String sourceId = source.getId();
            String targetId = target.getId();
            for (IRelationship r : this.rels) {
                String end1Id = r.getEnd1Id();
                String end2Id = r.getEnd2Id();
                if (sourceId.equals(end1Id) && targetId.equals(end2Id)) {
                    return 1;
                }
                if (!sourceId.equals(end2Id) || !targetId.equals(end1Id)) continue;
                return 2;
            }
            return 0;
        }

        private String getHyperlinkBookmark(String bookmark, int relationshipType) {
            ++bookmarkIndex;
            if (relationshipType == 1) {
                return "_to" + bookmark + "," + bookmarkIndex;
            }
            if (relationshipType == 2) {
                return "_from" + bookmark + "," + bookmarkIndex;
            }
            return bookmark;
        }
    }

    private static class SummaryPart
    extends WordExportPart {
        public SummaryPart(WordExporter exporter, ISummary summary) {
            super(exporter, summary);
        }

        protected void write() {
            this.print("(");
            ISummary summary = (ISummary)this.getElement();
            List topics = summary.getEnclosingTopics();
            Iterator it = topics.iterator();
            while (it.hasNext()) {
                ITopic topic = (ITopic)it.next();
                String bookmark = this.getExporter().getBookmark(topic);
                if (bookmark == null) continue;
                this.setHyperLink(topic.getTitleText(), WordExporter.trim(bookmark), true, topic.getOwnedWorkbook());
                if (!it.hasNext()) continue;
                this.print(", ");
            }
            this.print(")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TagsPart
    extends WordExportPart {
        private Set<IMarkerRef> markers;
        private Set<String> labels;

        public TagsPart(WordExporter exporter, ITopic topic, Set<IMarkerRef> markers, Set<String> labels) {
            super(exporter, topic);
            this.markers = markers;
            this.labels = labels;
        }

        @Override
        protected void write() {
            Iterator<Object> it;
            boolean hasLabel;
            this.startParagraph();
            if (this.isCentralTopic((ITopic)this.getElement())) {
                this.align(1);
            }
            boolean hasMarker = false;
            boolean bl = hasLabel = this.labels != null;
            if (this.markers != null) {
                it = this.markers.iterator();
                while (it.hasNext()) {
                    IMarkerRef m = (IMarkerRef)it.next();
                    IMarker marker = m.getMarker();
                    if (marker == null) continue;
                    hasMarker = true;
                    ImageDescriptor markerDescriptor = MarkerImageDescriptor.createFromMarker((IMarker)marker, (int)(Util.isMac() ? 32 : 16), (int)(Util.isMac() ? 32 : 16), (boolean)false);
                    try {
                        Shape insertImage = this.builder.insertImage(this.getExporter().convertToAWT(markerDescriptor.getImageData()), 16.0, 16.0);
                        insertImage.getImageData().setTitle("marker" + m.getMarkerId());
                        if (!it.hasNext()) continue;
                        this.print(" ");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (hasMarker && hasLabel) {
                this.print(" ");
            }
            if (hasLabel) {
                it = this.labels.iterator();
                while (it.hasNext()) {
                    String label = (String)it.next();
                    this.print(WordExporter.trim(label));
                    if (!it.hasNext()) continue;
                    this.print(", ");
                }
            }
        }
    }

    private static class TitlePart
    extends WordExportPart {
        private int level;

        public TitlePart(WordExporter exporter, ITopic element, int level) {
            super(exporter, element);
            this.level = level;
        }

        protected void write() {
            if (this.level == 0) {
                this.align(1);
            } else {
                this.endParagraph();
                this.align(0);
            }
            ITopic topic = (ITopic)this.getElement();
            String title = topic.getTitleText();
            String numbering = ExportUtils.getNumberingText((ITopic)topic, (ITopic)this.getExporter().getCentralTopic());
            if (this.level <= this.getExporter().getNumberLevel() && numbering != null) {
                title = String.valueOf(numbering) + " " + title;
            }
            this.style(this.getStyle(), this.isExtraTopic(topic, this.level));
            String bookmark = this.getExporter().getBookmark(topic);
            this.setBookmark(WordExporter.trim(bookmark));
            String hyperlink = topic.getHyperlink();
            if (hyperlink != null) {
                String string = title = "".equals(title) ? " " : title;
                if (HyperlinkUtils.isAttachmentURL((String)hyperlink) && this.getExporter().getBoolean("includeAttachment")) {
                    hyperlink = this.getExporter().createFilePath(hyperlink, topic.getTitleText());
                    this.setHyperLink(title, WordExporter.trim(hyperlink), false, topic.getOwnedWorkbook());
                } else if (!HyperlinkUtils.isAttachmentURL((String)hyperlink) && this.getExporter().getBoolean("includeHyperlink")) {
                    this.setHyperLink(title, WordExporter.trim(hyperlink), false, topic.getOwnedWorkbook());
                } else {
                    this.multiLines(title);
                }
            } else {
                this.multiLines(title);
            }
            this.writeFloatingTopicPosition(topic);
        }

        private int getStyle() {
            return this.getDeafultStyle((ITopic)this.getElement(), this.level);
        }

        private int getDeafultStyle(ITopic topic, int level) {
            switch (level) {
                case 0: {
                    return 62;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
                case 6: {
                    return 6;
                }
                case 7: {
                    return 7;
                }
                case 8: {
                    return 8;
                }
            }
            return 9;
        }

        private boolean isExtraTopic(ITopic topic, int level) {
            boolean isFloatingTopic = topic.getType().equals("detached");
            boolean isSummary = topic.getType().equals("summary");
            ITopic parent = topic;
            int i = 1;
            while (i < level) {
                parent = parent.getParent();
                ++i;
            }
            boolean isParentFloatingTopic = parent.getType().equals("detached");
            return isFloatingTopic || isSummary || isParentFloatingTopic;
        }

        private void writeFloatingTopicPosition(ITopic topic) {
            if (!topic.getType().equals("detached")) {
                return;
            }
            String topicTitle = topic.getTitleText();
            if (topic.getPosition() == null) {
                return;
            }
            String topicPosition = topic.getPosition().toString();
            if (topicTitle.equals("") || topicPosition.equals("")) {
                return;
            }
            if (floatingTopicPositions == null) {
                floatingTopicPositions = new HashMap();
            }
            floatingTopicPositions.put(topicTitle, topicPosition);
        }
    }

    protected static abstract class WordExportPart
    extends ExportPart {
        protected DocumentBuilder builder;
        protected com.aspose.words.List listFormat;
        private static int lastHeadingStyle;
        protected static final float DEFAULT_DPI = 96.0f;

        public WordExportPart(WordExporter exporter, Object element) {
            super((IExporter)exporter, element);
        }

        public WordExporter getExporter() {
            return (WordExporter)super.getExporter();
        }

        public void write(DocumentBuilder builder, com.aspose.words.List listFormat) {
            this.builder = builder;
            this.listFormat = listFormat;
            this.write();
        }

        protected abstract void write();

        protected void startParagraph() {
            this.builder.writeln();
            this.style(0);
        }

        protected void endParagraph() {
            this.builder.writeln();
        }

        protected void align(int alignment) {
            this.builder.getParagraphFormat().setAlignment(alignment);
        }

        protected void style(int style) {
            this.style(style, false);
        }

        protected void style(int style, boolean isExtraTopic) {
            ParagraphFormat paraFormat = this.builder.getParagraphFormat();
            paraFormat.setStyleIdentifier(style);
            if (!hasNumbering) {
                if (paraFormat.isHeading() && !isExtraTopic) {
                    lastHeadingStyle = style;
                    this.startListFormat(this.listFormat, style - 1);
                    paraFormat.setKeepWithNext(false);
                } else {
                    this.endListFormat();
                }
            }
            this.clearTabStop();
            if (style != 62 && style != 0) {
                this.setLeftIndent((style - 1) * 10);
            } else if (style == 0) {
                this.setLeftIndent((lastHeadingStyle - 1) * 10);
            }
            this.setFontStyle(style);
        }

        protected void multiLines(String text) {
            String[] lines = WordExporter.getMultiLines(text);
            int i = 0;
            while (i < lines.length) {
                this.print(lines[i]);
                if (i < lines.length - 1) {
                    this.builder.insertBreak(8);
                }
                ++i;
            }
        }

        protected void print(String text) {
            this.builder.write(text);
        }

        protected void text(String text, boolean bold, boolean italic, boolean underline, boolean strikeout) {
            Font font = this.builder.getFont();
            font.setBold(bold);
            font.setItalic(italic);
            font.setUnderline(underline ? 1 : 0);
            font.setStrikeThrough(strikeout);
            this.builder.write(text);
            this.clearFontFormat();
        }

        protected Shape picture(String imgPath) {
            Shape shape = this.picture(imgPath, -1, -1);
            if (shape == null) {
                return null;
            }
            try {
                float scale;
                float imageDPI = this.getImageDPI(shape);
                double imageWidth = this.getImageWidth(shape, imageDPI);
                double imageHeight = this.getImageHeight(shape, imageDPI);
                double pageWidth = this.getPageWidth();
                double pageHeight = this.getPageHeight();
                if (imageWidth > pageWidth) {
                    scale = (float)(pageWidth / imageWidth);
                    shape.setWidth(imageWidth *= (double)scale);
                    shape.setHeight(imageHeight *= (double)scale);
                }
                if (imageHeight > pageHeight) {
                    scale = (float)(pageHeight / imageHeight);
                    shape.setWidth(imageWidth * (double)scale);
                    shape.setHeight(imageHeight * (double)scale);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return shape;
        }

        protected Shape picture(String imgPath, int width, int height) {
            try {
                String path = this.imageFormat(imgPath);
                return this.builder.insertImage(path, (double)width, (double)height);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        protected String imageFormat(String imgPath) {
            int index = imgPath.lastIndexOf(46);
            if (".ico".equals(imgPath.substring(index, imgPath.length()))) {
                String path = String.valueOf(imgPath.substring(0, index)) + ".png";
                try {
                    File fi = new File(imgPath);
                    File fo = new File(path);
                    List images = ICODecoder.read((File)fi);
                    BufferedImage image = (BufferedImage)images.get(0);
                    ImageIO.write((RenderedImage)image, "png", fo);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return path;
            }
            return imgPath;
        }

        protected void setBookmark(String bookmarkName) {
            this.builder.startBookmark(bookmarkName);
            this.builder.endBookmark(bookmarkName);
        }

        protected void setHyperLink(String displayText, String urlOrBookmark, boolean isBookmark, IWorkbook workbook) {
            this.setHyperLink(displayText, urlOrBookmark, isBookmark, workbook, 0.0);
        }

        protected void setHyperLink(String displayText, String urlOrBookmark, boolean isBookmark, IWorkbook workbook, double fontSize) {
            boolean isLinkToTopic = urlOrBookmark.contains("xmind:");
            if (isLinkToTopic) {
                if ((urlOrBookmark = this.getLinkToTopicURI(urlOrBookmark, workbook)) == null) {
                    this.multiLines(displayText);
                    return;
                }
                isBookmark = true;
            }
            if (this.isLinkToWeb(urlOrBookmark) && !urlOrBookmark.contains("http://") && !urlOrBookmark.contains("https://")) {
                urlOrBookmark = "http://" + urlOrBookmark;
            }
            this.builder.pushFont();
            this.builder.getFont().setStyleIdentifier(85);
            if (fontSize > 0.0) {
                this.builder.getFont().setSize(fontSize);
            }
            if (urlOrBookmark.startsWith("file:")) {
                this.builder.insertHyperlink(displayText, this.relativeToAbsolute(urlOrBookmark), isBookmark);
            } else {
                this.builder.insertHyperlink(displayText, urlOrBookmark, isBookmark);
            }
            this.builder.popFont();
        }

        private String relativeToAbsolute(String fileLink) {
            WordExporter exporter;
            IWorkbook workbook;
            String path = FilePathParser.toPath((String)fileLink);
            if (FilePathParser.isPathRelative((String)path) && (workbook = (exporter = this.getExporter()).getCentralTopic().getOwnedWorkbook()) != null) {
                String base;
                File file;
                IGraphicalEditor sourceEditor = exporter.getSourceEditor();
                if (sourceEditor != null && (file = MME.getFile((Object)sourceEditor.getEditorInput())) != null && (base = file.getAbsolutePath()) != null && (base = new File(base).getParent()) != null) {
                    return "file:" + FilePathParser.toAbsolutePath((String)base, (String)path);
                }
                return "file:" + FilePathParser.toAbsolutePath((String)FilePathParser.ABSTRACT_FILE_BASE, (String)path);
            }
            return "file:" + FilePathParser.toAbsolutePath((String)"", (String)path);
        }

        private boolean isLinkToWeb(String urlOrBookmark) {
            return urlOrBookmark.contains("www.") || urlOrBookmark.contains(".com") || urlOrBookmark.contains(".cn") || urlOrBookmark.contains(".org") || urlOrBookmark.contains(".cc") || urlOrBookmark.contains(".net");
        }

        protected String getLinkToTopicURI(String urlOrBookmark, IWorkbook workbook) {
            String topicId = urlOrBookmark.substring(urlOrBookmark.indexOf("#") + 1);
            ITopic topic = (ITopic)workbook.getElementById(topicId);
            return topic == null ? null : this.getExporter().getBookmark(topic);
        }

        protected void clearFontFormat() {
            this.builder.getFont().clearFormatting();
        }

        protected float getImageDPI(Shape shape) throws Exception {
            return (float)shape.getImageData().getImageSize().getHorizontalResolution();
        }

        protected double getImageWidth(Shape shape, float imageDPI) {
            return Math.round(shape.getWidth() * (double)imageDPI / 96.0);
        }

        protected double getImageHeight(Shape shape, float imageDPI) {
            return Math.round(shape.getHeight() * (double)imageDPI / 96.0);
        }

        protected double getPageWidth() throws Exception {
            PageSetup pageSetup = this.builder.getPageSetup();
            return pageSetup.getPageWidth() - pageSetup.getLeftMargin() - pageSetup.getRightMargin();
        }

        protected double getPageHeight() throws Exception {
            PageSetup pageSetup = this.builder.getPageSetup();
            return pageSetup.getPageHeight() - pageSetup.getTopMargin() - pageSetup.getBottomMargin();
        }

        protected void startListFormat(com.aspose.words.List listFormat, int level) {
            int numberLevel = this.getExporter().getNumberLevel();
            this.builder.getListFormat().setList(listFormat);
            this.builder.getListFormat().setListLevelNumber(level);
            this.builder.getListFormat().getListLevel().setTabPosition(0.0);
            this.setListFormatStyle(this.builder.getListFormat().getListLevel().getFont(), level);
            if (level >= numberLevel) {
                this.builder.getListFormat().removeNumbers();
            }
        }

        private void setListFormatStyle(Font font, int level) {
            font.setName("Calibri");
            if (++level == 1) {
                font.setSize(14.0);
            } else {
                this.builder.getListFormat().getListLevel().getFont().setSize(12.0);
            }
            this.builder.getListFormat().getListLevel().getFont().setItalic(false);
        }

        protected void endListFormat() {
            this.builder.getListFormat().removeNumbers();
        }

        protected void clearTabStop() {
            ParagraphFormat paraFormat = this.builder.getParagraphFormat();
            paraFormat.setFirstLineIndent(0.0);
            paraFormat.getTabStops().clear();
            paraFormat.getTabStops().add(new TabStop(0.0, 7, 0));
        }

        protected void setLeftIndent(double leftIndent) {
            this.builder.getParagraphFormat().setLeftIndent(leftIndent);
        }

        protected double getLeftIndent() {
            return this.builder.getParagraphFormat().getLeftIndent();
        }

        protected void setFontStyle(int style) {
            this.builder.getFont().setName("Calibri");
            if (style == 62) {
                this.builder.getFont().setSize(16.0);
            } else if (style == 1) {
                this.builder.getFont().setSize(14.0);
            } else {
                this.builder.getFont().setSize(12.0);
            }
            this.builder.getFont().setItalic(false);
            this.builder.getParagraphFormat().setLineSpacing(17.0);
        }
    }
}

