/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.geometry;

import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionPointPair;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;

public abstract class PrecisionPointPairBase {
    protected PrecisionPoint point1 = new PrecisionPoint();
    protected PrecisionPoint point2 = new PrecisionPoint();

    public PrecisionPointPairBase() {
    }

    public PrecisionPointPairBase(PrecisionPoint point1, PrecisionPoint point2) {
        this(point1.x, point1.y, point2.x, point2.y);
    }

    public PrecisionPointPairBase(double x1, double y1, double x2, double y2) {
        this.point1.setLocation(x1, y1);
        this.point2.setLocation(x2, y2);
    }

    public PrecisionRectangle getBounds() {
        return new PrecisionRectangle(this.point1, this.point2);
    }

    public PrecisionPoint getCenter() {
        return this.point1.getCenter(this.point2);
    }

    public void translate(double dx, double dy) {
        this.translateFirstPoint(dx, dy);
        this.translateSecondPoint(dx, dy);
    }

    public void translate(double dx1, double dy1, double dx2, double dy2) {
        this.translateFirstPoint(dx1, dy1);
        this.translateSecondPoint(dx2, dy2);
    }

    public void translate(PrecisionDimension offset) {
        this.translate(offset.width, offset.height);
    }

    public void translate(PrecisionDimension originOffset, PrecisionDimension terminusOffset) {
        this.translate(originOffset.width, originOffset.height, terminusOffset.width, terminusOffset.height);
    }

    public void translateFirstPoint(double dx, double dy) {
        this.point1.translate(dx, dy);
    }

    public void translateFirstPoint(PrecisionDimension offset) {
        this.translateFirstPoint(offset.width, offset.height);
    }

    public void translateSecondPoint(double dx, double dy) {
        this.point2.translate(dx, dy);
    }

    public void translateSecondPoint(PrecisionDimension offset) {
        this.translateSecondPoint(offset.width, offset.height);
    }

    public PrecisionPointPairBase swap() {
        double x = this.point1.x;
        double y = this.point1.y;
        this.point1.setLocation(this.point2);
        this.point2.setLocation(x, y);
        return this;
    }

    public abstract PrecisionPointPairBase getCopy();

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PrecisionPointPair)) {
            return false;
        }
        PrecisionPointPair pp = (PrecisionPointPair)obj;
        return this.point1.equals(pp.point1) && this.point2.equals(pp.point2);
    }

    public String toString() {
        return "[(" + this.point1.x + "," + this.point1.y + "), (" + this.point2.x + "," + this.point2.y + ")]";
    }

    public int hashCode() {
        return this.point1.hashCode() ^ this.point2.hashCode();
    }
}

