/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.internal.image;

import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.image.ExportAreaProvider;

public class StretchedExportAreaProvider
extends ExportAreaProvider {
    public StretchedExportAreaProvider(Rectangle sourceArea, int constrainedWidth, int constrainedHeight, Insets margins) {
        super(sourceArea, constrainedWidth, constrainedHeight, margins);
    }

    protected void adjustExportArea() {
        int width = this.constrainedWidth;
        int height = this.constrainedHeight;
        if (width >= 0 && height >= 0) {
            if (width > 0 && height > 0) {
                if (this.exportArea.width > 0 && this.exportArea.height > 0) {
                    double sy;
                    double sx;
                    double contentWidth = width - this.margins.getWidth();
                    double contentHeight = height - this.margins.getHeight();
                    if (contentWidth < 0.0) {
                        contentWidth = 0.0;
                        this.margins.right = 0;
                        this.margins.left = 0;
                    }
                    if (contentHeight < 0.0) {
                        contentHeight = 0.0;
                        this.margins.bottom = 0;
                        this.margins.top = 0;
                    }
                    if ((sx = contentWidth / (double)this.exportArea.width) > (sy = contentHeight / (double)this.exportArea.height)) {
                        this.scale = sy;
                        this.exportArea.scale(this.scale).expand(this.margins);
                        this.exportArea.x -= (width - this.exportArea.width) / 2;
                    } else {
                        this.scale = sx;
                        this.exportArea.scale(this.scale).expand(this.margins);
                        this.exportArea.y -= (height - this.exportArea.height) / 2;
                    }
                }
            } else {
                this.scale = 0.0;
                this.margins.right = 0;
                this.margins.bottom = 0;
                this.margins.left = 0;
                this.margins.top = 0;
                this.exportArea.setLocation(0, 0).setSize(0, 0);
            }
        } else if (width >= 0) {
            if (this.exportArea.width > 0) {
                double contentWidth = width - this.margins.getWidth();
                if (contentWidth < 0.0) {
                    contentWidth = 0.0;
                    this.margins.right = 0;
                    this.margins.left = 0;
                }
                this.scale = contentWidth / (double)this.exportArea.width;
                double contentHeight = (double)this.exportArea.height * this.scale;
                height = (int)Math.ceil(contentHeight + (double)this.margins.getHeight());
                this.exportArea.scale(this.scale).expand(this.margins);
                this.exportArea.x -= (width - this.exportArea.width) / 2;
            } else {
                this.scale = 0.0;
                height = this.margins.getHeight();
                this.exportArea.setLocation(0, 0).setSize(0, 0);
            }
        } else if (height >= 0) {
            if (this.exportArea.height > 0) {
                double contentHeight = height - this.margins.getHeight();
                if (contentHeight < 0.0) {
                    contentHeight = 0.0;
                    this.margins.bottom = 0;
                    this.margins.top = 0;
                }
                this.scale = contentHeight / (double)this.exportArea.height;
                double contentWidth = (double)this.exportArea.width * this.scale;
                width = (int)Math.ceil(contentWidth + (double)this.margins.getWidth());
                this.exportArea.scale(this.scale).expand(this.margins);
                this.exportArea.y -= (height - this.exportArea.height) / 2;
            } else {
                this.scale = 0.0;
                width = this.margins.getWidth();
                this.exportArea.setLocation(0, 0).setSize(0, 0);
            }
        } else {
            width = this.exportArea.width + this.margins.getWidth();
            height = this.exportArea.height + this.margins.getHeight();
            this.exportArea.x -= this.margins.left;
            this.exportArea.y -= this.margins.top;
        }
        this.exportArea.setSize(width, height);
    }
}

