## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)
RcppArmadillo::armadillo_throttle_cores(2)
opt <- options()
options(continue="  ", width=70, prompt=" ")
on.exit(options(opt))
library(DOVE, quietly=TRUE)

## ----eval=FALSE---------------------------------------------------------------
# vaccine(entry_time, vaccination_status, vaccination_time)

## ----eval=FALSE---------------------------------------------------------------
# dove(formula, data, plots = TRUE, timePts = NULL, bandwidth = NULL)

## ----eval = FALSE-------------------------------------------------------------
# Surv(event_time, event_status) ~ covariates +
#         vaccine(entry_time, vaccination_status, vaccination_time)

## ----eval=FALSE---------------------------------------------------------------
# dove2(formula, data, plots = TRUE, changePts = NULL,
#       constantVE = FALSE, timePts = NULL)

## ----eval=FALSE---------------------------------------------------------------
# Surv(event_time, event_status) ~ covariates +
#         vaccine(entry_time, vaccination_statue, vaccination_time)

## -----------------------------------------------------------------------------
data(doveData)

## -----------------------------------------------------------------------------
head(doveData)

## -----------------------------------------------------------------------------
summary(doveData)

## ----fig.show='hide', echo=TRUE, eval=FALSE-----------------------------------
# result1 <- dove(formula = Surv(event.time, event.status) ~ priority + sex +
#                           vaccine(entry.time, vaccine.status, vaccine.time),
#                 data = doveData)

## ----echo = FALSE-------------------------------------------------------------
result1 <- readRDS(file = "doveResult.rds")

## -----------------------------------------------------------------------------
result1$covariates

## -----------------------------------------------------------------------------
head(result1$vaccine$efficacy)
tail(result1$vaccine$efficacy)

## -----------------------------------------------------------------------------
result1$vaccine$period_efficacy

## ----eval=FALSE---------------------------------------------------------------
# plot(x = result1)

## ----echo=FALSE, out.width='49%', fig.cap='\\label{fig:doveFigs}Plots auto-generated by \\textit{dove()}. On the left, the estimated VE curve in reducing the attack rate, $VE_a(t)$ (black) and its $95\\%$ confidence intervals (green) are shown as a function of the time since vaccination. On the right, the estimated VE curve in reducing the hazard ratio, $VE_h(t)$, is shown as a function of the time since vaccination.', fig.show='hold', fig.align='center'----
knitr::include_graphics(
  path=c("dove1a.pdf","dove1b.pdf"),
  auto_pdf = getOption("knitr.graphics.auto_pdf", FALSE),
  dpi = NULL,
  error = getOption("knitr.graphics.error", TRUE)
)

## ----fig.show='hide', echo=TRUE-----------------------------------------------
result2 <- dove2(formula = Surv(event.time, event.status) ~ priority + sex + 
                           vaccine(entry.time, vaccine.status, vaccine.time), 
                 data = doveData,
                 changePts = 4*7,
                 timePts = c(4, 16, 28, 40)*7)

## -----------------------------------------------------------------------------
result2$call

## -----------------------------------------------------------------------------
result2$changePts

## -----------------------------------------------------------------------------
result2$covariates

## -----------------------------------------------------------------------------
head(result2$vaccine$VE_a)
tail(result2$vaccine$VE_a)
head(result2$vaccine$VE_h)
tail(result2$vaccine$VE_h)

## -----------------------------------------------------------------------------
result2$vaccine$VE_period

## ----fig.show='hide', eval=FALSE----------------------------------------------
# plot(x = result2)

## ----fig.cap='\\label{fig:dove2Figs}Plots auto-generated by \\textit{dove2()}. On the left, the estimated VE curve in reducing the attack rate, $VE_a(t)$ (black) and its $95\\%$ confidence intervals (green) are shown as a function of the time since vaccination. On the right, the estimated VE curve in reducing the hazard ratio, $VE_h(t)$ (black) and its $95\\%$ confidence intervals (green) are shown as a function of the time since vaccination.', fig.show="hold", out.width="50%", echo=FALSE----
knitr::include_graphics(
  path=c("dove2a.pdf","dove2b.pdf"),
  auto_pdf = getOption("knitr.graphics.auto_pdf", FALSE),
  dpi = NULL,
  error = getOption("knitr.graphics.error", TRUE)
)

## ----echo=TRUE----------------------------------------------------------------
result3 <- dove2(formula = Surv(event.time, event.status) ~ priority + sex + 
                           vaccine(entry.time, vaccine.status, vaccine.time), 
                 data = doveData,
                 constantVE = TRUE)

## -----------------------------------------------------------------------------
result3$changePts

## -----------------------------------------------------------------------------
result3$covariates

## -----------------------------------------------------------------------------
result3$vaccine$VE

## -----------------------------------------------------------------------------
plot(x = result3)

