/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.functions.levmar;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.ParamValidation;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunction;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunctionDerivatives;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunctionPoint;
import jdplus.toolkit.base.core.math.functions.ssq.SsqFunctionMinimizer;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolution;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;

public class LevenbergMarquardtMinimizer
implements SsqFunctionMinimizer {
    private static final int DEF_MAX_ITER = 200;
    private static final double EPSILON = 1.0E-17;
    private static final double DEF_INIT_MU = 0.001;
    private static final double DEF_STOP_THRESH = 1.0E-15;
    private static final double DEF_STOP_THRESH_3 = 1.0E-12;
    private final int maxIter;
    private final double tau;
    private final double eps1;
    private final double eps2;
    private final double eps3;
    private final boolean qr;
    private int iter = 0;
    private ISsqFunction function;
    private ISsqFunctionPoint currentPoint;
    private ISsqFunctionPoint tentativePoint;
    private DataBlock currentE;
    private double currentObjective;
    private double tentativeObjective;
    private FastMatrix H;
    private DoubleSeq G;
    private double scale;
    private double scale2;
    private double mu;
    private long nu;
    private int stop;
    private static final double ONE_THIRD = 0.3333333333333333;

    public static LmBuilder builder() {
        return new LmBuilder();
    }

    public LevenbergMarquardtMinimizer(LmBuilder builder) {
        this.maxIter = builder.maxIter;
        this.eps1 = builder.gPrecision;
        this.eps2 = builder.paramPrecision;
        this.eps3 = builder.fnPrecision;
        this.tau = builder.tau;
        this.qr = builder.qr;
    }

    public boolean hasConverged() {
        return this.stop == 2;
    }

    @Override
    public FastMatrix curvatureAtMinimum() {
        if (this.H == null) {
            ISsqFunctionDerivatives derivatives = this.currentPoint.ssqDerivatives();
            this.H = derivatives.hessian();
            this.G = derivatives.gradient();
        }
        return this.H;
    }

    @Override
    public DoubleSeq gradientAtMinimum() {
        if (this.G == null) {
            ISsqFunctionDerivatives derivatives = this.currentPoint.ssqDerivatives();
            this.H = derivatives.hessian();
            this.G = derivatives.gradient();
        }
        return this.G;
    }

    @Override
    public ISsqFunctionPoint getResult() {
        return this.currentPoint;
    }

    @Override
    public int getIterationsCount() {
        return this.iter;
    }

    @Override
    public double getObjective() {
        return this.currentObjective;
    }

    @Override
    public boolean minimize(ISsqFunctionPoint start) {
        this.function = start.getSsqFunction();
        this.currentPoint = start;
        return this.calc();
    }

    private boolean iterate() {
        if (this.qr) {
            return this.iterateQR();
        }
        return this.iterateCholesky();
    }

    private boolean iterateQR() {
        if (!Double.isFinite(this.currentObjective)) {
            this.stop = 7;
            return false;
        }
        if (this.currentObjective <= this.eps3 * this.scale2) {
            this.stop = 6;
            return false;
        }
        int n = this.currentE.length();
        int m = this.function.getDomain().getDim();
        FastMatrix JC = FastMatrix.make(n + m, m);
        FastMatrix J = JC.extract(0, n, 0, m);
        double[] e = new double[n + m];
        this.currentE.copyTo(e, 0);
        ISsqFunctionDerivatives derivatives = this.currentPoint.ssqDerivatives();
        try {
            derivatives.jacobian(J);
            this.G = derivatives.gradient();
        }
        catch (Exception ex) {
            return false;
        }
        double nJte = this.G.normInf();
        if (nJte <= this.eps1 * this.scale) {
            this.stop = 1;
            return false;
        }
        int kiter = 0;
        while (kiter++ < 100) {
            block20: {
                if (this.mu > 0.0) {
                    double smu = Math.sqrt(this.mu);
                    JC.subDiagonal(-n).set(smu);
                }
                try {
                    double pl2;
                    QRLeastSquaresSolution ls = QRLeastSquaresSolver.fastLeastSquares(DoubleSeq.of((double[])e), JC);
                    if (ls.rank() != m) break block20;
                    FastMatrix V = ls.RtR();
                    DoubleSeq dp = ls.getB().times(-1.0);
                    if (!Double.isFinite(dp.ssq())) {
                        this.stop = 7;
                        return false;
                    }
                    DataBlock np = DataBlock.of(this.currentPoint.getParameters());
                    double dpl2 = dp.ssq();
                    if (dpl2 <= this.eps2 * ((pl2 = np.ssq()) + this.eps2)) {
                        this.stop = 2;
                        return false;
                    }
                    if (dpl2 >= (pl2 + this.eps2) / 1.0000000000000001E-34) {
                        this.stop = 4;
                        return false;
                    }
                    np.add(dp);
                    ParamValidation status = this.function.getDomain().validate(np);
                    if (status == ParamValidation.Invalid) break block20;
                    try {
                        this.tentativePoint = this.function.ssqEvaluate((DoubleSeq)np);
                        this.tentativeObjective = this.tentativePoint.getSsqE();
                        double dF = this.currentObjective - this.tentativeObjective;
                        if (dF > 0.0) {
                            if (status == ParamValidation.Changed) {
                                this.currentPoint = this.tentativePoint;
                                this.currentObjective = this.tentativeObjective;
                                this.currentE = DataBlock.of(this.currentPoint.getE());
                                this.H = null;
                                this.G = null;
                                return true;
                            }
                            DataBlock dl = DataBlock.of(this.G);
                            dl.addAY(-2.0 * this.mu, dp);
                            double dL = -dl.dot(dp) / 2.0;
                            double ratio = dF / dL;
                            if (ratio > 1.0E-4) {
                                double tmp = 2.0 * ratio - 1.0;
                                tmp = 1.0 - tmp * tmp * tmp;
                                if (this.mu != 0.0) {
                                    this.mu *= tmp >= 0.3333333333333333 ? tmp : 0.3333333333333333;
                                }
                                this.nu = 4L;
                                boolean end = dF <= this.eps3 * this.scale2;
                                this.currentPoint = this.tentativePoint;
                                this.currentObjective = this.tentativeObjective;
                                this.currentE = DataBlock.of(this.currentPoint.getE());
                                V.mul(2.0);
                                this.H = V;
                                if (end) {
                                    this.stop = 2;
                                    return false;
                                }
                                return true;
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (Exception ls) {
                    // empty catch block
                }
            }
            this.mu = this.mu == 0.0 ? this.tau * this.scale : (this.mu *= (double)this.nu);
            long nu2 = this.nu << 2;
            if (nu2 <= this.nu) {
                this.stop = 5;
                return false;
            }
            this.nu = nu2;
        }
        return false;
    }

    private boolean iterateCholesky() {
        if (!Double.isFinite(this.currentObjective)) {
            this.stop = 7;
            return false;
        }
        if (this.currentObjective <= this.eps3 * this.scale2) {
            this.stop = 6;
            return false;
        }
        int n = this.currentE.length();
        int m = this.function.getDomain().getDim();
        FastMatrix J = FastMatrix.make(n, m);
        DataBlock Jte = DataBlock.make(m);
        try {
            this.currentPoint.ssqDerivatives().jacobian(J);
        }
        catch (Exception ex) {
            return false;
        }
        Jte.product(J.columnsIterator(), this.currentE);
        this.H = SymmetricMatrix.XtX(J);
        double nJte = Jte.normInf();
        if (nJte <= this.eps1 * this.scale) {
            this.stop = 1;
            return false;
        }
        int kiter = 0;
        while (kiter++ < 100) {
            DataBlock dp = null;
            FastMatrix K = this.H.deepClone();
            if (this.mu > 0.0) {
                K.diagonal().add(this.mu);
            }
            boolean solved = false;
            try {
                SymmetricMatrix.lcholesky(K);
                dp = DataBlock.of((DoubleSeq)Jte);
                dp.chs();
                LowerTriangularMatrix.solveLx(K, dp);
                LowerTriangularMatrix.solvexL(K, dp);
                solved = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (solved) {
                double pl2;
                if (!Double.isFinite(dp.ssq())) {
                    this.stop = 7;
                    return false;
                }
                DataBlock np = DataBlock.of(this.currentPoint.getParameters());
                double dpl2 = dp.ssq();
                if (dpl2 <= this.eps2 * ((pl2 = np.ssq()) + this.eps2)) {
                    this.stop = 2;
                    return false;
                }
                if (dpl2 >= (pl2 + this.eps2) / 1.0000000000000001E-34) {
                    this.stop = 4;
                    return false;
                }
                np.add(dp);
                ParamValidation status = this.function.getDomain().validate(np);
                if (status != ParamValidation.Invalid) {
                    try {
                        this.tentativePoint = this.function.ssqEvaluate((DoubleSeq)np);
                        this.tentativeObjective = this.tentativePoint.getSsqE();
                        double dF = this.currentObjective - this.tentativeObjective;
                        if (dF > 0.0) {
                            if (status == ParamValidation.Changed) {
                                this.currentPoint = this.tentativePoint;
                                this.currentObjective = this.tentativeObjective;
                                this.currentE = DataBlock.of(this.currentPoint.getE());
                                return true;
                            }
                            DataBlock dl = DataBlock.of((DoubleSeq)Jte);
                            dl.addAY(-this.mu, dp);
                            double dL = -dl.dot(dp);
                            double ratio = dF / dL;
                            if (ratio > 1.0E-4) {
                                double tmp = 2.0 * ratio - 1.0;
                                tmp = 1.0 - tmp * tmp * tmp;
                                if (this.mu != 0.0) {
                                    this.mu *= tmp >= 0.3333333333333333 ? tmp : 0.3333333333333333;
                                }
                                this.nu = 4L;
                                boolean end = dF <= this.eps3 * this.scale2;
                                this.currentPoint = this.tentativePoint;
                                this.currentObjective = this.tentativeObjective;
                                this.currentE = DataBlock.of(this.currentPoint.getE());
                                if (end) {
                                    this.H = null;
                                    this.stop = 2;
                                    return false;
                                }
                                return true;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.mu = this.mu == 0.0 ? this.tau * this.H.diagonal().max() : (this.mu *= (double)this.nu);
            long nu2 = this.nu << 2;
            if (nu2 <= this.nu) {
                this.stop = 5;
                return false;
            }
            this.nu = nu2;
        }
        return false;
    }

    private boolean calc() {
        this.G = null;
        this.H = null;
        this.iter = 0;
        this.nu = 4L;
        this.mu = 0.0;
        this.currentE = DataBlock.of(this.currentPoint.getE());
        this.scale2 = this.currentObjective = this.currentPoint.getSsqE();
        this.scale = Math.sqrt(this.currentObjective);
        while (this.iter++ < this.maxIter && this.iterate()) {
        }
        return this.stop != 7 && this.stop != 4 && this.iter < this.maxIter;
    }

    public static class LmBuilder
    implements SsqFunctionMinimizer.Builder {
        private double fnPrecision = 1.0E-12;
        private double paramPrecision = 1.0E-15;
        private double gPrecision = 1.0E-15;
        private double tau = 0.001;
        private int maxIter = 200;
        private boolean qr = true;

        private LmBuilder() {
        }

        @Override
        public LmBuilder functionPrecision(double eps) {
            this.fnPrecision = eps;
            return this;
        }

        public LmBuilder parametersPrecision(double eps) {
            this.paramPrecision = eps;
            return this;
        }

        public LmBuilder useQR(boolean qr) {
            this.qr = qr;
            return this;
        }

        public LmBuilder gradientPrecision(double eps) {
            this.gPrecision = eps;
            return this;
        }

        public LmBuilder initialMu(double tau) {
            this.tau = tau;
            return this;
        }

        @Override
        public LmBuilder maxIter(int niter) {
            this.maxIter = niter;
            return this;
        }

        @Override
        public LevenbergMarquardtMinimizer build() {
            return new LevenbergMarquardtMinimizer(this);
        }
    }
}

