/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.highprecision;

import jdplus.toolkit.base.core.math.highprecision.DoubleComplex;
import jdplus.toolkit.base.core.math.highprecision.DoubleDouble;
import jdplus.toolkit.base.core.math.highprecision.DoubleDoubleComputer;
import jdplus.toolkit.base.core.math.highprecision.DoubleDoubleType;

public class DoubleComplexComputer {
    private final DoubleDoubleComputer re;
    private final DoubleDoubleComputer im;

    public DoubleComplexComputer(DoubleComplex c) {
        this.re = new DoubleDoubleComputer(c.getReHigh(), c.getReLow());
        this.im = new DoubleDoubleComputer(c.getImHigh(), c.getImLow());
    }

    public DoubleComplexComputer(double re, double im) {
        this.re = new DoubleDoubleComputer(re);
        this.im = new DoubleDoubleComputer(im);
    }

    public DoubleComplexComputer add(DoubleComplex c) {
        this.re.add(c.getReHigh(), c.getReLow());
        this.im.add(c.getImHigh(), c.getImLow());
        return this;
    }

    public DoubleComplexComputer add(DoubleDoubleType x) {
        this.re.add(x);
        return this;
    }

    public DoubleComplexComputer add(double xhigh, double xlow) {
        this.re.add(xhigh, xlow);
        return this;
    }

    public DoubleComplexComputer add(double x) {
        this.re.add(x);
        return this;
    }

    public DoubleComplexComputer sub(DoubleComplex c) {
        this.re.sub(c.getReHigh(), c.getReLow());
        this.im.sub(c.getImHigh(), c.getImLow());
        return this;
    }

    public DoubleComplexComputer sub(DoubleDoubleType x) {
        this.re.sub(x);
        return this;
    }

    public DoubleComplexComputer sub(double xhigh, double xlow) {
        this.re.sub(xhigh, xlow);
        return this;
    }

    public DoubleComplexComputer sub(double x) {
        this.re.sub(x);
        return this;
    }

    public DoubleComplexComputer mul(DoubleComplex c) {
        DoubleDoubleComputer tmp1 = new DoubleDoubleComputer(this.re);
        tmp1.mul(c.getReHigh(), c.getReLow());
        DoubleDoubleComputer tmp2 = new DoubleDoubleComputer(this.im);
        tmp2.mul(c.getImHigh(), c.getImLow());
        tmp1.sub(tmp2);
        tmp2.set(this.re);
        this.re.set(tmp1);
        tmp1.set(this.im);
        tmp2.mul(c.getImHigh(), c.getImLow());
        tmp1.mul(c.getReHigh(), c.getReLow());
        tmp2.add(tmp1);
        this.im.set(tmp2);
        return this;
    }

    public DoubleComplexComputer mul(DoubleDoubleType c) {
        this.re.mul(c);
        this.im.mul(c);
        return this;
    }

    public DoubleComplexComputer mul(double xhigh, double xlow) {
        this.re.mul(xhigh, xlow);
        this.im.mul(xhigh, xlow);
        return this;
    }

    public DoubleComplexComputer mul(double x) {
        this.re.mul(x);
        this.im.mul(x);
        return this;
    }

    public DoubleComplexComputer div(DoubleComplex c) {
        DoubleDouble dIm;
        DoubleDouble dRe;
        DoubleDouble x = c.getRe();
        DoubleDouble y = c.getIm();
        if (x.abs().gt(y.abs())) {
            DoubleDoubleComputer cpt = new DoubleDoubleComputer(y);
            DoubleDouble scalar = cpt.div(x).mul(y).add(x).inv().result();
            dRe = cpt.set(y).div(x).mul(this.im).add(this.re).mul(scalar).result();
            dIm = cpt.set(y).div(x).mul(this.re).chs().add(this.im).mul(scalar).result();
        } else {
            DoubleDoubleComputer cpt = new DoubleDoubleComputer(x);
            DoubleDouble scalar = cpt.div(y).mul(x).add(y).inv().result();
            dRe = cpt.set(x).div(y).mul(this.re).add(this.im).mul(scalar).result();
            dIm = cpt.set(x).div(y).mul(this.im).sub(this.re).mul(scalar).result();
        }
        this.re.set(dRe);
        this.im.set(dIm);
        return this;
    }

    public DoubleComplexComputer div(DoubleDoubleType c) {
        this.re.div(c);
        this.im.div(c);
        return this;
    }

    public DoubleComplexComputer div(double xhigh, double xlow) {
        this.re.div(xhigh, xlow);
        this.im.div(xhigh, xlow);
        return this;
    }

    public DoubleComplexComputer div(double x) {
        this.re.div(x);
        this.im.div(x);
        return this;
    }

    public DoubleComplex result() {
        return new DoubleComplex(this.re.getHigh(), this.re.getLow(), this.im.getHigh(), this.im.getLow());
    }
}

