/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import java.time.LocalDateTime;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.api.timeseries.regression.Ramp;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;

class RampFactory
implements RegressionVariableFactory<Ramp> {
    static RampFactory FACTORY = new RampFactory();

    private RampFactory() {
    }

    @Override
    public boolean fill(Ramp var, TsPeriod start, FastMatrix buffer, ProcessingLog log) {
        this.data(var, start, buffer.column(0));
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(Ramp var, D domain, FastMatrix buffer, ProcessingLog log) {
        this.data(var, domain, buffer.column(0));
        return true;
    }

    private void data(Ramp var, TimeSeriesDomain domain, DataBlock cur) {
        LocalDateTime start = var.getStart();
        LocalDateTime end = var.getEnd();
        int t1 = domain.indexOf(end);
        int len = cur.length();
        if (t1 == -1) {
            return;
        }
        int t0 = domain.indexOf(start);
        if (t0 == -len) {
            cur.set(-1.0);
            return;
        }
        if (t1 < 0) {
            t1 = -t1;
        }
        if (t0 > 0) {
            cur.range(0, t0).set(-1.0);
        }
        if (t1 == t0) {
            return;
        }
        int k0 = Math.max(t0 + 1, 0);
        int k1 = Math.min(t1, len);
        double denom = t1 - t0;
        for (int k = k0; k < k1; ++k) {
            cur.set(k, (double)(k - t0) / denom - 1.0);
        }
    }

    public void data(Ramp var, TsPeriod pstart, DataBlock data) {
        TsPeriod start = TsPeriod.of((TsUnit)pstart.getUnit(), (LocalDateTime)var.getStart());
        TsPeriod end = TsPeriod.of((TsUnit)pstart.getUnit(), (LocalDateTime)var.getEnd());
        int t0 = pstart.until(start);
        int t1 = pstart.until(end);
        int len = data.length();
        if (t1 <= t0) {
            data.set(0.0);
            return;
        }
        if (t0 >= 0) {
            if (t0 >= len - 1) {
                data.set(-1.0);
                return;
            }
            data.range(0, t0 + 1).set(-1.0);
        }
        if (t1 < len) {
            if (t1 <= 0) {
                data.set(0.0);
                return;
            }
            data.range(t1, len).set(0.0);
        }
        int k0 = Math.max(t0 + 1, 0);
        int k1 = Math.min(t1, len);
        double denom = t1 - t0;
        for (int k = k0; k < k1; ++k) {
            data.set(k, (double)(k - t0) / denom - 1.0);
        }
    }
}

