/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class RegressionDesc {
    private final String name;
    private final ITsVariable core;
    private final int item;
    private final int position;
    private final double coef;
    private final double stderr;
    private final double pvalue;

    public double getTStat() {
        return this.coef / this.stderr;
    }

    @Generated
    public RegressionDesc(String name, ITsVariable core, int item, int position, double coef, double stderr, double pvalue) {
        this.name = name;
        this.core = core;
        this.item = item;
        this.position = position;
        this.coef = coef;
        this.stderr = stderr;
        this.pvalue = pvalue;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ITsVariable getCore() {
        return this.core;
    }

    @Generated
    public int getItem() {
        return this.item;
    }

    @Generated
    public int getPosition() {
        return this.position;
    }

    @Generated
    public double getCoef() {
        return this.coef;
    }

    @Generated
    public double getStderr() {
        return this.stderr;
    }

    @Generated
    public double getPvalue() {
        return this.pvalue;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegressionDesc)) {
            return false;
        }
        RegressionDesc other = (RegressionDesc)o;
        if (this.getItem() != other.getItem()) {
            return false;
        }
        if (this.getPosition() != other.getPosition()) {
            return false;
        }
        if (Double.compare(this.getCoef(), other.getCoef()) != 0) {
            return false;
        }
        if (Double.compare(this.getStderr(), other.getStderr()) != 0) {
            return false;
        }
        if (Double.compare(this.getPvalue(), other.getPvalue()) != 0) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ITsVariable this$core = this.getCore();
        ITsVariable other$core = other.getCore();
        return !(this$core == null ? other$core != null : !this$core.equals(other$core));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getItem();
        result = result * 59 + this.getPosition();
        long $coef = Double.doubleToLongBits(this.getCoef());
        result = result * 59 + (int)($coef >>> 32 ^ $coef);
        long $stderr = Double.doubleToLongBits(this.getStderr());
        result = result * 59 + (int)($stderr >>> 32 ^ $stderr);
        long $pvalue = Double.doubleToLongBits(this.getPvalue());
        result = result * 59 + (int)($pvalue >>> 32 ^ $pvalue);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ITsVariable $core = this.getCore();
        result = result * 59 + ($core == null ? 43 : $core.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "RegressionDesc(name=" + this.getName() + ", core=" + String.valueOf(this.getCore()) + ", item=" + this.getItem() + ", position=" + this.getPosition() + ", coef=" + this.getCoef() + ", stderr=" + this.getStderr() + ", pvalue=" + this.getPvalue() + ")";
    }
}

