/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.sts;

import jdplus.toolkit.base.api.ssf.sts.SeasonalModel;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.basic.Loading;
import jdplus.toolkit.base.core.ssf.sts.SeasonalComponent;
import lombok.Generated;

public final class VarSeasonalComponent {
    public static StateComponent of(SeasonalModel model, int period, double[] std, double scale) {
        SeasonalModel cmodel = scale == 0.0 ? SeasonalModel.Fixed : model;
        Data data = new Data(cmodel, period, std, scale);
        return new StateComponent(new Initialization(data), new Dynamics(data));
    }

    public static ISsfLoading defaultLoading() {
        return Loading.fromPosition(0);
    }

    public static ISsfLoading harrisonStevensLoading(int period) {
        return Loading.circular(period);
    }

    @Generated
    private VarSeasonalComponent() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class Data {
        private final SeasonalModel seasModel;
        private final double scale;
        private final double[] std;
        private final int period;
        private final FastMatrix tsvar;
        private final FastMatrix lvar;

        Data(SeasonalModel model, int period, double[] std, double scale) {
            this.scale = scale;
            this.std = std;
            this.seasModel = model;
            this.period = period;
            if (scale > 0.0) {
                this.tsvar = SeasonalComponent.tsVar(this.seasModel, period);
                this.lvar = model != SeasonalModel.Crude && model != SeasonalModel.Dummy ? SeasonalComponent.tslVar(this.seasModel, period) : null;
            } else {
                this.tsvar = null;
                this.lvar = null;
            }
        }

        double var(int pos) {
            if (pos < this.std.length) {
                double q = this.std[pos] * this.scale;
                return q * q;
            }
            return this.scale * this.scale;
        }

        double std(int pos) {
            return pos < this.std.length ? this.std[pos] * this.scale : this.scale;
        }
    }

    static class Initialization
    implements ISsfInitialization {
        private final Data data;

        public Initialization(Data data) {
            this.data = data;
        }

        @Override
        public int getStateDim() {
            return this.data.period - 1;
        }

        @Override
        public boolean isDiffuse() {
            return this.data.scale >= 0.0;
        }

        @Override
        public int getDiffuseDim() {
            return this.data.period - 1;
        }

        @Override
        public void diffuseConstraints(FastMatrix b) {
            b.diagonal().set(1.0);
        }

        @Override
        public void Pi0(FastMatrix p) {
            p.diagonal().set(1.0);
        }

        @Override
        public void a0(DataBlock a0) {
        }

        @Override
        public void Pf0(FastMatrix p) {
        }
    }

    static class Dynamics
    implements ISsfDynamics {
        private final Data data;

        public Dynamics(Data data) {
            this.data = data;
        }

        @Override
        public boolean isTimeInvariant() {
            return this.data.scale == 0.0;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return this.data.scale == 0.0;
        }

        @Override
        public int getInnovationsDim() {
            if (this.data.scale > 0.0) {
                if (this.data.seasModel == SeasonalModel.Dummy || this.data.seasModel == SeasonalModel.Crude) {
                    return 1;
                }
                return this.data.period - 1;
            }
            return 0;
        }

        @Override
        public void V(int pos, FastMatrix v) {
            if (this.data.scale > 0.0) {
                if (this.data.seasModel == SeasonalModel.Dummy) {
                    v.set(0, 0, this.data.var(pos));
                } else {
                    v.setAY(this.data.var(pos), this.data.tsvar);
                }
            }
        }

        @Override
        public boolean hasInnovations(int pos) {
            return this.data.seasModel != SeasonalModel.Fixed;
        }

        @Override
        public void S(int pos, FastMatrix s) {
            if (null != this.data.seasModel) {
                switch (this.data.seasModel) {
                    case Crude: {
                        s.set(this.data.std(pos));
                        break;
                    }
                    case Dummy: {
                        s.set(this.data.period - 2, this.data.period - 2, this.data.std(pos));
                        break;
                    }
                    default: {
                        s.setAY(this.data.std(pos), this.data.lvar);
                    }
                }
            }
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            switch (this.data.seasModel) {
                case Crude: {
                    x.add(this.data.std(pos) * u.get(0));
                    break;
                }
                case Dummy: {
                    x.add(0, this.data.std(pos) * u.get(0));
                    break;
                }
                default: {
                    x.addAProduct(this.data.std(pos), this.data.lvar.rowsIterator(), u);
                }
            }
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            switch (this.data.seasModel) {
                case Crude: {
                    xs.set(0, this.data.std(pos) * x.sum());
                    break;
                }
                case Dummy: {
                    xs.set(0, this.data.std(pos) * x.get(this.data.period - 2));
                    break;
                }
                default: {
                    xs.AProduct(this.data.std(pos), x, this.data.lvar.columnsIterator());
                }
            }
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            if (this.data.scale >= 0.0) {
                tr.row(this.data.period - 2).set(-1.0);
                tr.subDiagonal(1).set(1.0);
            }
        }

        @Override
        public void TX(int pos, DataBlock x) {
            x.fshiftAndNegSum();
        }

        @Override
        public void XT(int pos, DataBlock x) {
            int imax = this.data.period - 2;
            double xs = x.get(0);
            for (int i = 0; i < imax; ++i) {
                x.set(i, x.get(i + 1) - xs);
            }
            x.set(imax, -xs);
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            switch (this.data.seasModel) {
                case Fixed: {
                    return;
                }
                case Dummy: {
                    p.add(this.data.period - 2, this.data.period - 2, this.data.var(pos));
                    break;
                }
                case Crude: {
                    p.add(this.data.var(pos));
                    break;
                }
                default: {
                    p.addAY(this.data.var(pos), this.data.tsvar);
                }
            }
        }
    }
}

