/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ucarima;

import jdplus.toolkit.base.core.arima.ArimaModel;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.ucarima.SimpleModelDecomposer;

public class MovingAverageDecomposer
extends SimpleModelDecomposer {
    @Override
    protected void calc() {
        BackFilter AR = this.model.getAr();
        Polynomial ar = AR.asPolynomial();
        Polynomial q = this.model.getMa().asPolynomial();
        if (q.degree() <= ar.degree()) {
            this.signal = null;
            this.noise = this.model;
        } else {
            BackFilter U = this.model.getNonStationaryAr();
            BackFilter P = this.model.getStationaryAr();
            Polynomial p = P.asPolynomial();
            Polynomial.Division div = Polynomial.divide(q, ar);
            Polynomial r = div.getQuotient();
            double cq = q.get(q.degree());
            double cp = ar.get(ar.degree());
            double cr = r.get(r.degree());
            double c0 = r.get(0);
            r = r.times(cq / (cr * cp));
            BackFilter fr2 = new BackFilter(r);
            SymmetricFilter sq = SymmetricFilter.convolutionOf(new BackFilter(q));
            SymmetricFilter sr = SymmetricFilter.convolutionOf(new BackFilter(r));
            SymmetricFilter spr = SymmetricFilter.convolutionOf(AR.times(fr2));
            SymmetricFilter ss = spr.minus(sq);
            this.signal = new ArimaModel(BackFilter.ONE, BackFilter.ONE, sr);
            this.noise = new ArimaModel(P, U, ss);
        }
    }
}

