/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.r.arima;

import java.util.LinkedHashMap;
import java.util.Map;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.information.GenericExplorable;
import jdplus.toolkit.base.api.information.InformationMapping;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.arima.ExactArimaForecasts;
import jdplus.toolkit.base.core.ssf.arima.FastArimaForecasts;
import jdplus.toolkit.base.core.ssf.arima.SsfArima;
import jdplus.toolkit.base.core.ssf.basic.RegSsf;
import jdplus.toolkit.base.core.ssf.dk.DkToolkit;
import jdplus.toolkit.base.core.ssf.univariate.DefaultSmoothingResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.Ssf;
import jdplus.toolkit.base.core.ssf.univariate.SsfData;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class ArimaForecasts {
    public static Results process(RegArimaModel regarima, double mean, int nf, int nb, String method) {
        if (!method.equalsIgnoreCase("all")) {
            ExactArimaForecasts fcasts;
            Results.Builder builder = Results.builder();
            boolean exact = method.equalsIgnoreCase("exact");
            Object object = fcasts = exact ? new ExactArimaForecasts() : new FastArimaForecasts();
            if (exact) {
                fcasts.prepare(regarima.arima(), mean != 0.0);
            } else {
                fcasts.prepare(regarima.arima(), mean);
            }
            if (nf > 0) {
                builder.forecasts(fcasts.forecasts(regarima.getY(), nf));
            }
            if (nb > 0) {
                builder.backcasts(fcasts.backcasts(regarima.getY(), nb));
            }
            return builder.build();
        }
        return ArimaForecasts.ssfcompute(regarima, nf, nb);
    }

    private static Results ssfcompute(RegArimaModel regarima, int nf, int nb) {
        int i;
        int i2;
        StateComponent arima = SsfArima.stateComponent((IArimaModel)regarima.arima());
        DoubleSeq y = regarima.getY();
        double[] yc = new double[y.length() + nf + nb];
        for (int i3 = 0; i3 < nb; ++i3) {
            yc[i3] = Double.NaN;
        }
        y.copyTo(yc, nb);
        int[] m = regarima.missing();
        if (m != null) {
            for (i2 = 0; i2 < m.length; ++i2) {
                yc[nb + m[i2]] = Double.NaN;
            }
        }
        for (i2 = nb + y.length(); i2 < yc.length; ++i2) {
            yc[i2] = Double.NaN;
        }
        Ssf ssf = Ssf.of((StateComponent)arima, (ISsfLoading)SsfArima.defaultLoading());
        int nx = regarima.getVariablesCount();
        if (nx > 0) {
            FastMatrix x = FastMatrix.make((int)yc.length, (int)nx);
            if (regarima.isMean()) {
                ArimaForecasts.generateMeanEffect(regarima.arima().getNonStationaryAr(), x.column(0));
            }
            ssf = RegSsf.ssf((ISsf)ssf, (FastMatrix)x);
        }
        DefaultSmoothingResults ss = DkToolkit.sqrtSmooth((ISsf)ssf, (ISsfData)new SsfData(yc), (boolean)true, (boolean)true);
        Results.Builder builder = Results.builder();
        ISsfLoading loading = ssf.loading();
        if (nb > 0) {
            double[] b = new double[nb];
            double[] eb = new double[nb];
            for (i = 0; i < nb; ++i) {
                b[i] = loading.ZX(i, ss.a(i));
                eb[i] = Math.sqrt(loading.ZVZ(i, ss.P(i)));
            }
            builder.backcasts(DoubleSeq.of((double[])b)).backcastsErrors(DoubleSeq.of((double[])eb));
        }
        if (nf > 0) {
            double[] f = new double[nf];
            double[] ef = new double[nf];
            i = 0;
            int j = nb + y.length();
            while (i < nf) {
                f[i] = loading.ZX(j, ss.a(j));
                ef[i] = Math.sqrt(loading.ZVZ(j, ss.P(j)));
                ++i;
                ++j;
            }
            builder.forecasts(DoubleSeq.of((double[])f)).forecastsErrors(DoubleSeq.of((double[])ef));
        }
        return builder.build();
    }

    public static void generateMeanEffect(BackFilter ur, DataBlock m) {
        Polynomial p = ur.asPolynomial();
        int n = m.length();
        for (int i = p.degree(); i < n; ++i) {
            double c = 1.0;
            for (int j = 1; j <= p.degree(); ++j) {
                if (p.get(j) == 0.0) continue;
                c -= p.get(j) * m.get(i - j);
            }
            m.set(i, c);
        }
    }

    @Generated
    private ArimaForecasts() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class Results
    implements GenericExplorable {
        private final RegArimaModel<SarimaModel> regarima;
        private final DoubleSeq forecasts;
        private final DoubleSeq forecastsErrors;
        private final DoubleSeq backcasts;
        private final DoubleSeq backcastsErrors;
        private static final String FCASTS = "forecasts";
        private static final String EFCASTS = "forecasts.se";
        private static final String BCASTS = "backcasts";
        private static final String EBCASTS = "backcasts.se";
        private static final InformationMapping<Results> MAPPING = new InformationMapping<Results>(){

            public Class getSourceClass() {
                return Results.class;
            }
        };

        public boolean contains(String id) {
            return MAPPING.contains(id);
        }

        public Map<String, Class> getDictionary() {
            LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
            MAPPING.fillDictionary(null, dic, true);
            return dic;
        }

        public <T> T getData(String id, Class<T> tclass) {
            return (T)MAPPING.getData((Object)this, id, tclass);
        }

        public static final InformationMapping<Results> getMapping() {
            return MAPPING;
        }

        @Generated
        Results(RegArimaModel<SarimaModel> regarima, DoubleSeq forecasts, DoubleSeq forecastsErrors, DoubleSeq backcasts, DoubleSeq backcastsErrors) {
            this.regarima = regarima;
            this.forecasts = forecasts;
            this.forecastsErrors = forecastsErrors;
            this.backcasts = backcasts;
            this.backcastsErrors = backcastsErrors;
        }

        @Generated
        public static @NonNull Builder builder() {
            return new Builder();
        }

        @Generated
        public RegArimaModel<SarimaModel> getRegarima() {
            return this.regarima;
        }

        @Generated
        public DoubleSeq getForecasts() {
            return this.forecasts;
        }

        @Generated
        public DoubleSeq getForecastsErrors() {
            return this.forecastsErrors;
        }

        @Generated
        public DoubleSeq getBackcasts() {
            return this.backcasts;
        }

        @Generated
        public DoubleSeq getBackcastsErrors() {
            return this.backcastsErrors;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Results)) {
                return false;
            }
            Results other = (Results)o;
            RegArimaModel<SarimaModel> this$regarima = this.getRegarima();
            RegArimaModel<SarimaModel> other$regarima = other.getRegarima();
            if (this$regarima == null ? other$regarima != null : !this$regarima.equals(other$regarima)) {
                return false;
            }
            DoubleSeq this$forecasts = this.getForecasts();
            DoubleSeq other$forecasts = other.getForecasts();
            if (this$forecasts == null ? other$forecasts != null : !this$forecasts.equals(other$forecasts)) {
                return false;
            }
            DoubleSeq this$forecastsErrors = this.getForecastsErrors();
            DoubleSeq other$forecastsErrors = other.getForecastsErrors();
            if (this$forecastsErrors == null ? other$forecastsErrors != null : !this$forecastsErrors.equals(other$forecastsErrors)) {
                return false;
            }
            DoubleSeq this$backcasts = this.getBackcasts();
            DoubleSeq other$backcasts = other.getBackcasts();
            if (this$backcasts == null ? other$backcasts != null : !this$backcasts.equals(other$backcasts)) {
                return false;
            }
            DoubleSeq this$backcastsErrors = this.getBackcastsErrors();
            DoubleSeq other$backcastsErrors = other.getBackcastsErrors();
            return !(this$backcastsErrors == null ? other$backcastsErrors != null : !this$backcastsErrors.equals(other$backcastsErrors));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RegArimaModel<SarimaModel> $regarima = this.getRegarima();
            result = result * 59 + ($regarima == null ? 43 : $regarima.hashCode());
            DoubleSeq $forecasts = this.getForecasts();
            result = result * 59 + ($forecasts == null ? 43 : $forecasts.hashCode());
            DoubleSeq $forecastsErrors = this.getForecastsErrors();
            result = result * 59 + ($forecastsErrors == null ? 43 : $forecastsErrors.hashCode());
            DoubleSeq $backcasts = this.getBackcasts();
            result = result * 59 + ($backcasts == null ? 43 : $backcasts.hashCode());
            DoubleSeq $backcastsErrors = this.getBackcastsErrors();
            result = result * 59 + ($backcastsErrors == null ? 43 : $backcastsErrors.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "ArimaForecasts.Results(regarima=" + String.valueOf(this.getRegarima()) + ", forecasts=" + String.valueOf(this.getForecasts()) + ", forecastsErrors=" + String.valueOf(this.getForecastsErrors()) + ", backcasts=" + String.valueOf(this.getBackcasts()) + ", backcastsErrors=" + String.valueOf(this.getBackcastsErrors()) + ")";
        }

        static {
            MAPPING.set(FCASTS, double[].class, source -> source.forecasts != null ? source.forecasts.toArray() : null);
            MAPPING.set(BCASTS, double[].class, source -> source.backcasts != null ? source.backcasts.toArray() : null);
            MAPPING.set(EFCASTS, double[].class, source -> source.forecastsErrors != null ? source.forecastsErrors.toArray() : null);
            MAPPING.set(EBCASTS, double[].class, source -> source.backcastsErrors != null ? source.backcastsErrors.toArray() : null);
        }

        @Generated
        public static class Builder {
            @Generated
            private RegArimaModel<SarimaModel> regarima;
            @Generated
            private DoubleSeq forecasts;
            @Generated
            private DoubleSeq forecastsErrors;
            @Generated
            private DoubleSeq backcasts;
            @Generated
            private DoubleSeq backcastsErrors;

            @Generated
            Builder() {
            }

            @Generated
            public @NonNull Builder regarima(RegArimaModel<SarimaModel> regarima) {
                this.regarima = regarima;
                return this;
            }

            @Generated
            public @NonNull Builder forecasts(DoubleSeq forecasts) {
                this.forecasts = forecasts;
                return this;
            }

            @Generated
            public @NonNull Builder forecastsErrors(DoubleSeq forecastsErrors) {
                this.forecastsErrors = forecastsErrors;
                return this;
            }

            @Generated
            public @NonNull Builder backcasts(DoubleSeq backcasts) {
                this.backcasts = backcasts;
                return this;
            }

            @Generated
            public @NonNull Builder backcastsErrors(DoubleSeq backcastsErrors) {
                this.backcastsErrors = backcastsErrors;
                return this;
            }

            @Generated
            public @NonNull Results build() {
                return new Results(this.regarima, this.forecasts, this.forecastsErrors, this.backcasts, this.backcastsErrors);
            }

            @Generated
            public @NonNull String toString() {
                return "ArimaForecasts.Results.Builder(regarima=" + String.valueOf(this.regarima) + ", forecasts=" + String.valueOf(this.forecasts) + ", forecastsErrors=" + String.valueOf(this.forecastsErrors) + ", backcasts=" + String.valueOf(this.backcasts) + ", backcastsErrors=" + String.valueOf(this.backcastsErrors) + ")";
            }
        }
    }
}

