/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.format.DateTimeParseException;
import jdplus.toolkit.base.api.time.ISO_8601;
import jdplus.toolkit.base.api.time.TemporalFormatter;
import jdplus.toolkit.base.api.time.TimeIntervalAccessor;
import jdplus.toolkit.base.api.time.TimeIntervalFormatter;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

@ISO_8601
public final class Day
implements TimeSeriesInterval<Period> {
    @NonNull
    private final LocalDate day;
    private static final TimeIntervalFormatter.StartDuration ISO_8601 = TimeIntervalFormatter.StartDuration.of(TemporalFormatter.EXTENDED_CALENDAR, LocalDate::from, Period::parse);

    @Override
    @NonNull
    public LocalDateTime start() {
        return this.day.atStartOfDay();
    }

    @Override
    @NonNull
    public LocalDateTime end() {
        return this.day.plusDays(1L).atStartOfDay();
    }

    @Override
    public boolean contains(LocalDateTime element) {
        return element.toLocalDate().equals(this.day);
    }

    @Override
    @NonNull
    public Period getDuration() {
        return Period.ofDays(1);
    }

    public String toString() {
        return ISO_8601.format(this);
    }

    @NonNull
    public static Day parse(@NonNull CharSequence text) throws DateTimeParseException {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return ISO_8601.parse(text, Day::from);
    }

    @NonNull
    public static Day from(@NonNull TimeIntervalAccessor timeInterval) {
        if (timeInterval == null) {
            throw new NullPointerException("timeInterval is marked non-null but is null");
        }
        return Day.of(LocalDate.from(timeInterval.start()));
    }

    @Generated
    private Day(@NonNull LocalDate day) {
        if (day == null) {
            throw new NullPointerException("day is marked non-null but is null");
        }
        this.day = day;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull Day of(@NonNull LocalDate day) {
        if (day == null) {
            throw new NullPointerException("day is marked non-null but is null");
        }
        return new Day(day);
    }

    @NonNull
    @Generated
    public LocalDate getDay() {
        return this.day;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Day)) {
            return false;
        }
        Day other = (Day)o;
        LocalDate this$day = this.getDay();
        LocalDate other$day = other.getDay();
        return !(this$day == null ? other$day != null : !((Object)this$day).equals(other$day));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDate $day = this.getDay();
        result = result * 59 + ($day == null ? 43 : ((Object)$day).hashCode());
        return result;
    }
}

