% Generated by roxygen2: do not edit by hand
\name{qr}
\alias{qr}
\alias{qr.Q}
\alias{qr.R}
\title{Compute/Extract a QR Matrix Decomposition}
\arguments{
  \item{x}{Matrix A for QR decomposition or fitted model
}
}

\details{
\{.help [\{.fun qr\}](base::qr)\} computes a representation of the QR decomposition
\code{
A <- matrix(1:12, nrow = 4) # m x n matrix
qrA <- qr(A)                # precomputes QR stuff
}

Compute the Q and R matrices from \{.help [\{.fun qr\}](base::qr)\} output
\code{
Q <- qr.Q(qrA)              # m x n orthogonal matrix
R <- qr.R(qrA)              # n x n upper triangular matrix, not unit diag
Q \%*\% R                     # = A up to numerical error
}

Compute the rank of a matrix with the QR decomposition
\code{
qrA$rank
}

Solve a linear system \{.strong Ax\} = \{.strong b\} using QR.
\code{
(A <- rbind(c(1,3,4), c(-1,1,1), c(5,0,5)))
b <- 1:3
qr.solve(A, b) # = x
}}

