/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.time;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.util.Locale;
import jdplus.toolkit.base.api.time.DateType;
import jdplus.toolkit.base.api.time.RepresentationFormat;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class TemporalFormatter {
    public static final TemporalFormatter BASIC_CALENDAR = TemporalFormatter.builder().format(RepresentationFormat.BASIC).type(DateType.CALENDAR).time(false).build();
    public static final TemporalFormatter BASIC_CALENDAR_TIME = TemporalFormatter.builder().format(RepresentationFormat.BASIC).type(DateType.CALENDAR).time(true).build();
    public static final TemporalFormatter BASIC_ORDINAL = TemporalFormatter.builder().format(RepresentationFormat.BASIC).type(DateType.ORDINAL).time(false).build();
    public static final TemporalFormatter BASIC_WEEK = TemporalFormatter.builder().format(RepresentationFormat.BASIC).type(DateType.WEEK).time(false).build();
    public static final TemporalFormatter EXTENDED_CALENDAR = TemporalFormatter.builder().format(RepresentationFormat.EXTENDED).type(DateType.CALENDAR).time(false).build();
    public static final TemporalFormatter EXTENDED_CALENDAR_TIME = TemporalFormatter.builder().format(RepresentationFormat.EXTENDED).type(DateType.CALENDAR).time(true).build();
    public static final TemporalFormatter EXTENDED_ORDINAL = TemporalFormatter.builder().format(RepresentationFormat.EXTENDED).type(DateType.ORDINAL).time(false).build();
    public static final TemporalFormatter EXTENDED_WEEK = TemporalFormatter.builder().format(RepresentationFormat.EXTENDED).type(DateType.WEEK).time(false).build();
    @NonNull
    private final RepresentationFormat format;
    @NonNull
    private final DateType type;
    private final boolean time;
    private static final DateTimeFormatter BASIC_CALENDAR_FORMATTER = DateTimeFormatter.BASIC_ISO_DATE;
    private static final DateTimeFormatter EXTENDED_CALENDAR_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final DateTimeFormatter BASIC_ORDINAL_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendValue(ChronoField.DAY_OF_YEAR, 3).optionalStart().appendOffsetId().toFormatter(Locale.ROOT);
    private static final DateTimeFormatter EXTENDED_ORDINAL_FORMATTER = DateTimeFormatter.ISO_ORDINAL_DATE;
    private static final DateTimeFormatter BASIC_WEEK_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(IsoFields.WEEK_BASED_YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral("W").appendValue(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 2).appendValue(ChronoField.DAY_OF_WEEK, 1).optionalStart().appendOffsetId().toFormatter(Locale.ROOT);
    private static final DateTimeFormatter EXTENDED_WEEK_FORMATTER = DateTimeFormatter.ISO_WEEK_DATE;
    private static final DateTimeFormatter BASIC_TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter(Locale.ROOT);
    private static final DateTimeFormatter BASIC_CALENDAR_TIME_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(BASIC_CALENDAR_FORMATTER).appendLiteral('T').append(BASIC_TIME).toFormatter(Locale.ROOT);
    private static final DateTimeFormatter EXTENDED_CALENDAR_TIME_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).optionalStart().appendLiteral('-').appendPattern("MM").optionalStart().appendLiteral('-').appendPattern("dd").optionalStart().appendLiteral('T').appendPattern("HH").optionalStart().appendLiteral(':').appendPattern("mm").optionalStart().appendLiteral(':').appendPattern("ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().optionalEnd().optionalEnd().optionalEnd().optionalEnd().optionalEnd().parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.NANO_OF_SECOND, 0L).toFormatter(Locale.ROOT);
    private static final DateTimeFormatter[][] DATE_FORMATTERS = new DateTimeFormatter[][]{{BASIC_CALENDAR_FORMATTER, BASIC_ORDINAL_FORMATTER, BASIC_WEEK_FORMATTER}, {EXTENDED_CALENDAR_FORMATTER, EXTENDED_ORDINAL_FORMATTER, EXTENDED_WEEK_FORMATTER}};
    private static final DateTimeFormatter[][] DATE_TIME_FORMATTERS = new DateTimeFormatter[][]{{BASIC_CALENDAR_TIME_FORMATTER, null, null}, {EXTENDED_CALENDAR_TIME_FORMATTER, null, null}};

    @NonNull
    public String format(@NonNull Temporal temporal) throws DateTimeException {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        return this.format(temporal, null);
    }

    @NonNull
    public String format(@NonNull Temporal temporal, @Nullable ChronoUnit precision) throws DateTimeException {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        StringBuilder result = new StringBuilder(32);
        this.formatTo(temporal, result, precision);
        return result.toString();
    }

    public void formatTo(@NonNull Temporal temporal, @NonNull Appendable appendable) throws DateTimeException {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        if (appendable == null) {
            throw new NullPointerException("appendable is marked non-null but is null");
        }
        this.formatTo(temporal, appendable, null);
    }

    public void formatTo(@NonNull Temporal temporal, @NonNull Appendable appendable, @Nullable ChronoUnit precision) throws DateTimeException {
        if (temporal == null) {
            throw new NullPointerException("temporal is marked non-null but is null");
        }
        if (appendable == null) {
            throw new NullPointerException("appendable is marked non-null but is null");
        }
        if (precision != null && this.format.equals((Object)RepresentationFormat.EXTENDED) && this.type.equals((Object)DateType.CALENDAR)) {
            TemporalFormatter.appendTo(TemporalFormatter.getAsShortString(temporal, precision), appendable);
        } else {
            this.getDateTimeFormatter(this.format, this.type, this.time).formatTo(temporal, appendable);
        }
    }

    @NonNull
    public <T> T parse(@NonNull CharSequence text, @NonNull TemporalQuery<T> query) throws DateTimeParseException {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        return this.getDateTimeFormatter(this.format, this.type, this.time).parse(text, query);
    }

    private DateTimeFormatter getDateTimeFormatter(RepresentationFormat format, DateType type, boolean time) {
        DateTimeFormatter result;
        DateTimeFormatter dateTimeFormatter = result = time ? DATE_TIME_FORMATTERS[format.ordinal()][type.ordinal()] : DATE_FORMATTERS[format.ordinal()][type.ordinal()];
        if (result == null) {
            throw new IllegalArgumentException("Unsupported format: " + String.valueOf((Object)format) + ", type: " + String.valueOf((Object)type) + ", time: " + time);
        }
        return result;
    }

    static String getAsShortString(Temporal temporal, ChronoUnit precision) {
        if (TemporalFormatter.getNanoOfSeconds(temporal) != 0L) {
            return temporal.toString();
        }
        int year = TemporalFormatter.get(temporal, ChronoField.YEAR, 0);
        int month = TemporalFormatter.get(temporal, ChronoField.MONTH_OF_YEAR, 1);
        int day = TemporalFormatter.get(temporal, ChronoField.DAY_OF_MONTH, 1);
        int hour = TemporalFormatter.get(temporal, ChronoField.HOUR_OF_DAY, 0);
        int minute = TemporalFormatter.get(temporal, ChronoField.MINUTE_OF_HOUR, 0);
        int second = TemporalFormatter.get(temporal, ChronoField.SECOND_OF_MINUTE, 0);
        ChronoUnit startUnit = TemporalFormatter.getMinChronoUnit(second, minute, hour, day, month);
        ChronoUnit min = TemporalFormatter.min(startUnit, precision);
        return switch (min) {
            case ChronoUnit.SECONDS -> year + (month < 10 ? "-0" : "-") + month + (day < 10 ? "-0" : "-") + day + (hour < 10 ? "T0" : "T") + hour + (minute < 10 ? ":0" : ":") + minute + (second < 10 ? ":0" : ":") + second;
            case ChronoUnit.MINUTES -> year + (month < 10 ? "-0" : "-") + month + (day < 10 ? "-0" : "-") + day + (hour < 10 ? "T0" : "T") + hour + (minute < 10 ? ":0" : ":") + minute;
            case ChronoUnit.HOURS -> year + (month < 10 ? "-0" : "-") + month + (day < 10 ? "-0" : "-") + day + (hour < 10 ? "T0" : "T") + hour;
            case ChronoUnit.DAYS -> year + (month < 10 ? "-0" : "-") + month + (day < 10 ? "-0" : "-") + day;
            case ChronoUnit.MONTHS -> year + (month < 10 ? "-0" : "-") + month;
            case ChronoUnit.YEARS -> String.valueOf(year);
            default -> temporal.toString();
        };
    }

    private static long getNanoOfSeconds(TemporalAccessor temporal) {
        return temporal.isSupported(ChronoField.NANO_OF_SECOND) ? temporal.getLong(ChronoField.NANO_OF_SECOND) : 0L;
    }

    private static int get(TemporalAccessor temporal, TemporalField field, int defaultValue) {
        return temporal.isSupported(field) ? temporal.get(field) : defaultValue;
    }

    private static <T extends Comparable<T>> T min(T first, T second) {
        return first.compareTo(second) < 0 ? first : second;
    }

    private static ChronoUnit getMinChronoUnit(int second, int minute, int hour, int day, int month) {
        if (second != 0) {
            return ChronoUnit.SECONDS;
        }
        if (minute != 0) {
            return ChronoUnit.MINUTES;
        }
        if (hour != 0) {
            return ChronoUnit.HOURS;
        }
        if (day != 1) {
            return ChronoUnit.DAYS;
        }
        if (month != 1) {
            return ChronoUnit.MONTHS;
        }
        return ChronoUnit.YEARS;
    }

    static void appendTo(CharSequence text, Appendable appendable) throws DateTimeException {
        try {
            appendable.append(text);
        }
        catch (IOException ex) {
            throw new DateTimeException(ex.getMessage(), ex);
        }
    }

    static void appendTo(char c, Appendable appendable) throws DateTimeException {
        try {
            appendable.append(c);
        }
        catch (IOException ex) {
            throw new DateTimeException(ex.getMessage(), ex);
        }
    }

    @Generated
    TemporalFormatter(@NonNull RepresentationFormat format, @NonNull DateType type, boolean time) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.format = format;
        this.type = type;
        this.time = time;
    }

    @Generated
    private static @org.jspecify.annotations.NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    private static class Builder {
        @Generated
        private RepresentationFormat format;
        @Generated
        private DateType type;
        @Generated
        private boolean time;

        @Generated
        Builder() {
        }

        @Generated
        private @org.jspecify.annotations.NonNull Builder format(@NonNull RepresentationFormat format) {
            if (format == null) {
                throw new NullPointerException("format is marked non-null but is null");
            }
            this.format = format;
            return this;
        }

        @Generated
        private @org.jspecify.annotations.NonNull Builder type(@NonNull DateType type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        @Generated
        private @org.jspecify.annotations.NonNull Builder time(boolean time) {
            this.time = time;
            return this;
        }

        @Generated
        private @org.jspecify.annotations.NonNull TemporalFormatter build() {
            return new TemporalFormatter(this.format, this.type, this.time);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "TemporalFormatter.Builder(format=" + String.valueOf((Object)this.format) + ", type=" + String.valueOf((Object)this.type) + ", time=" + this.time + ")";
        }
    }
}

