/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.regression.ResidualsType;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class TsResiduals {
    @NonNull
    private final ResidualsType type;
    @NonNull
    private final DoubleSeq res;
    private final TsData tsres;
    private final double ssq;
    private final int n;
    private final int df;
    private final int dfc;
    private final Map<String, StatisticalTest> tests;

    @Generated
    TsResiduals(@NonNull ResidualsType type, @NonNull DoubleSeq res, TsData tsres, double ssq, int n, int df, int dfc, Map<String, StatisticalTest> tests) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (res == null) {
            throw new NullPointerException("res is marked non-null but is null");
        }
        this.type = type;
        this.res = res;
        this.tsres = tsres;
        this.ssq = ssq;
        this.n = n;
        this.df = df;
        this.dfc = dfc;
        this.tests = tests;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull Builder builder() {
        return new Builder();
    }

    @NonNull
    @Generated
    public ResidualsType getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public DoubleSeq getRes() {
        return this.res;
    }

    @Generated
    public TsData getTsres() {
        return this.tsres;
    }

    @Generated
    public double getSsq() {
        return this.ssq;
    }

    @Generated
    public int getN() {
        return this.n;
    }

    @Generated
    public int getDf() {
        return this.df;
    }

    @Generated
    public int getDfc() {
        return this.dfc;
    }

    @Generated
    public Map<String, StatisticalTest> getTests() {
        return this.tests;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TsResiduals)) {
            return false;
        }
        TsResiduals other = (TsResiduals)o;
        if (Double.compare(this.getSsq(), other.getSsq()) != 0) {
            return false;
        }
        if (this.getN() != other.getN()) {
            return false;
        }
        if (this.getDf() != other.getDf()) {
            return false;
        }
        if (this.getDfc() != other.getDfc()) {
            return false;
        }
        ResidualsType this$type = this.getType();
        ResidualsType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        DoubleSeq this$res = this.getRes();
        DoubleSeq other$res = other.getRes();
        if (this$res == null ? other$res != null : !this$res.equals(other$res)) {
            return false;
        }
        TsData this$tsres = this.getTsres();
        TsData other$tsres = other.getTsres();
        if (this$tsres == null ? other$tsres != null : !((Object)this$tsres).equals(other$tsres)) {
            return false;
        }
        Map<String, StatisticalTest> this$tests = this.getTests();
        Map<String, StatisticalTest> other$tests = other.getTests();
        return !(this$tests == null ? other$tests != null : !((Object)this$tests).equals(other$tests));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ssq = Double.doubleToLongBits(this.getSsq());
        result = result * 59 + (int)($ssq >>> 32 ^ $ssq);
        result = result * 59 + this.getN();
        result = result * 59 + this.getDf();
        result = result * 59 + this.getDfc();
        ResidualsType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        DoubleSeq $res = this.getRes();
        result = result * 59 + ($res == null ? 43 : $res.hashCode());
        TsData $tsres = this.getTsres();
        result = result * 59 + ($tsres == null ? 43 : ((Object)$tsres).hashCode());
        Map<String, StatisticalTest> $tests = this.getTests();
        result = result * 59 + ($tests == null ? 43 : ((Object)$tests).hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "TsResiduals(type=" + String.valueOf((Object)this.getType()) + ", res=" + String.valueOf(this.getRes()) + ", tsres=" + String.valueOf(this.getTsres()) + ", ssq=" + this.getSsq() + ", n=" + this.getN() + ", df=" + this.getDf() + ", dfc=" + this.getDfc() + ", tests=" + String.valueOf(this.getTests()) + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private ResidualsType type;
        @Generated
        private DoubleSeq res;
        @Generated
        private TsData tsres;
        @Generated
        private double ssq;
        @Generated
        private int n;
        @Generated
        private int df;
        @Generated
        private int dfc;
        @Generated
        private ArrayList<String> tests$key;
        @Generated
        private ArrayList<StatisticalTest> tests$value;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder type(@NonNull ResidualsType type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder res(@NonNull DoubleSeq res) {
            if (res == null) {
                throw new NullPointerException("res is marked non-null but is null");
            }
            this.res = res;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder tsres(TsData tsres) {
            this.tsres = tsres;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder ssq(double ssq) {
            this.ssq = ssq;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder n(int n) {
            this.n = n;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder df(int df) {
            this.df = df;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder dfc(int dfc) {
            this.dfc = dfc;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder test(String testKey, StatisticalTest testValue) {
            if (this.tests$key == null) {
                this.tests$key = new ArrayList();
                this.tests$value = new ArrayList();
            }
            this.tests$key.add(testKey);
            this.tests$value.add(testValue);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder tests(@org.jspecify.annotations.NonNull Map<? extends String, ? extends StatisticalTest> tests) {
            if (tests == null) {
                throw new NullPointerException("tests cannot be null");
            }
            if (this.tests$key == null) {
                this.tests$key = new ArrayList();
                this.tests$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends StatisticalTest> $lombokEntry : tests.entrySet()) {
                this.tests$key.add($lombokEntry.getKey());
                this.tests$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearTests() {
            if (this.tests$key != null) {
                this.tests$key.clear();
                this.tests$value.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull TsResiduals build() {
            Map<String, StatisticalTest> tests;
            switch (this.tests$key == null ? 0 : this.tests$key.size()) {
                case 0: {
                    tests = Collections.emptyMap();
                    break;
                }
                case 1: {
                    tests = Collections.singletonMap(this.tests$key.get(0), this.tests$value.get(0));
                    break;
                }
                default: {
                    tests = new LinkedHashMap(this.tests$key.size() < 0x40000000 ? 1 + this.tests$key.size() + (this.tests$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.tests$key.size(); ++$i) {
                        tests.put(this.tests$key.get($i), this.tests$value.get($i));
                    }
                    tests = Collections.unmodifiableMap(tests);
                }
            }
            return new TsResiduals(this.type, this.res, this.tsres, this.ssq, this.n, this.df, this.dfc, tests);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "TsResiduals.Builder(type=" + String.valueOf((Object)this.type) + ", res=" + String.valueOf(this.res) + ", tsres=" + String.valueOf(this.tsres) + ", ssq=" + this.ssq + ", n=" + this.n + ", df=" + this.df + ", dfc=" + this.dfc + ", tests$key=" + String.valueOf(this.tests$key) + ", tests$value=" + String.valueOf(this.tests$value) + ")";
        }
    }
}

