/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.polynomials;

import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;

public final class Coefficients {
    public static final double EPSILON = 1.0E-9;
    private static final double[] C_ZERO = new double[]{0.0};
    private static final double[] C_ONE = new double[]{1.0};
    private static final double[] C_POSINF = new double[]{Double.POSITIVE_INFINITY};
    private static final double[] C_NEGINF = new double[]{Double.NEGATIVE_INFINITY};
    private static final double[] C_NAN = new double[]{Double.NaN};

    public static double[] fromDegree(int degree) {
        double[] c = new double[degree + 1];
        c[degree] = 1.0;
        return c;
    }

    public static double[] ofInternal(double[] c) {
        int nd = Coefficients.getUsedCoefficients(c, 1.0E-9);
        if (nd == c.length) {
            return c;
        }
        if (nd == 0) {
            return C_ZERO;
        }
        return Arrays.copyOf(c, nd);
    }

    public static double[] of(double[] c) {
        int nd = Coefficients.getUsedCoefficients(c, 1.0E-9);
        if (nd == c.length) {
            return (double[])c.clone();
        }
        if (nd == 0) {
            return C_ZERO;
        }
        return Arrays.copyOf(c, nd);
    }

    public static double[] of(double c0, @NonNull double[] c) {
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        int nd = Coefficients.getUsedCoefficients(c, 1.0E-9);
        if (nd == 0) {
            if (Math.abs(c0) <= 1.0E-9) {
                return C_ZERO;
            }
            if (c0 == 1.0) {
                return C_ONE;
            }
            return new double[]{c0};
        }
        double[] nc = new double[nd + 1];
        nc[0] = c0;
        for (int i = 0; i < nd; ++i) {
            nc[i + 1] = c[i];
        }
        return nc;
    }

    public static double[] zero() {
        return C_ZERO;
    }

    public static double[] one() {
        return C_ONE;
    }

    public static double[] positiveInfinity() {
        return C_POSINF;
    }

    public static double[] negativeInfinity() {
        return C_NEGINF;
    }

    public static double[] nan() {
        return C_NAN;
    }

    public static int getUsedCoefficients(double[] coefficients, double eps) {
        int n;
        for (n = coefficients.length; n > 0 && Math.abs(coefficients[n - 1]) <= eps; --n) {
        }
        return n;
    }

    @Generated
    private Coefficients() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

